/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.util.ModelUtil;

public class CharacterDataType
extends PredefinedDataType {
    public CharacterDataType() {
    }

    public CharacterDataType(int domain, String name) {
        super(domain, name);
    }

    public CharacterDataType(int domain, String name, String definition, DataTypeAttribute[] attributes) {
        super(domain, name, definition, attributes);
    }

    public CharacterDataType(int domain, String name, long minSize, long maxSize) {
        super(domain, name);
        this.addAttribute(new DataTypeAttribute("size", minSize, maxSize), 0);
    }

    public CharacterDataType(int domain, String name, String definition, long minSize, long maxSize, long defaultSize, boolean isSizeMandatory, DataTypeAttribute[] attributes) {
        super(domain, name, definition, attributes);
        this.addAttribute(new DataTypeAttribute("size", 157, minSize, new Long(maxSize), new Long(defaultSize), isSizeMandatory), 0);
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
        CharacterDataType.validateDefaultValue(defaultValue, this, dataTypeUsage, dbObject);
    }

    public static void validateDefaultValue(Object defaultValue, DataType dataType, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        String strDefaultValue;
        String string = strDefaultValue = defaultValue == null ? null : defaultValue.toString().trim();
        if (dataTypeUsage != null && ModelUtil.hasLength((String)strDefaultValue)) {
            PlsqlNode node = CharacterDataType.parseDefaultValue(strDefaultValue, dataType, dbObject);
            if (node == null) {
                return;
            }
            if (ParserUtils.isConstant(node)) {
                int defaultValueLength;
                Long dataTypeSize;
                assert (dataTypeUsage instanceof PredefinedDataTypeUsage);
                PredefinedDataTypeUsage usage = (PredefinedDataTypeUsage)dataTypeUsage;
                DataTypeAttribute size = dataType.getDataTypeAttribute("size");
                Long l = dataTypeSize = size != null && size.isDeclarable() ? DataTypeHelper.getLongAttributeValue(usage, "size") : size.getMaxValue();
                if (dataTypeSize == null) {
                    dataTypeSize = (Long)size.getDefaultValue();
                }
                if (dataTypeSize != null && (long)(defaultValueLength = (strDefaultValue = ParserUtils.getConstant(node)).length() - (strDefaultValue.charAt(0) == '\'' ? 2 : 0)) > dataTypeSize) {
                    throw new DefaultValueValidationException(dbObject, dataType.getName(), DBArb.format(205, new Long(defaultValueLength), dataTypeSize));
                }
            }
        }
    }
}

