/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

public class ViewColumn
extends Column {
    public ViewColumn() {
    }

    public ViewColumn(DBObjectID selectID) {
        this.setSelectObjectID(selectID);
    }

    public DBObjectID getSelectObjectID() {
        return (DBObjectID)this.getProperty("selectObjectID");
    }

    public void setSelectObjectID(DBObjectID selectID) {
        this.setProperty("selectObjectID", selectID);
    }

    private SelectObject getSelectObject() {
        DBObjectID selectID = this.getSelectObjectID();
        if (selectID != null) {
            try {
                DBObject obj = selectID.resolveID();
                if (obj instanceof SelectObject) {
                    return (SelectObject)obj;
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Couldn't resolve ID to get view column name: " + dbe.getMessage());
            }
        }
        return null;
    }

    public String getName() {
        String retval = super.getName();
        if (retval == null) {
            SelectObject sel = this.getSelectObject();
            if (sel != null) {
                if (ModelUtil.hasLength((String)sel.getAlias())) {
                    retval = sel.getAlias();
                } else {
                    SQLFragment exp = sel.getExpression();
                    if (exp != null && exp instanceof AbstractFromObjectUsage && (retval = sel.getName()) != null && retval.contains(".")) {
                        retval = retval.substring(retval.indexOf(".") + 1);
                    }
                }
            }
            this.setName(retval);
        }
        return retval == null ? "" : retval;
    }

    public boolean isAsterisk() {
        SelectObject sel = this.getSelectObject();
        if (sel != null && sel.getExpression() != null && sel.getExpression() instanceof ColumnKeywordUsage) {
            String name = sel.getName();
            if (name.indexOf(".") > 0) {
                name = name.substring(name.indexOf(".") + 1);
            }
            if ("*".equals(name)) {
                return true;
            }
        }
        return false;
    }
}

