/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public class View
extends Relation
implements SQLQueryOwner {
    public static final String TYPE = "VIEW";
    public static final String READ_ONLY = "WITH READ ONLY";
    public static final String CHECK_OPTION = "WITH CHECK OPTION";

    public View() {
        this((String)null, (Schema)null);
    }

    public View(String name, Schema schema) {
        super(name, schema);
        this.setForceOnCreate(false);
    }

    @Transient
    public String getViewText() {
        SQLQuery query = this.getSQLQuery();
        if (query == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(query.getSQLText().trim());
        String restriction = this.getQueryRestriction();
        if (restriction != null) {
            buff.append("\n");
            buff.append(restriction);
        }
        return buff.toString();
    }

    @Transient
    public void setViewText(String text) {
        String restriction;
        NonDeclarativeSQLQuery query;
        StringBuilder sb = new StringBuilder(text);
        if (text == null) {
            query = null;
            restriction = null;
        } else if (text.trim().endsWith(READ_ONLY)) {
            query = new NonDeclarativeSQLQuery(text.substring(0, text.lastIndexOf(READ_ONLY)).trim());
            restriction = READ_ONLY;
        } else if (text.trim().endsWith(CHECK_OPTION)) {
            query = new NonDeclarativeSQLQuery(text.substring(0, text.lastIndexOf(CHECK_OPTION)).trim());
            restriction = CHECK_OPTION;
        } else {
            query = new NonDeclarativeSQLQuery(text);
            restriction = null;
        }
        this.setSQLQuery(query);
        this.setQueryRestriction(restriction);
    }

    public SQLQuery getSQLQuery() {
        return (SQLQuery)this.getProperty("SQLQuery");
    }

    public void setSQLQuery(SQLQuery query) {
        this.setProperty("SQLQuery", query);
    }

    public boolean isDeclarative() {
        return this.getSQLQuery() instanceof DeclarativeSQLQuery;
    }

    public String getType() {
        return TYPE;
    }

    public String getQueryRestriction() {
        return (String)this.getProperty("queryRestriction");
    }

    public void setQueryRestriction(String restriction) {
        this.setProperty("queryRestriction", restriction);
    }

    public boolean isForceOnCreate() {
        return (Boolean)this.getProperty("forceOnCreate", false);
    }

    public void setForceOnCreate(boolean force) {
        this.setProperty("forceOnCreate", force);
    }
}

