/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;

public class TemporaryObjectID
implements DBObjectID {
    private DBObject m_obj;
    private DBObject m_original;
    private String m_toString;

    private TemporaryObjectID(DBObject obj) {
        this.m_obj = obj;
        this.m_original = null;
    }

    public Object copyTo(Object target) {
        TemporaryObjectID copy = target == null ? new TemporaryObjectID(null) : (TemporaryObjectID)target;
        copy.m_obj = this.m_obj;
        copy.m_original = this.m_original;
        return copy;
    }

    public final boolean equals(Object obj) {
        return obj instanceof DBObjectID && this.equals((DBObjectID)obj, false);
    }

    public final boolean equals(DBObjectID id) {
        return this.equals(id, true);
    }

    public boolean equals(DBObjectID id, boolean strict) {
        if (id == null) {
            return false;
        }
        if (id instanceof TemporaryObjectID) {
            TemporaryObjectID other = (TemporaryObjectID)id;
            if (this.m_obj == other.m_obj) {
                return true;
            }
            if (!strict && this.getType().equals(other.getType())) {
                if (this.m_obj == other.m_obj || this.m_original != null && this.m_original == other.m_original) {
                    return true;
                }
                if (this.isInOriginalHeirachy(other.m_obj)) {
                    return true;
                }
                if (other.isInOriginalHeirachy(this.m_obj)) {
                    return true;
                }
            }
        } else if (id != null && this.m_original != null && id.equals(this.m_original.getID(), strict)) {
            return true;
        }
        if (!strict) {
            return this.isSameName(id);
        }
        return false;
    }

    private NameBasedID getNameBasedID() {
        NameBasedID thisName = null;
        if (this.m_obj != null) {
            thisName = new NameBasedID(this.m_obj, (AbstractDBObjectProvider)null);
        } else if (this.m_original != null) {
            thisName = new NameBasedID(this.m_original, (AbstractDBObjectProvider)null);
        }
        return thisName;
    }

    private boolean isSameName(DBObjectID other) {
        NameBasedID thisName = this.getNameBasedID();
        if (thisName != null) {
            if (other instanceof TemporaryObjectID) {
                NameBasedID otherName = ((TemporaryObjectID)other).getNameBasedID();
                return otherName != null && thisName.equals(otherName, false);
            }
            if (other instanceof BaseObjectID && other.equals(thisName, false)) {
                return true;
            }
            try {
                DBObject otherObj = other.resolveID();
                if (otherObj != null) {
                    NameBasedID otherName = new NameBasedID(otherObj, (AbstractDBObjectProvider)null);
                    return otherName.equals(thisName, false);
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Could not resolve " + other.toString() + " for comparison: " + dbe.getMessage());
            }
        }
        return false;
    }

    private boolean isInOriginalHeirachy(DBObject other) {
        if (other != null) {
            DBObjectID origID;
            if (other == this.m_original) {
                return true;
            }
            DBObjectID dBObjectID = origID = this.m_original == null ? null : this.m_original.getID();
            if (origID instanceof TemporaryObjectID) {
                return ((TemporaryObjectID)origID).isInOriginalHeirachy(other);
            }
        }
        return false;
    }

    public static DBObject findOriginalObject(TemporaryObjectID id) throws DBException {
        DBObject original = id.m_original;
        if (original != null && original.getID() instanceof TemporaryObjectID) {
            DBObject candidate = TemporaryObjectID.findOriginalObject((TemporaryObjectID)original.getID());
            return candidate != null ? candidate : original;
        }
        return original;
    }

    public String getType() {
        return this.m_obj.getType();
    }

    public DBObjectID getParent() {
        return null;
    }

    public DBObject resolveID() throws DBException {
        return this.m_obj;
    }

    public DBObject resolveOriginalID() throws DBException {
        return this.m_original;
    }

    public String toString() {
        if (this.m_toString == null) {
            StringBuilder buff = new StringBuilder("TempObjID: ");
            if (this.m_original != null) {
                buff.append(DBUtil.getFullyQualifiedName(this.m_original, true));
                buff.append(" copy ");
            } else if (this.m_obj != null) {
                buff.append(DBUtil.getFullyQualifiedName(this.m_obj, true));
                buff.append(" new ");
            }
            this.m_toString = buff.toString();
        }
        return this.m_toString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static DBObjectID createID(DBObject obj) {
        assert (obj != null);
        return new TemporaryObjectID(obj);
    }

    public static void setID(DBObject obj, boolean recurse) {
        assert (obj != null);
        if (obj.getID() == null) {
            obj.setID(TemporaryObjectID.createID(obj));
        }
        if (recurse) {
            for (DBObject child : obj.getOwnedObjects()) {
                TemporaryObjectID.setID(child, true);
            }
        }
    }

    public static DBObjectID createID(DBObject obj, DBObject original) {
        assert (obj != null);
        TemporaryObjectID tid = new TemporaryObjectID(obj);
        tid.m_original = original;
        return tid;
    }

    public static DBObjectID findOriginalID(TemporaryObjectID id) {
        if (id.m_original != null) {
            DBObjectID nextID = id.m_original.getID();
            if (nextID == id) {
                throw new IllegalStateException("Infinite TemporaryObjectID loop.");
            }
            if (nextID instanceof TemporaryObjectID) {
                return TemporaryObjectID.findOriginalID((TemporaryObjectID)nextID);
            }
            return nextID;
        }
        return null;
    }
}

