/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaObjectManager
extends CascadeManager {
    private static final DBObjectID[] EMPTY_ID = new DBObjectID[0];
    private boolean m_registeredAll;
    private final Map<DBObjectID, Collection<DBObjectID>> m_deps = new HashMap<DBObjectID, Collection<DBObjectID>>();
    private final Map<DBObjectID, Collection<DBObjectID>> m_soDeps = new HashMap<DBObjectID, Collection<DBObjectID>>();
    private final Map<String, Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>>> m_danglers = new HashMap<String, Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>>>();

    public SchemaObjectManager(DBObjectProvider provider) {
        super(provider);
    }

    protected final boolean haveRegisteredAll() {
        return this.m_registeredAll;
    }

    protected void clearAllCaches() {
        this.m_registeredAll = false;
        this.m_deps.clear();
        this.m_soDeps.clear();
        this.m_danglers.clear();
    }

    protected boolean supportsUnresolvedReferences() {
        return false;
    }

    protected boolean couldFixUnresolvedReferences(DBObject obj) {
        return false;
    }

    protected boolean resolvesUnresolvedReference(DBObjectID id, DBObjectID unresolved) {
        return false;
    }

    public void registerObject(SystemObject obj) {
        this.registerObject(obj, false);
    }

    public void registerObject(SystemObject obj, boolean loadOnly) {
        if (this.shouldRegister(obj, loadOnly)) {
            this.registerObject(obj, obj);
        }
    }

    protected boolean shouldRegister(SystemObject obj, boolean loadOnly) {
        boolean register = this.m_registeredAll;
        if (!register) {
            register = !this.needsInitialization(obj) && (obj instanceof View || obj instanceof Synonym || obj instanceof Table || obj instanceof Trigger || obj instanceof MaterializedViewLog);
        }
        return register;
    }

    protected final boolean needsInitialization(SystemObject obj) {
        return DBUtil.needsBuilding(obj);
    }

    public void unregisterObject(SystemObject obj) {
        if (this.m_registeredAll) {
            DBObjectID id = obj.getID();
            if (id != null && this.supportsUnresolvedReferences()) {
                for (Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> sos : this.m_danglers.values()) {
                    if (!sos.containsKey(id)) continue;
                    sos.remove(id);
                }
            }
            this.unregisterImpl(obj);
        }
    }

    @Deprecated
    public DBObjectID[] getSchemaObjectReferers(SystemObject obj, boolean deep) {
        Collection<DBObjectID> refs = this.listTopLevelReferers(obj, deep);
        DBObjectID[] retval = refs != null && refs.size() > 0 ? refs.toArray(new DBObjectID[refs.size()]) : EMPTY_ID;
        return retval;
    }

    @Override
    public Collection<DBObjectID> listTopLevelReferers(SystemObject obj, boolean deep) {
        this.checkInit();
        DBObjectID id = obj.getID();
        Collection<DBObjectID> refs = this.getSchemaObjectReferersImpl(id, deep ? new HashSet() : null);
        if (obj instanceof Schema) {
            refs = this.includeSchemaObjects((Schema)obj, refs);
        }
        return refs == null ? Collections.emptyList() : refs;
    }

    protected Collection<DBObjectID> includeSchemaObjects(Schema schema, Collection<DBObjectID> refs) {
        try {
            SchemaObject[] objs;
            DBObjectProvider pro = this.getProvider();
            for (SchemaObject schemaObj : objs = pro.listObjects(pro.listObjectTypes(), schema)) {
                DBObjectID schemaObjID;
                if (refs == null) {
                    refs = new HashSet<DBObjectID>();
                }
                if ((schemaObjID = schemaObj.getID()) == null) continue;
                refs.add(schemaObjID);
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger(this).log(Level.WARNING, "Error listing objects in schema {0}: {1}", new Object[]{schema.getName(), dbe.getMessage()});
        }
        return refs;
    }

    @Deprecated
    public DBObjectID[] getReferers(DBObject obj) {
        Collection<DBObjectID> refs = this.listReferers(obj);
        if (refs != null && refs.size() > 0) {
            return refs.toArray(new DBObjectID[refs.size()]);
        }
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listReferers(DBObject obj) {
        this.checkInit();
        DBObjectID id = obj.getID();
        Collection<DBObjectID> retval = null;
        if (id != null) {
            retval = this.m_deps.get(id);
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    public boolean hasUnresolvedReference(SystemObject obj, String refType) {
        DBObjectID id;
        this.checkInit();
        Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> danglersForType = this.m_danglers.get(refType);
        if (danglersForType != null && (id = obj.getID()) != null) {
            return danglersForType.containsKey(id);
        }
        return false;
    }

    @Override
    public Collection<Difference> resolveUnresolvedReferences(SystemObject obj) {
        ArrayList<ResultSet> retval = null;
        if (this.supportsUnresolvedReferences() && this.couldFixUnresolvedReferences(obj)) {
            this.checkInit();
            ArrayList<SystemObject> originals = new ArrayList<SystemObject>();
            ArrayList<SystemObject> updates = new ArrayList<SystemObject>();
            Map<String, Collection<DBObject>> typeMap = this.createDanglersTypeMap(obj, null);
            for (String refType : typeMap.keySet()) {
                Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> danglersForType = this.m_danglers.get(refType);
                if (danglersForType == null) continue;
                for (Map.Entry<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> soToChildren : danglersForType.entrySet()) {
                    DBObjectID key = soToChildren.getKey();
                    Map<DBObjectID, Collection<DBObjectID>> kiddies = soToChildren.getValue();
                    for (Map.Entry<DBObjectID, Collection<DBObjectID>> childEntry : kiddies.entrySet()) {
                        DBObjectID refererId = childEntry.getKey();
                        try {
                            DBObject referer = refererId.resolveID();
                            if (referer == null) {
                                DBLog.log("SchemaObjectManager contains unresolvable ID " + refererId, new Object[0]);
                                continue;
                            }
                            HashMap<DBObjectID, DBObjectID> replacements = null;
                            Collection<DBObjectID> refs = childEntry.getValue();
                            if (refs != null) {
                                for (DBObjectID unresolved : refs) {
                                    Collection<DBObject> objs = typeMap.get(refType);
                                    for (DBObject couldResolve : objs) {
                                        DBObjectID id;
                                        if (referer instanceof FKConstraint && unresolved instanceof ReferenceID) {
                                            Relation rel = ((FKConstraint)referer).getRelation();
                                            ReferenceID refTabID = (ReferenceID)unresolved.getParent();
                                            if (rel.getName().equals(refTabID.getName()) && rel.getSchema().getName().equals(refTabID.getSchemaName())) continue;
                                        }
                                        if (!this.resolvesUnresolvedReference(id = couldResolve.getID(), unresolved)) continue;
                                        if (replacements == null) {
                                            replacements = new HashMap<DBObjectID, DBObjectID>();
                                        }
                                        replacements.put(unresolved, id);
                                        this.registerDependency((SystemObject)key.resolveID(), referer, id);
                                    }
                                }
                            }
                            if (replacements == null || replacements.size() <= 0) continue;
                            this.replaceReferences(originals, updates, referer, (Map<DBObjectID, DBObjectID>)replacements);
                        }
                        catch (DBException e) {}
                    }
                }
            }
            if (originals.size() > 0) {
                retval = new ArrayList<ResultSet>();
                DiffEngine de = this.getProvider().getDiffEngine();
                for (int i = 0; i < originals.size(); ++i) {
                    ResultSet diff = de.diff(originals.get(i), updates.get(i)).getResult();
                    retval.add(diff);
                }
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    private Map<String, Collection<DBObject>> createDanglersTypeMap(DBObject obj, Map<String, Collection<DBObject>> map) {
        HashMap<String, Collection<DBObject>> hashMap = map = map != null ? map : new HashMap<String, Collection<DBObject>>();
        if (this.m_danglers.containsKey(obj.getType())) {
            this.mapKeyToCollection(obj.getType(), obj, map);
        }
        DBObject[] kids = obj.getOwnedObjects();
        for (int i = 0; i < kids.length; ++i) {
            this.createDanglersTypeMap(kids[i], map);
        }
        return map;
    }

    private void replaceReferences(List<SystemObject> originals, List<SystemObject> updates, DBObject referer, Map<DBObjectID, DBObjectID> replacements) {
        SystemObject soUpdateMe = null;
        SystemObject so = null;
        ArrayList<DBObject> trail = new ArrayList<DBObject>();
        if (referer instanceof SystemObject) {
            so = (SystemObject)referer;
        } else {
            DBObject parent = referer;
            while (!(parent instanceof SystemObject)) {
                trail.add(0, parent);
                parent = parent.getParent();
            }
            so = (SystemObject)parent;
        }
        int index = this.indexOf(originals, so);
        if (index == -1) {
            soUpdateMe = (SystemObject)so.copyTo(null, true);
            originals.add(so);
            updates.add(soUpdateMe);
        } else {
            soUpdateMe = updates.get(index);
        }
        DBObject updateReferer = this.findMatchingChild(soUpdateMe, trail);
        updateReferer.replaceReferenceIDs(replacements);
    }

    private int indexOf(List<SystemObject> objs, SystemObject s) {
        int retval = -1;
        Comparator<DBObject> c = DBUtil.getNameComparator();
        for (int i = 0; i < objs.size(); ++i) {
            if (c.compare(objs.get(i), s) != 0) continue;
            retval = i;
            break;
        }
        return retval;
    }

    private DBObject findMatchingChild(SystemObject copy, List<DBObject> trailToChild) {
        DBObject result = copy;
        for (DBObject child : trailToChild) {
            String childType = child.getType();
            String childName = child.getName();
            if (ModelUtil.hasLength((String)childName)) {
                result = result.findOwnedObject(childType, childName);
                continue;
            }
            result = result.getOwnedObjects(childType)[0];
        }
        return result;
    }

    private void unregisterImpl(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            DBObjectID[] refs = obj.getReferenceIDs();
            for (int i = 0; i < refs.length; ++i) {
                Collection<DBObjectID> referers;
                if (!this.m_deps.containsKey(refs[i]) || (referers = this.m_deps.get(refs[i])) == null) continue;
                referers.remove(id);
                if (referers.size() >= 1) continue;
                this.m_deps.remove(refs[i]);
            }
            DBObject[] kids = obj.getOwnedObjects();
            for (int i = 0; i < kids.length; ++i) {
                this.unregisterImpl(kids[i]);
            }
            if (obj instanceof SystemObject) {
                Iterator<Map.Entry<DBObjectID, Collection<DBObjectID>>> iter = this.m_soDeps.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<DBObjectID, Collection<DBObjectID>> e = iter.next();
                    Collection<DBObjectID> referers = e.getValue();
                    if (referers == null) continue;
                    referers.remove(id);
                    if (referers.size() >= 1) continue;
                    iter.remove();
                }
            }
        }
    }

    private void unregisterChildren(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            if (this.m_deps.containsKey(id)) {
                Collection<DBObjectID> deps = this.m_deps.remove(id);
            }
            DBObject[] kids = obj.getOwnedObjects();
            for (int i = 0; i < kids.length; ++i) {
                this.unregisterChildren(kids[i]);
            }
        }
    }

    private Collection<DBObjectID> getSchemaObjectReferersImpl(DBObjectID id, Collection<DBObjectID> refs) {
        Collection<DBObjectID> newRefs;
        if (id != null && (newRefs = this.m_soDeps.get(id)) != null && newRefs.size() > 0) {
            if (refs == null) {
                refs = newRefs;
            } else {
                for (DBObjectID deepID : newRefs) {
                    if (deepID == null || refs.contains(deepID)) continue;
                    refs.add(deepID);
                    this.getSchemaObjectReferersImpl(deepID, refs);
                }
            }
        }
        return refs;
    }

    private void registerObject(SystemObject key, DBObject obj) {
        DBObjectID[] ids = obj.getReferenceIDs();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] instanceof TemporaryObjectID) {
                DBLog.getLogger(this).warning("WARNING: attempt to cache temporary ID with the dependency manager");
                continue;
            }
            if (this.supportsUnresolvedReferences() && this.isUnresolvedReference(ids[i])) {
                this.registerUnresolvedReference(key, obj, ids[i]);
                continue;
            }
            this.registerDependency(key, obj, ids[i]);
        }
        DBObject[] kids = obj.getOwnedObjects();
        for (int i = 0; i < kids.length; ++i) {
            this.registerObject(key, kids[i]);
        }
    }

    private void registerSchemaObjectDependency(SystemObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        this.addMapping(id, referedTo, this.m_soDeps);
    }

    private void registerDependency(SystemObject key, DBObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        if (!(referedTo instanceof DataTypeID)) {
            this.addMapping(id, referedTo, this.m_deps);
            DBObjectID referedToParent = DBUtil.getUppermostParent(referedTo);
            if (referedToParent != null && key != null) {
                this.registerSchemaObjectDependency(key, referedToParent);
            }
        }
    }

    private void addMapping(DBObjectID id, DBObjectID refID, Map deps) {
        if (refID != null && id != null && !refID.equals(id)) {
            this.mapKeyToCollection(refID, id, deps);
        }
    }

    private <K, T> void mapKeyToCollection(K key, T itemForCollection, Map<K, Collection<T>> map) {
        Collection<T> c = map.get(key);
        if (c == null) {
            c = new HashSet<T>();
            map.put(key, c);
        }
        c.add(itemForCollection);
    }

    private void registerUnresolvedReference(SystemObject key, DBObject referer, DBObjectID ref) {
        Collection<DBObjectID> referers;
        Map<DBObjectID, Collection<DBObjectID>> childObjectRefs;
        DBObjectID soID = key.getID();
        DBObjectID id = referer.getID();
        String refType = ref.getType();
        Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> danglersForType = this.m_danglers.get(refType);
        if (danglersForType == null) {
            danglersForType = new HashMap<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>>();
            this.m_danglers.put(refType, danglersForType);
        }
        if ((childObjectRefs = danglersForType.get(soID)) == null) {
            childObjectRefs = new HashMap<DBObjectID, Collection<DBObjectID>>();
            danglersForType.put(soID, childObjectRefs);
        }
        if ((referers = childObjectRefs.get(id)) == null) {
            referers = new HashSet<DBObjectID>();
            childObjectRefs.put(id, referers);
        }
        if (!referers.contains(ref)) {
            referers.add(ref);
        }
    }

    protected void checkInit() {
    }

    protected final synchronized void registerAllObjects() {
        try {
            this.clearAllCaches();
            this.m_registeredAll = true;
            String[] types = this.listObjectTypes();
            Schema[] schemas = this.listSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                this.setRegisterProgress(0, 1, i, schemas.length, schemas[i].getName());
                SchemaObject[] objects = this.getProvider().listObjects(types, schemas[i]);
                for (int j = 0; j < objects.length; ++j) {
                    this.setRegisterProgress(j, objects.length, i, schemas.length, schemas[i].getName());
                    this.registerObject(objects[j]);
                }
            }
        }
        catch (DBException dbe) {
            DBLog.logStackTrace(dbe);
            this.m_registeredAll = false;
        }
    }

    protected String[] listObjectTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        String[] t = this.getProvider().listObjectTypes();
        for (int i = 0; i < t.length; ++i) {
            retval.add(t[i]);
        }
        retval.remove("SEQUENCE");
        retval.remove("PACKAGE");
        retval.remove("FUNCTION");
        retval.remove("PROCEDURE");
        return retval.toArray(new String[retval.size()]);
    }

    protected Schema[] listSchemas() throws DBException {
        return this.getProvider().listSchemas();
    }

    protected void setRegisterProgress(int objN, int objT, int schemaN, int schemaT, String schemaName) {
    }

    @Deprecated
    public static final SystemObject[] getDependencies(SystemObject obj, DBObjectProvider pro, boolean recurse) {
        Collection<SystemObject> refs = pro.getCascadeManager().listReferencedObjects(obj, recurse);
        return refs.toArray(new SystemObject[refs.size()]);
    }
}

