/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.ColumnConstraintReferenceID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.util.ModelUtil;

public class ReferenceID
extends BaseObjectID
implements ColumnConstraintReferenceID {
    private String m_subtype;
    private String m_dbName;
    private Object m_identifier;
    private List<String> m_childObjectNames = new ArrayList<String>();

    public ReferenceID() {
    }

    public ReferenceID(DBObjectID id) throws DBException {
        this(id, null);
    }

    public ReferenceID(DBObjectID id, DBObjectProvider pro) throws DBException {
        DBObject obj = null;
        obj = id.resolveID();
        this.initialise(obj, id, pro);
    }

    public ReferenceID(DBObject obj) {
        this(obj, (DBObjectProvider)null);
    }

    public ReferenceID(DBObject obj, DBObjectProvider pro) {
        try {
            this.initialise(obj, obj.getID(), pro);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Error initialising reference: " + dbe.getMessage());
        }
    }

    public ReferenceID(String type, String schemaName, String name) {
        this(type, schemaName, null, name, null, null, null);
    }

    public ReferenceID(String type, Schema schema, String name) {
        this(type, schema, name, null);
    }

    public ReferenceID(String type, Schema schema, String name, String dbName) {
        this(type, null, null, name, null, dbName, null);
        this.setSchema(schema);
    }

    public ReferenceID(String type, DBObjectID parent, String name, String subtype, String[] childObjectNames) {
        this(type, null, parent, name, subtype, null, childObjectNames);
    }

    private ReferenceID(String type, String schemaName, DBObjectID parent, String name, String subtype, String dbName, String[] childObjectNames) {
        this.setType(type);
        this.setName(name);
        this.setSchemaName(schemaName);
        this.setParent(parent);
        this.setChildObjectNames(childObjectNames);
        this.m_dbName = dbName;
        this.m_subtype = subtype;
    }

    public void construct(String id) {
        String[] items = id.split(":");
        if (items.length > 3) {
            this.setType(" ".equals(items[0]) ? null : items[0]);
            this.setSchemaName(" ".equals(items[1]) ? null : items[1]);
            this.setName(" ".equals(items[2]) ? null : items[2]);
            this.setDatabaseName(" ".equals(items[3]) ? null : items[3]);
        }
        StringBuilder parentIdBuilder = new StringBuilder();
        for (int index = 4; index < items.length; ++index) {
            parentIdBuilder.append(items[index]);
            if (index >= items.length - 1) continue;
            parentIdBuilder.append(":");
        }
        if (parentIdBuilder.length() > 0) {
            this.setParent(BaseObjectID.createFromString(parentIdBuilder.toString()));
        }
    }

    private void initialise(DBObject obj, DBObjectID id, DBObjectProvider pro) throws DBException {
        DBObjectID par;
        if (obj != null) {
            this.initialise(obj);
        } else if (id instanceof BaseObjectID) {
            id.copyTo(this);
        }
        if (pro instanceof AbstractDBObjectProvider) {
            this.setProviderImpl((AbstractDBObjectProvider)pro);
        }
        if ((par = this.getParent()) != null && !(par instanceof ReferenceID)) {
            par = new ReferenceID(par, this.getProvider());
            this.setParent(par);
        }
        if (id instanceof IdentifierBasedID) {
            this.m_identifier = ((IdentifierBasedID)id).getIdentifier();
        }
    }

    private void initialise(DBObject obj) {
        DBObject objPar = obj.getParent();
        if (objPar != null) {
            this.setParent(new ReferenceID(objPar));
        }
        this.setType(obj.getType());
        this.setName(obj.getName());
        if (obj instanceof SchemaObject) {
            this.setSchema(((SchemaObject)obj).getSchema());
        }
        if (obj instanceof Constraint) {
            this.setSubType(((Constraint)obj).getConstraintType());
        } else if (obj instanceof ComplexType) {
            this.setSubType(((ComplexType)obj).getCollectionType());
        }
        if (obj instanceof ColumnConstraint) {
            for (Column c : ((ColumnConstraint)obj).getColumns()) {
                this.addChildObjectName(c);
            }
        }
    }

    public final String[] getChildObjectNames() {
        return this.m_childObjectNames.toArray(new String[this.m_childObjectNames.size()]);
    }

    public final void setChildObjectNames(String[] names) {
        this.m_childObjectNames.clear();
        if (names != null) {
            for (String s : names) {
                this.m_childObjectNames.add(s);
            }
        }
    }

    public final String getSubType() {
        return this.m_subtype;
    }

    public final void setSubType(String subType) {
        this.m_subtype = subType;
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    public final void setDatabaseName(String linkName) {
        this.m_dbName = linkName;
    }

    public final Object getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(Object obj) {
        this.m_identifier = obj;
    }

    @Deprecated
    public final DBObject resolveReference(Database db) {
        try {
            return DBUtil.resolveInOtherProvider(this, db);
        }
        catch (DBException dbe) {
            return null;
        }
    }

    @Deprecated
    public final DBObjectID getNewID() {
        return null;
    }

    @Deprecated
    public final String[] getColumnNames() {
        return this.getChildObjectNames();
    }

    protected boolean equalsImpl(DBObjectID id, boolean strict) {
        boolean equal;
        boolean bl = equal = id instanceof ReferenceID && this.equalsImpl((ReferenceID)id);
        if (!equal && !strict) {
            Object ident;
            if (id instanceof IdentifierBasedID && this.m_identifier != null && (ident = ((IdentifierBasedID)id).getIdentifier()) != null && this.m_identifier != null && ident.getClass() == this.m_identifier.getClass() && ModelUtil.areEqual((Object)this.getType(), (Object)id.getType()) && ident.equals(this.m_identifier)) {
                equal = true;
            }
            if (!equal && id instanceof BaseObjectID && this.hasSameObjectName((BaseObjectID)id)) {
                equal = true;
            }
            if (!equal && !(id instanceof ReferenceID)) {
                try {
                    DBObject obj = id.resolveID();
                    if (obj != null && ModelUtil.areEqual((Object)this.getName(), (Object)obj.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)obj.getType())) {
                        if (obj instanceof SchemaObject) {
                            Schema schema = ((SchemaObject)obj).getSchema();
                            return schema != null && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getSchemaName());
                        }
                        equal = true;
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
        }
        return equal;
    }

    protected boolean equalsImpl(ReferenceID id) {
        return super.equalsImpl(id) && ModelUtil.areEqual((Object)id.m_subtype, (Object)this.m_subtype) && ModelUtil.areEqual(id.m_childObjectNames, this.m_childObjectNames) && ModelUtil.areEqual((Object)id.m_dbName, (Object)this.m_dbName) && ModelUtil.areEqual((Object)id.m_identifier, (Object)this.m_identifier);
    }

    public Object copyTo(Object target) {
        if (target instanceof BaseObjectID && !(target instanceof ReferenceID)) {
            this.copyToImpl((BaseObjectID)target);
            return target;
        }
        ReferenceID copy = target == null ? new ReferenceID() : (ReferenceID)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(ReferenceID target) {
        super.copyToImpl(target);
        target.m_identifier = this.m_identifier;
        target.m_dbName = this.m_dbName;
        target.m_subtype = this.m_subtype;
        target.setChildObjectNames(this.getChildObjectNames());
    }

    protected String toStringImpl() {
        StringBuilder builder = new StringBuilder();
        String type = this.getType();
        String sName = this.getSchemaName();
        String name = this.getName();
        String dName = this.getDatabaseName();
        builder.append(ModelUtil.hasLength((String)type) ? type : " ").append(":");
        builder.append(ModelUtil.hasLength((String)sName) ? sName : " ").append(":");
        builder.append(ModelUtil.hasLength((String)name) ? name : " ").append(":");
        builder.append(ModelUtil.hasLength((String)dName) ? dName : " ");
        if (this.getParent() instanceof BaseObjectID) {
            builder.append(":").append(this.getParent().toString());
        }
        return builder.toString();
    }

    public DBObject resolveID() throws DBException {
        String type = this.getType();
        DBObjectID par = this.getParent();
        if (par == null && type == null) {
            return this.resolveIDWithoutType();
        }
        try {
            DBObject obj = super.resolveID();
            if (obj != null) {
                return obj;
            }
        }
        catch (MissingProviderException mpe) {
            return null;
        }
        if (type != null && this.getProvider() != null) {
            if (par == null) {
                Object identifier = this.getIdentifier();
                if (identifier != null) {
                    IdentifierBasedID idId = new IdentifierBasedID(type, identifier, (AbstractDBObjectProvider)this.getProvider());
                    try {
                        DBObject obj = idId.resolveID();
                        if (obj != null) {
                            return obj;
                        }
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger().log(Level.FINER, "Resolve ReferenceID with IdentifierBasedID failed: " + dbe.getMessage());
                    }
                }
                String name = this.getName();
                String schemaName = this.getSchemaName();
                if (name != null && schemaName != null) {
                    NameBasedID nameId = new NameBasedID(type, schemaName, name, (AbstractDBObjectProvider)this.getProvider());
                    try {
                        DBObject obj = nameId.resolveID();
                        if (obj != null) {
                            return obj;
                        }
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger().log(Level.FINER, "resolve ReferenceID with NameBasedID failed", dbe);
                    }
                }
            } else if (this.getName() != null) {
                DBObject found;
                DBObject parObj = null;
                try {
                    parObj = par.resolveID();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (parObj != null && (found = parObj.findOwnedObject(type, this.getName())) != null) {
                    return found;
                }
            }
        }
        return null;
    }

    private DBObject resolveIDWithoutType() throws DBException {
        DBObjectCriteria<SystemObject> crit;
        SystemObject retval = null;
        String schemaName = this.getSchemaName();
        String name = this.getName();
        DBObjectProvider pro = this.getProvider();
        if (pro != null && ModelUtil.hasLength((String)schemaName) && ModelUtil.hasLength((String)name) && (retval = pro.getObject(crit = DBObjectCriteria.createCriteria("TABLE", schemaName, name))) == null) {
            String[] types = pro.listObjectTypes();
            for (int i = 0; i < types.length && retval == null; ++i) {
                if (types[i].equals("TABLE")) continue;
                crit.setTypes(types[i]);
                retval = pro.getObject(crit);
            }
        }
        return retval;
    }

    public void addChildObjectName(DBObjectID id) {
        String name;
        if (id instanceof BaseObjectID && ModelUtil.hasLength((String)(name = ((BaseObjectID)id).getName()))) {
            this.addChildObjectName(name);
            return;
        }
        try {
            DBObject obj = id.resolveID();
            if (obj != null) {
                this.addChildObjectName(obj);
                return;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public void addChildObjectName(DBObject obj) {
        if (obj != null) {
            this.addChildObjectName(obj.getName());
        }
    }

    public void addChildObjectName(String name) {
        this.m_childObjectNames.add(name);
    }

    protected DBObject resolveInParentObject(DBObject parent) {
        DBObject retval = super.resolveInParentObject(parent);
        if (retval == null) {
            retval = parent.findOwnedObject(this.getType(), this.getName());
        }
        return retval;
    }
}

