/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.DeclarativePlSqlDelegate;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.property.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlSqlSubprogram
extends PlSql
implements DeclarativePlSql {
    private final DeclarativePlSqlDelegate m_delegate = new DeclarativePlSqlDelegate(this);

    public PlSqlSubprogram() {
        this((String)null, (Schema)null);
    }

    public PlSqlSubprogram(String name, Schema schema) {
        super(name, schema);
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        this.m_delegate.copyToImpl(((PlSqlSubprogram)copy).m_delegate, copyParent, idPolicy);
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject target) {
        return super.equalsImpl(target) && this.m_delegate.equalsImpl(((PlSqlSubprogram)target).m_delegate);
    }

    @Transient
    @Deprecated
    public DataType getReturnType() {
        this.checkInit();
        DataType dt = null;
        DBObjectID id = this.m_delegate.getReturnTypeID();
        if (id != null) {
            try {
                dt = (DataType)id.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return dt;
    }

    @Transient
    @Deprecated
    public void setReturnType(DataType returnType) {
        this.checkInit();
        this.m_delegate.setReturnTypeID(returnType.getID());
    }

    @Override
    public DBObjectID getReturnTypeID() {
        this.checkInit();
        return this.m_delegate.getReturnTypeID();
    }

    @Override
    public void setReturnTypeID(DBObjectID returnTypeID) {
        this.checkInit();
        this.m_delegate.setReturnTypeID(returnTypeID);
    }

    @Override
    public void setParameters(PlSqlParameter[] newParams) {
        this.checkInit();
        this.m_delegate.setParameters(newParams);
    }

    @Override
    public PlSqlParameter[] getParameters() {
        this.checkInit();
        return this.m_delegate.getParameters();
    }

    @Override
    public void addParameter(PlSqlParameter p) {
        this.checkInit();
        this.m_delegate.addParameter(p);
    }

    @Override
    public void addParameter(int index, PlSqlParameter param) {
        this.checkInit();
        this.m_delegate.addParameter(index, param);
    }

    @Override
    public PlSqlParameter getParameter(String name) {
        this.checkInit();
        return this.m_delegate.getParameter(name);
    }

    @Override
    public void removeParameter(PlSqlParameter param) {
        this.checkInit();
        this.m_delegate.removeParameter(param);
    }

    @Override
    @Deprecated
    @Transient
    public String getBody() {
        return this.m_delegate.getBody();
    }

    @Override
    @Deprecated
    @Transient
    public void setBody(String body) {
        this.m_delegate.setBody(body);
    }

    @Override
    @Transient
    public String getSignature() {
        return this.m_delegate.getSignature();
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_delegate.getReturnTypeID() != null) {
            refs.add(this.m_delegate.getReturnTypeID());
        }
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String[] types) {
        super.getOwnedObjectsImpl(c, types);
        for (PlSqlParameter p : this.m_delegate.getParameters()) {
            this.includeOwnedObject(c, p, types);
        }
    }
}

