/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlParameter
extends AbstractChildDBObject {
    public static final String TYPE = "PlSqlParameter";
    private DBObjectID m_dataTypeID;
    private Mode m_mode;
    private String m_default;
    private boolean m_noCopy;

    public PlSqlParameter() {
    }

    public PlSqlParameter(String name) {
        super(name);
    }

    public PlSqlParameter(String name, DataType dataType) {
        super(name);
        if (dataType != null) {
            this.m_dataTypeID = dataType.getID();
        }
    }

    @Override
    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(other, copyParent, idPolicy);
        PlSqlParameter copy = (PlSqlParameter)other;
        copy.m_dataTypeID = this.m_dataTypeID;
        copy.m_mode = this.m_mode;
        copy.m_default = this.m_default;
        copy.m_noCopy = this.m_noCopy;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject other) {
        PlSqlParameter copy = (PlSqlParameter)other;
        return super.equalsImpl(copy) && ModelUtil.areEqual((Object)this.m_dataTypeID, (Object)copy.m_dataTypeID) && ModelUtil.areEqual((Object)((Object)this.m_mode), (Object)((Object)copy.m_mode)) && ModelUtil.areEqual((Object)this.m_default, (Object)copy.m_default) && this.m_noCopy == copy.m_noCopy;
    }

    @Transient
    public DeclarativePlSql getPlSql() {
        return (DeclarativePlSql)this.getParent();
    }

    public DBObjectID getDataTypeID() {
        return this.m_dataTypeID;
    }

    public void setDataTypeID(DBObjectID dataTypeID) {
        this.m_dataTypeID = dataTypeID;
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public void setMode(Mode mode) {
        this.m_mode = mode;
    }

    public String getDefaultValue() {
        return this.m_default;
    }

    public void setDefaultValue(String def) {
        this.m_default = def;
    }

    public void setNoCopy(boolean noCopy) {
        this.m_noCopy = noCopy;
    }

    public boolean isNoCopy() {
        return this.m_noCopy;
    }

    @Transient
    public void setPlSql(DeclarativePlSql object) {
        if (object instanceof DBObject) {
            this.setParent(object);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Transient
    @Deprecated
    public DataType getDataType() {
        DataType dt = null;
        try {
            dt = (DataType)this.m_dataTypeID.resolveID();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return dt;
    }

    @Transient
    @Deprecated
    public void getDataType(DataType datatype) {
        this.m_dataTypeID = datatype.getID();
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_dataTypeID != null) {
            refs.add(this.m_dataTypeID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        IN("IN"),
        OUT("OUT"),
        INOUT("IN OUT");

        private String _value;

        private Mode(String val) {
            this._value = val;
        }

        public String toString() {
            return this._value;
        }
    }
}

