/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlAttribute
extends AbstractChildDBObject {
    public static final String TYPE = "TypeAttribute";
    private DataTypeUsage m_dataTypeUsage;
    private String m_sqljExternalName;

    public PlSqlAttribute() {
    }

    public PlSqlAttribute(String name) {
        super(name);
    }

    public PlSqlAttribute(String name, DataTypeUsage dataTypeUsage) {
        super(name);
        this.m_dataTypeUsage = dataTypeUsage;
    }

    @Deprecated
    public PlSqlAttribute(String name, DataType dataType) {
        super(name);
        this.m_dataTypeUsage = dataType.createDefaultUsage();
    }

    @Override
    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(other, copyParent, idPolicy);
        PlSqlAttribute copy = (PlSqlAttribute)other;
        copy.m_dataTypeUsage = this.copyObject(this.m_dataTypeUsage, copy, idPolicy);
        copy.m_sqljExternalName = this.m_sqljExternalName;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject other) {
        PlSqlAttribute copy = (PlSqlAttribute)other;
        return super.equalsImpl(copy) && ModelUtil.areEqual((Object)this.m_dataTypeUsage, (Object)copy.m_dataTypeUsage) && ModelUtil.areEqual((Object)this.m_sqljExternalName, (Object)copy.m_sqljExternalName);
    }

    @Transient
    public SpecPlSql getSpecPlSql() {
        return (SpecPlSql)this.getParent();
    }

    @Transient
    public void setSpecPlSql(SpecPlSql plsql) {
        this.setParent(plsql);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setSqljExternalName(String sqljExternalName) {
        this.m_sqljExternalName = sqljExternalName;
    }

    public String getSqljExternalName() {
        return this.m_sqljExternalName;
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.changeParent(this.m_dataTypeUsage, dataTypeUsage);
        this.m_dataTypeUsage = dataTypeUsage;
    }

    public DataTypeUsage getDataTypeUsage() {
        return this.m_dataTypeUsage;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_dataTypeUsage, types);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        DBObjectID dtid;
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_dataTypeUsage != null && (dtid = this.m_dataTypeUsage.getDataTypeID()) != null && idMap.containsKey(dtid)) {
            this.m_dataTypeUsage.setDataTypeID(idMap.get(dtid));
            replaced = true;
        }
        return replaced;
    }
}

