/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectCache {
    private Map<String, ObjectTypeEntry> m_typeMap = new TreeMap<String, ObjectTypeEntry>();
    private boolean m_weak;
    private String[] m_objTypes;

    public ObjectCache() {
        this(false);
    }

    public ObjectCache(boolean weak) {
        this.m_weak = weak;
    }

    public void registerBuilder(String type, DBObjectBuilder builder) {
        this.registerType(type, builder, null);
    }

    public void unregisterBuilder(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry.getValidator() == null) {
            this.m_typeMap.remove(type);
            this.m_objTypes = null;
        } else {
            entry.setBuilder(null);
        }
    }

    public DBObjectBuilder getBuilderForType(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? entry.getBuilder() : null;
    }

    public void registerValidator(String type, DBObjectValidator validator) {
        this.registerType(type, null, validator);
    }

    public void unregisterValidator(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry.getBuilder() == null) {
            this.m_typeMap.remove(type);
            this.m_objTypes = null;
        } else {
            entry.setValidator(null);
        }
    }

    protected final DBObjectValidator getValidatorForType(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? entry.getValidator() : null;
    }

    public void registerType(String type, DBObjectBuilder builder, DBObjectValidator validator) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry == null) {
            entry = new ObjectTypeEntry(builder, validator);
            this.m_typeMap.put(type, entry);
            this.m_objTypes = null;
        } else {
            if (builder != null) {
                entry.setBuilder(builder);
            }
            if (validator != null) {
                entry.setValidator(validator);
            }
        }
    }

    public boolean hasTypeEntry(String type) {
        return type != null && this.m_typeMap.containsKey(type);
    }

    public String[] listObjectTypes() {
        if (this.m_objTypes == null) {
            Set<Map.Entry<String, ObjectTypeEntry>> entries = this.m_typeMap.entrySet();
            ArrayList<String> l = new ArrayList<String>();
            for (Map.Entry<String, ObjectTypeEntry> entry : entries) {
                ObjectTypeEntry typeEntry = entry.getValue();
                if (typeEntry == null || typeEntry.getBuilder() == null) continue;
                l.add(entry.getKey());
            }
            this.m_objTypes = l.toArray(new String[l.size()]);
            Arrays.sort(this.m_objTypes);
        }
        return this.m_objTypes;
    }

    public void clearCache(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry != null) {
            entry.clearCache();
        }
    }

    public void clearAllCaches() {
        for (ObjectTypeEntry e : this.m_typeMap.values()) {
            e.clearCache();
        }
    }

    public void cacheObject(SystemObject object) {
        ObjectTypeEntry entry;
        if (object != null && (entry = this.m_typeMap.get(object.getType())) != null) {
            entry.addObjectToCache(object);
        }
    }

    public void uncacheObject(SystemObject object) {
        ObjectTypeEntry entry;
        if (object != null && (entry = this.m_typeMap.get(object.getType())) != null) {
            entry.removeObjectFromCache(object);
        }
    }

    public SystemObject findObject(String type, Schema schema, String name) {
        SystemObject retval = null;
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry != null) {
            retval = entry.findObject(schema, name);
        }
        return retval;
    }

    public SystemObject findObject(DBObjectID id) {
        ObjectTypeEntry entry;
        SystemObject object = null;
        if (id instanceof BaseObjectID && (entry = this.m_typeMap.get(id.getType())) != null) {
            object = entry.findObject((BaseObjectID)id);
        }
        return object;
    }

    public <T extends SystemObject> Collection<T> listObjectsFromCache(DBObjectCriteria<T> criteria) {
        ArrayList<SystemObject> retval = new ArrayList<SystemObject>();
        for (String objectType : criteria.getTypes()) {
            ObjectTypeEntry entry = this.m_typeMap.get(objectType);
            if (entry == null) continue;
            for (ObjectValue value : entry.m_objectMap.values()) {
                SystemObject obj = this.getListedObject(value, criteria);
                if (obj == null) continue;
                retval.add(obj);
            }
        }
        return retval;
    }

    private SystemObject getListedObject(ObjectValue value, DBObjectCriteria criteria) {
        String schemaName = criteria.getSchemaName();
        String nameLike = criteria.getNameLike();
        SystemObject object = value.getObject();
        if (object != null && !criteria.accept(object)) {
            object = null;
        }
        return object;
    }

    private static String getKeyString(SystemObject obj) {
        Schema s = null;
        if (obj instanceof SchemaObject) {
            s = ((SchemaObject)obj).getSchema();
        }
        return ObjectCache.getKeyString(s, obj.getName());
    }

    private static String getKeyString(Schema s, String name) {
        return (s == null ? "" : s.getName() + ".") + name;
    }

    private static class WeakObjectValue
    extends ObjectValue {
        private Reference<SystemObject> m_ref;

        public WeakObjectValue(SystemObject obj) {
            this.m_ref = new WeakReference<SystemObject>(obj);
        }

        public SystemObject getObject() {
            return this.m_ref.get();
        }
    }

    private static class StrongObjectValue
    extends ObjectValue {
        private SystemObject m_obj;

        public StrongObjectValue(SystemObject obj) {
            this.m_obj = obj;
        }

        public SystemObject getObject() {
            return this.m_obj;
        }
    }

    private static abstract class ObjectValue {
        private ObjectValue() {
        }

        public abstract SystemObject getObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectKey
    implements Comparable<ObjectKey> {
        private String m_nameKey;
        private String m_idKey;

        ObjectKey() {
        }

        ObjectKey(SystemObject obj) {
            this.m_nameKey = ObjectCache.getKeyString(obj);
            DBObjectID id = obj.getID();
            if (!(id instanceof BaseObjectID)) {
                throw new IllegalArgumentException("Cached objects must have a valid BaseObjectID");
            }
            this.m_idKey = id.toString();
        }

        @Override
        public int compareTo(ObjectKey obj) {
            int retval = 0;
            retval = this.m_nameKey == null ? this.m_idKey.compareTo(obj.m_idKey) : (this.m_idKey == null ? this.m_nameKey.compareTo(obj.m_nameKey) : this.toString().compareTo(obj.toString()));
            return retval;
        }

        public boolean equals(Object obj) {
            return obj instanceof ObjectKey && this.equalsImpl((ObjectKey)obj);
        }

        private boolean equalsImpl(ObjectKey obj) {
            boolean checked = false;
            boolean retval = true;
            if (this.m_nameKey != null && obj.m_nameKey != null) {
                checked = true;
                retval = ModelUtil.areEqual((Object)this.m_nameKey, (Object)obj.m_nameKey);
            }
            if (retval && this.m_idKey != null && obj.m_idKey != null) {
                checked = true;
                retval = ModelUtil.areEqual((Object)this.m_idKey, (Object)obj.m_idKey);
            }
            return checked && retval;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.m_nameKey + " :: " + this.m_idKey;
        }
    }

    private class ObjectTypeEntry {
        private Map<ObjectKey, ObjectValue> m_objectMap = new HashMap<ObjectKey, ObjectValue>();
        private DBObjectBuilder m_builder;
        private DBObjectValidator m_validator;

        ObjectTypeEntry(DBObjectBuilder builder, DBObjectValidator validator) {
            this.m_builder = builder;
            this.m_validator = validator;
        }

        private DBObjectBuilder getBuilder() {
            return this.m_builder;
        }

        private void setBuilder(DBObjectBuilder builder) {
            assert (builder != null);
            this.m_builder = builder;
        }

        private DBObjectValidator getValidator() {
            return this.m_validator;
        }

        private void setValidator(DBObjectValidator validator) {
            this.m_validator = validator;
        }

        private SystemObject findObject(Schema schema, String name) {
            return this.get(this.createNameOnlyKey(schema, name));
        }

        private SystemObject findObject(SystemObject obj) {
            SystemObject retval = null;
            if (obj != null) {
                Schema s = obj instanceof SchemaObject ? ((SchemaObject)obj).getSchema() : null;
                retval = this.findObject(s, obj.getName());
            }
            return retval;
        }

        private SystemObject findObject(BaseObjectID id) {
            return this.get(this.createIDOnlyKey(id));
        }

        private SystemObject get(ObjectKey key) {
            ObjectValue value = key == null ? null : this.m_objectMap.get(key);
            return value == null ? null : value.getObject();
        }

        private void cacheObject(SystemObject object) {
            SystemObject oldObj;
            ObjectKey key = new ObjectKey(object);
            ObjectValue value = this.createValue(object);
            ObjectValue old = this.m_objectMap.put(key, value);
            if (old != null && (oldObj = old.getObject()) != null && oldObj != object) {
                DBLog.getLogger(this).log(Level.FINE, "Caching " + object.getType() + " " + object.getName() + " but we already have one!");
            }
        }

        private void clearCache() {
            this.m_objectMap.clear();
        }

        private void addObjectToCache(SystemObject object) {
            SystemObject old = this.findObject(object);
            if (old != object) {
                if (old != null) {
                    this.removeObjectFromCache(object);
                }
                if (object != null) {
                    this.cacheObject(object);
                }
            }
        }

        private void removeObjectFromCache(SystemObject obj) {
            if (obj != null) {
                DBObjectID id = obj.getID();
                if (id instanceof BaseObjectID) {
                    this.m_objectMap.remove(new ObjectKey(obj));
                }
                this.m_objectMap.remove(this.createNameOnlyKey(obj));
            }
        }

        private ObjectKey createNameOnlyKey(Schema schema, String name) {
            ObjectKey key = new ObjectKey();
            key.m_nameKey = ObjectCache.getKeyString(schema, name);
            return key;
        }

        private ObjectKey createNameOnlyKey(SystemObject obj) {
            ObjectKey key = new ObjectKey();
            key.m_nameKey = ObjectCache.getKeyString(obj);
            return key;
        }

        private ObjectKey createIDOnlyKey(BaseObjectID id) {
            ObjectKey key = new ObjectKey();
            key.m_idKey = id.toString();
            return key;
        }

        private ObjectValue createValue(SystemObject object) {
            return ObjectCache.this.m_weak ? new WeakObjectValue(object) : new StrongObjectValue(object);
        }
    }
}

