/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IDPolicy {
    private Map<DBObjectID, DBObjectID> m_idMap = new HashMap<DBObjectID, DBObjectID>();

    protected final void copyID(DBObject original, DBObject copy) {
        DBObjectID newID = this.getNewID(original, copy);
        if (newID != null) {
            copy.setID(newID);
            DBObjectID originalID = original.getID();
            if (originalID != null) {
                this.m_idMap.put(originalID, newID);
            }
        }
    }

    protected abstract DBObjectID getNewID(DBObject var1, DBObject var2);

    public final Map<DBObjectID, DBObjectID> getIDMap() {
        return this.m_idMap;
    }

    public final Map<DBObjectID, DBObjectID> getReverseIDMap() {
        HashMap<DBObjectID, DBObjectID> sdrawkcab = new HashMap<DBObjectID, DBObjectID>();
        for (Map.Entry<DBObjectID, DBObjectID> entry : this.m_idMap.entrySet()) {
            DBObjectID value = entry.getValue();
            if (value == null) continue;
            sdrawkcab.put(value, entry.getKey());
        }
        return sdrawkcab;
    }

    public static class DefaultIDPolicy
    extends IDPolicy {
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            if (original.getID() != null && copy.getID() == null) {
                return TemporaryObjectID.createID(copy);
            }
            return null;
        }
    }

    public static class SameIDPolicy
    extends IDPolicy {
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            DBObjectID id;
            DBObjectID retval = id = original.getID();
            if (id instanceof TemporaryObjectID) {
                try {
                    DBObjectID copyID;
                    DBObject originalOriginal = ((TemporaryObjectID)id).resolveOriginalID();
                    if (originalOriginal == copy && (copyID = copy.getID()) != null) {
                        retval = copyID;
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            return retval;
        }
    }

    public static class TemporaryIDPolicy
    extends IDPolicy {
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            return TemporaryObjectID.createID(copy, original);
        }
    }
}

