/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

class DeclarativePlSqlDelegate {
    private final DeclarativePlSql m_realThing;
    private DBObjectID m_returnTypeID;

    DeclarativePlSqlDelegate(DeclarativePlSql realThing) {
        this.m_realThing = realThing;
    }

    private AbstractDBObject.ChildSupport getChildSupport(String propName) {
        return ((AbstractDBObject)((Object)this.m_realThing)).getChildSupport(propName);
    }

    public boolean equalsImpl(DeclarativePlSqlDelegate copy) {
        return ModelUtil.areEqual((Object)this.m_returnTypeID, (Object)copy.m_returnTypeID);
    }

    protected void copyToImpl(DeclarativePlSqlDelegate copy, DBObject copyParent, IDPolicy idPolicy) {
        copy.m_returnTypeID = this.m_returnTypeID;
    }

    public DBObjectID getReturnTypeID() {
        return this.m_returnTypeID;
    }

    public void setReturnTypeID(DBObjectID returnTypeID) {
        this.m_returnTypeID = returnTypeID;
    }

    public void setParameters(PlSqlParameter[] newParams) {
        this.getChildSupport("parameters").setChildArray(newParams);
    }

    public PlSqlParameter[] getParameters() {
        return this.getChildSupport("parameters").getChildArray(PlSqlParameter.class);
    }

    public void addParameter(PlSqlParameter param) {
        this.getChildSupport("parameters").addChild(param);
    }

    public void addParameter(int index, PlSqlParameter param) {
        this.getChildSupport("parameters").addChild(index, (Object)param);
    }

    public PlSqlParameter getParameter(String name) {
        return (PlSqlParameter)this.getChildSupport("parameters").findChild(name);
    }

    public void removeParameter(PlSqlParameter param) {
        this.getChildSupport("parameters").removeChild(param);
    }

    @Deprecated
    @Transient
    public String getBody() {
        return null;
    }

    @Deprecated
    @Transient
    public void setBody(String body) {
    }

    public String getSignature() {
        StringBuffer sb = new StringBuffer(this.m_realThing.getName());
        boolean first = true;
        for (PlSqlParameter p : this.getParameters()) {
            sb.append(first ? "(" : ",");
            first = false;
            sb.append(DataTypeHelper.getTypeStringFromID(p.getDataTypeID(), null));
        }
        if (!first) {
            sb.append(")");
        }
        if (this.getReturnTypeID() != null) {
            sb.append(":");
            sb.append(DataTypeHelper.getTypeStringFromID(this.getReturnTypeID(), null));
        }
        return sb.toString();
    }
}

