/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseFactory
extends DBObjectProviderFactory.Creator {
    private final Map<Class<? extends Database>, String> m_classes = new HashMap<Class<? extends Database>, String>();
    private final List<ConnectionCreator> m_connCreators = new ArrayList<ConnectionCreator>();
    private final List<DatabaseCreator> m_dbCreators = new ArrayList<DatabaseCreator>();
    private DatabaseCreator m_jdbcDatabaseCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatabaseFactory getInstance() {
        DBCore core = DBCore.getInstance();
        Class<DatabaseFactory> clazz = DatabaseFactory.class;
        synchronized (DatabaseFactory.class) {
            DatabaseFactory df = core.get(DatabaseFactory.class);
            if (df == null) {
                df = new DatabaseFactory();
                core.put(df);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return df;
        }
    }

    private DatabaseFactory() {
    }

    String[] decodeIdentifier(String id) {
        try {
            String toDecode = URLDecoder.decode(id, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            String toDecode = id;
        }
        String[] split = id.split("#", 2);
        if (split.length == 1) {
            split = new String[]{null, split[0]};
        }
        return split;
    }

    static String encodeIdentifier(String storeName, String connName) {
        String toEncode = storeName == null ? connName : storeName + "#" + connName;
        try {
            return URLEncoder.encode(toEncode, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return toEncode;
        }
    }

    @Override
    protected String getIdentifier(DBObjectProvider provider) {
        if (provider instanceof Database) {
            return ((Database)provider).getQualifiedName();
        }
        return null;
    }

    private ConnectionCreator findConnectionCreator(String storeName) {
        for (ConnectionCreator factory : DatabaseFactory.getConnectionCreators()) {
            if (!ModelUtil.areEqual((Object)storeName, (Object)factory.getStoreName())) continue;
            return factory;
        }
        DBLog.getLogger(this).warning("Unknown connection store name: " + storeName);
        return null;
    }

    @Override
    protected final DBObjectProvider createProviderImpl(Object identifier) throws DBException {
        Database retval;
        block2: {
            String[] decoded;
            block3: {
                retval = null;
                if (!(identifier instanceof String)) break block2;
                decoded = this.decodeIdentifier((String)identifier);
                if (!ModelUtil.hasLength((String)decoded[0])) break block3;
                ConnectionCreator factory = this.findConnectionCreator(decoded[0]);
                if (factory == null) break block2;
                retval = DatabaseFactory.findOrCreateDatabase(decoded[1], factory);
                break block2;
            }
            if (ModelUtil.hasLength((String)decoded[1])) {
                ConnectionCreator cc;
                Iterator<ConnectionCreator> i$ = DatabaseFactory.getConnectionCreators().iterator();
                while (i$.hasNext() && (retval = DatabaseFactory.findOrCreateDatabase(decoded[1], cc = i$.next())) == null) {
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Database findOrCreateDatabase(String connName, ConnectionCreator factory) throws DBException {
        Database retval;
        ConnectionCreator connectionCreator = factory;
        synchronized (connectionCreator) {
            Database cached = factory.findDatabase(connName);
            retval = cached == null ? DatabaseFactory.createDatabase(connName, factory) : cached;
        }
        return retval;
    }

    public static Database createDatabase(String connName, ConnectionCreator factory) throws DBException {
        Connection conn = DatabaseFactory.createConnection(connName, factory);
        if (conn != null) {
            String storeName = factory.getStoreName();
            Database db = DatabaseFactory.getInstance().createDatabaseImpl(storeName, connName, conn);
            if (db != null) {
                factory.cacheDatabase(connName, db);
                return db;
            }
        }
        return null;
    }

    private Database createDatabaseImpl(String store, String name, Connection conn) throws DBException {
        for (DatabaseCreator c : DatabaseFactory.getDatabaseCreators()) {
            Database db = c.createDatabaseImpl(store, name, conn);
            if (db == null) continue;
            return db;
        }
        DatabaseCreator jdbc = DatabaseFactory.getInstance().getJdbcCreator();
        if (jdbc != null) {
            return jdbc.createDatabaseImpl(store, name, conn);
        }
        return null;
    }

    @Override
    protected DBObjectProvider findProvider(Object identifier) {
        Database retval;
        block2: {
            String[] decoded;
            block3: {
                retval = null;
                if (!(identifier instanceof String)) break block2;
                decoded = this.decodeIdentifier((String)identifier);
                if (!ModelUtil.hasLength((String)decoded[0])) break block3;
                ConnectionCreator factory = this.findConnectionCreator(decoded[0]);
                if (factory == null) break block2;
                retval = factory.findDatabase(decoded[1]);
                break block2;
            }
            if (ModelUtil.hasLength((String)decoded[1])) {
                ConnectionCreator cc;
                Iterator<ConnectionCreator> i$ = DatabaseFactory.getConnectionCreators().iterator();
                while (i$.hasNext() && (retval = (cc = i$.next()).findDatabase(decoded[1])) == null) {
                }
            }
        }
        return retval;
    }

    @Override
    protected DBObjectProvider uncacheProvider(Object identifier) {
        Database retval;
        block2: {
            String[] decoded;
            block3: {
                retval = null;
                if (!(identifier instanceof String)) break block2;
                decoded = this.decodeIdentifier((String)identifier);
                if (!ModelUtil.hasLength((String)decoded[0])) break block3;
                ConnectionCreator factory = this.findConnectionCreator(decoded[0]);
                if (factory == null) break block2;
                retval = factory.uncacheDatabase(decoded[1]);
                break block2;
            }
            if (ModelUtil.hasLength((String)decoded[1])) {
                ConnectionCreator cc;
                Iterator<ConnectionCreator> i$ = DatabaseFactory.getConnectionCreators().iterator();
                while (i$.hasNext() && (retval = (cc = i$.next()).uncacheDatabase(decoded[1])) == null) {
                }
            }
        }
        return retval;
    }

    @Deprecated
    public static final Database findOrCreateDatabase(String name, Connection conn) throws DBException {
        Database db = (Database)DBObjectProviderFactory.findOrCreateProvider(name);
        if (db == null) {
            db = DatabaseFactory.createStandaloneDatabase(name, conn);
        }
        return db;
    }

    public static final Database createStandaloneDatabase(String name, Connection conn) throws DBException {
        return DatabaseFactory.getInstance().createDatabaseImpl(null, name, conn);
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Class providerClass) {
        DatabaseCreator dc;
        for (DatabaseCreator factory : DatabaseFactory.getDatabaseCreators()) {
            DatabaseDescriptor desc = factory.getDatabaseDescriptorImpl(providerClass);
            if (desc == null) continue;
            return desc;
        }
        if (JdbcDatabase.class.isAssignableFrom(providerClass) && (dc = DatabaseFactory.getInstance().getJdbcCreator()) != null) {
            return dc.getDatabaseDescriptorImpl(providerClass);
        }
        return null;
    }

    private DatabaseCreator getJdbcCreator() {
        return this.m_jdbcDatabaseCreator;
    }

    void setJdbcDatabaseCreator(DatabaseCreator dc) {
        this.m_jdbcDatabaseCreator = dc;
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Database db) {
        DatabaseCreator dc;
        for (DatabaseCreator factory : DatabaseFactory.getDatabaseCreators()) {
            DatabaseDescriptor desc = factory.getDatabaseDescriptorImpl(db);
            if (desc == null) continue;
            return desc;
        }
        if (db instanceof JdbcDatabase && (dc = DatabaseFactory.getInstance().getJdbcCreator()) != null) {
            return dc.getDatabaseDescriptorImpl(db);
        }
        return null;
    }

    public static final void registerConnectionCreator(ConnectionCreator cc) {
        if (cc != null) {
            DatabaseFactory.getConnectionCreators().add(0, cc);
        }
    }

    public static final void registerDatabaseCreator(DatabaseCreator dc) {
        if (dc != null) {
            DatabaseFactory.getDatabaseCreators().add(0, dc);
        }
    }

    private static List<DatabaseCreator> getDatabaseCreators() {
        return DatabaseFactory.getInstance().m_dbCreators;
    }

    private static List<ConnectionCreator> getConnectionCreators() {
        return DatabaseFactory.getInstance().m_connCreators;
    }

    public static final <T extends ConnectionCreator> T findConnectionCreator(Class<T> ccc) {
        for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
            if (!cc.getClass().equals(ccc)) continue;
            return (T)cc;
        }
        return null;
    }

    public static final ConnectionCreator findConnectionCreator(Database db) {
        for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
            if (cc.findDatabase(db.getConnectionName()) != db) continue;
            return cc;
        }
        return null;
    }

    public static final Connection createConnection(Database db) throws DBException {
        String connName = db.getConnectionName();
        if (connName != null) {
            return DatabaseFactory.createConnection(connName);
        }
        return db.getConnection();
    }

    private static final Connection createConnection(String connName) throws DBException {
        for (ConnectionCreator factory : DatabaseFactory.getConnectionCreators()) {
            Connection conn = DatabaseFactory.createConnection(connName, factory);
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    private static final Connection createConnection(String connName, ConnectionCreator cc) throws DBException {
        long millis = System.currentTimeMillis();
        Connection conn = cc.createConnectionImpl(connName);
        if (conn != null) {
            DBLog.getLogger().log(DBLog.getTimingLogLevel(), "Opening connection for {0} took {1}ms", new Object[]{connName, Long.toString(System.currentTimeMillis() - millis)});
            return conn;
        }
        return null;
    }

    static void registerProviderClass(Class<? extends Database> clz, String name) {
        if (DatabaseFactory.getClassesMap().containsKey(name)) {
            DBLog.getLogger().warning(name + " is already registered as a database type.");
        }
        DatabaseFactory.getClassesMap().put(clz, name);
    }

    public static Collection<Class<? extends Database>> getClasses() {
        return Collections.unmodifiableCollection(DatabaseFactory.getClassesMap().keySet());
    }

    public static String getDatabaseName(Class<? extends Database> dbClz) {
        String name = null;
        if (dbClz != null && (name = DatabaseFactory.getClassesMap().get(dbClz)) == null) {
            name = DatabaseFactory.getClassesMap().get(JdbcDatabase.class);
        }
        return name;
    }

    private static Map<Class<? extends Database>, String> getClassesMap() {
        return DatabaseFactory.getInstance().m_classes;
    }

    public static abstract class ConnectionCreator {
        protected Map<String, Database> m_dbs;

        protected abstract Connection createConnectionImpl(String var1) throws DBException;

        protected boolean isActive() {
            return true;
        }

        protected abstract String getStoreName();

        public Database findDatabase(String connName) {
            if (this.isActive() && this.m_dbs != null) {
                return this.m_dbs.get(connName);
            }
            return null;
        }

        public synchronized Database uncacheDatabase(String connName) {
            if (this.isActive() && this.m_dbs != null) {
                Database removed = this.m_dbs.remove(connName);
                if (removed != null) {
                    DBObjectProviderFactory.notifyOfRemoval(removed.getQualifiedName(), removed);
                }
                return removed;
            }
            return null;
        }

        protected synchronized void cacheDatabase(String connName, Database db) {
            if (this.m_dbs == null) {
                this.m_dbs = new HashMap<String, Database>();
            }
            this.m_dbs.put(connName, db);
            DBObjectProviderFactory.notifyOfCreation(db.getQualifiedName(), db);
        }

        public synchronized boolean renameDatabase(String oldName, String newName) {
            Database db = this.uncacheDatabase(oldName);
            if (db != null) {
                ((AbstractDatabase)db).setConnectionName(newName);
                this.cacheDatabase(newName, db);
                return true;
            }
            return false;
        }
    }

    public static abstract class DatabaseCreator {
        protected abstract Database createDatabaseImpl(String var1, String var2, Connection var3) throws DBException;

        protected abstract DatabaseDescriptor getDatabaseDescriptorImpl(Class var1);

        protected DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
            return this.getDatabaseDescriptorImpl(db.getClass());
        }
    }
}

