/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectProviderFactory {
    private static List<Creator> s_factories;
    private static Collection<Listener> s_listeners;

    private static Logger getLogger() {
        return DBLog.getLogger(DBObjectProviderFactory.class);
    }

    public static void registerListener(Listener l) {
        if (s_listeners == null) {
            s_listeners = new ArrayList<Listener>();
        }
        if (!s_listeners.contains(l)) {
            s_listeners.add(l);
        }
    }

    public static void unregisterListener(Listener l) {
        if (s_listeners != null) {
            s_listeners.remove(l);
        }
    }

    public static void registerFactory(Creator factory) {
        if (s_factories == null) {
            s_factories = new ArrayList<Creator>();
        }
        if (!s_factories.contains(factory)) {
            s_factories.add(factory);
        }
    }

    public static <T extends Creator> T findFactory(Class<T> clz) {
        for (Creator c : DBObjectProviderFactory.factories()) {
            if (!c.getClass().equals(clz)) continue;
            return (T)c;
        }
        return null;
    }

    public static DBObjectProvider findProvider(Object identifier) {
        DBObjectProvider pro;
        block1: {
            Creator c;
            pro = null;
            if (identifier == null) break block1;
            Iterator<Creator> i$ = DBObjectProviderFactory.factories().iterator();
            while (i$.hasNext() && (pro = (c = i$.next()).findProvider(identifier)) == null) {
            }
        }
        return pro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectProvider findOrCreateProvider(Object identifier) throws DBException {
        DBObjectProvider pro = null;
        if (identifier != null) {
            Iterator<Creator> iter = DBObjectProviderFactory.factories().iterator();
            while (iter.hasNext() && pro == null) {
                Creator c = iter.next();
                pro = c.findProvider(identifier);
                if (pro != null) continue;
                Creator creator = c;
                synchronized (creator) {
                    pro = c.findProvider(identifier);
                    if (pro == null) {
                        pro = DBObjectProviderFactory.createProviderFromFactory(c, identifier);
                    }
                }
            }
        }
        return pro;
    }

    protected static final Collection<Creator> factories() {
        ArrayList<Creator> retval = new ArrayList<Creator>();
        if (s_factories != null) {
            retval.addAll(s_factories);
        }
        retval.add(DatabaseFactory.getInstance());
        return retval;
    }

    private static final DBObjectProvider createProviderFromFactory(Creator factory, Object identifier) throws DBException {
        DBObjectProvider retval = null;
        try {
            retval = factory.createProviderImpl(identifier);
            if (retval != null) {
                DBObjectProviderFactory.notifyOfCreation(factory.getIdentifier(retval), retval);
            }
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            DBLog.logStackTrace(e);
            throw new DBException(e);
        }
        return retval;
    }

    public static final DBObjectProvider uncacheProvider(Object identifier) {
        if (identifier != null) {
            for (Creator c : DBObjectProviderFactory.factories()) {
                DBObjectProvider gone = c.uncacheProvider(identifier);
                if (gone == null) continue;
                DBObjectProviderFactory.notifyOfRemoval(c.getIdentifier(gone), gone);
                return gone;
            }
        }
        return null;
    }

    static void notifyOfCreation(Object identifier, DBObjectProvider pro) {
        DBObjectProviderFactory.getLogger().log(DBLog.getEventLogLevel(), "Provider created using key {0}: {1}", new Object[]{identifier, pro.getClass().getName()});
        if (s_listeners != null) {
            for (Listener l : new ArrayList<Listener>(s_listeners)) {
                try {
                    l.providerCreated(identifier, pro);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static void notifyOfRemoval(Object identifier, DBObjectProvider pro) {
        DBObjectProviderFactory.getLogger().log(DBLog.getEventLogLevel(), "Provider uncached using key {0}", identifier);
        if (s_listeners != null) {
            for (Listener l : new ArrayList<Listener>(s_listeners)) {
                try {
                    l.providerRemoved(identifier, pro);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void notifyOfDelete(Object identifier, DBObjectProvider pro) {
        DBObjectProviderFactory.getLogger().log(DBLog.getEventLogLevel(), "Provider deleted using key {0}: {1}", new Object[]{identifier, pro.getClass().getName()});
        if (s_listeners != null) {
            for (Listener l : new ArrayList<Listener>(s_listeners)) {
                try {
                    l.providerDeleted(identifier, pro);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static abstract class Creator {
        protected abstract DBObjectProvider createProviderImpl(Object var1) throws DBException;

        protected abstract Object getIdentifier(DBObjectProvider var1);

        protected DBObjectProvider uncacheProvider(Object identifier) {
            return null;
        }

        protected DBObjectProvider findProvider(Object identifier) {
            return null;
        }

        protected final void fireProviderDeleted(Object identifier, DBObjectProvider pro) {
            DBObjectProviderFactory.notifyOfDelete(identifier, pro);
        }
    }

    public static interface Listener {
        public void providerCreated(Object var1, DBObjectProvider var2);

        public void providerRemoved(Object var1, DBObjectProvider var2);

        public void providerDeleted(Object var1, DBObjectProvider var2);
    }
}

