/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DBObjectProvider {
    public static final String CREATE_PRIVILEDGE = "CREATE";
    public static final String DELETE_PRIVILEDGE = "DELETE";
    public static final String MODIFY_PRIVILEDGE = "MODIFY";
    @Deprecated
    public static final String NEW_FROM_TEMPLATE_TYPE = "<?>";

    public void addProviderListener(DBObjectProviderListener var1);

    public void removeProviderListener(DBObjectProviderListener var1);

    public boolean canCreate(SystemObject var1, boolean var2);

    public void createObject(SystemObject var1, boolean var2) throws DBException;

    public void createObjects(SystemObject[] var1, boolean var2) throws DBException;

    public boolean canDelete(SystemObject var1, boolean var2);

    public void deleteObject(SystemObject var1, boolean var2) throws DBException;

    public void deleteObjects(SystemObject[] var1, boolean var2) throws DBException;

    public void undeleteObject(SchemaObject var1) throws DBException;

    public void undeleteObjects(SchemaObject[] var1) throws DBException;

    public boolean hasPriviledge(String var1, Schema var2, String var3);

    public String getUniqueName(String var1, DBObject var2, String var3);

    public void validateUniqueName(String var1, DBObject var2, String var3) throws NameInUseException;

    @Deprecated
    public boolean isValidName(String var1);

    public boolean isValidName(String var1, String var2);

    @Deprecated
    public void validateName(String var1) throws InvalidNameException;

    public void validateName(String var1, String var2) throws InvalidNameException;

    public String quoteIdentifier(String var1, boolean var2) throws DBException;

    public String getInternalName(String var1);

    public String getInternalName(String var1, String var2);

    public String getExternalName(String var1);

    public String getExternalName(String var1, String var2);

    public String getIdentifierQuoteString();

    public DatabaseDescriptor getDescriptor();

    public void validateObject(DBObject var1) throws ValidationException;

    @Deprecated
    public void validateObject(DBObject var1, String var2) throws ValidationException;

    public void validateObjectProperty(DBObject var1, String var2) throws ValidationException;

    @Deprecated
    public void validateObjectProperty(DBObject var1, Object var2) throws ValidationException;

    public void validateObject(DBObject var1, DBObject var2) throws ValidationException;

    @Deprecated
    public void validateObject(DBObject var1, DBObject var2, String var3) throws ValidationException;

    public void validateObjectProperty(DBObject var1, DBObject var2, String var3) throws ValidationException;

    @Deprecated
    public void validateObjectProperty(DBObject var1, DBObject var2, Object var3) throws ValidationException;

    @Deprecated
    public void validateSchema(Schema var1) throws ValidationException;

    @Deprecated
    public void validateSchema(Schema var1, Schema var2) throws ValidationException;

    public <T extends SystemObject> T getObject(DBObjectCriteria<T> var1) throws DBException;

    public SchemaObject getObject(String var1, Schema var2, String var3) throws DBException;

    @Deprecated
    public SchemaObjectManager getObjectManager();

    public CascadeManager getCascadeManager();

    public DBObjectFactory getObjectFactory();

    public void updateObjects(Difference var1, boolean var2, boolean var3) throws DBException;

    public void updateObject(SystemObject var1, SystemObject var2) throws DBException;

    public void updateObjects(SystemObject[] var1, SystemObject[] var2) throws DBException;

    public <T extends SystemObject> Collection<T> listObjects(DBObjectCriteria<T> var1) throws DBException;

    public String[] listObjects(String var1, Schema var2) throws DBException;

    public String[] listObjects(String var1, Schema var2, String var3) throws DBException;

    public SchemaObject[] listObjects(String[] var1, Schema var2) throws DBException;

    public SchemaObject[] listObjects(String[] var1, Schema var2, String var3) throws DBException;

    public Long getTimestamp(String var1, Schema var2, String var3) throws DBException;

    public Long getTimestamp(DBObjectID var1) throws DBException;

    public String[] listObjectTypes();

    public boolean supportsObjectType(String var1);

    public DataType[] listSupportedDataTypes();

    public DataType getDataType(String var1);

    public DataType getOrCreateDataType(String var1);

    public Schema[] listSchemas() throws DBException;

    public Schema[] listSchemas(boolean var1) throws DBException;

    public Schema getSchema(String var1) throws DBException;

    public Schema getDefaultSchema() throws DBException;

    public void createSchema(Schema var1, boolean var2) throws DBException;

    public void updateSchema(Schema var1, Schema var2) throws DBException;

    public void deleteSchema(Schema var1, boolean var2) throws DBException;

    public DiffEngine getDiffEngine();

    public PropertyManager getPropertyManager();

    public boolean isEditable(DBObject var1);

    public DBObject getDefaultTemplateForType(String var1);

    public void setDefaultTemplateForType(String var1, DBObject var2);

    public boolean isNewFromTemplateType(String var1);
}

