/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DBObjectFilter<T extends DBObject> {
    public boolean accept(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IDFilter<T extends DBObject>
    implements DBObjectFilter<T> {
        private DBObjectID m_id;
        private boolean m_strict;

        public IDFilter(DBObjectID id, boolean strict) {
            if (id == null) {
                throw new IllegalArgumentException("must initialise with a valid id");
            }
            this.m_id = id;
            this.m_strict = strict;
        }

        @Override
        public boolean accept(T obj) {
            DBObjectID id = obj.getID();
            if (id instanceof TemporaryObjectID) {
                return id.equals(this.m_id, this.m_strict);
            }
            return this.m_id.equals(id, this.m_strict);
        }
    }
}

