/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectFactory {
    private DBObjectProvider m_pro;

    protected DBObjectFactory(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Schema getSchema(DBObject parent) {
        Schema schema;
        Schema schema2 = schema = parent instanceof Schema ? (Schema)parent : DBUtil.getSchema(parent);
        if (schema == null) {
            try {
                schema = this.getProvider().getDefaultSchema();
            }
            catch (DBException dbe) {
                this.getLogger().warning("Couldn't get default schema: " + dbe.getMessage());
            }
        }
        return schema;
    }

    public <T extends DBObject> T newObject(T template) {
        return this.newObject(template, null);
    }

    public <T extends DBObject> T newObject(T template, DBObject parent) {
        try {
            if (template != null) {
                T obj = TemplateExpander.initialiseObject(template);
                if (obj instanceof SchemaObject) {
                    ((SchemaObject)obj).setSchema(this.getSchema(parent));
                } else if (obj instanceof ChildDBObject) {
                    ((ChildDBObject)obj).setParent(parent);
                }
                this.initialiseProperties(obj);
                for (DBObject child : obj.getOwnedObjects("COLUMN", "CONSTRAINT")) {
                    this.initialiseProperties(child);
                }
                return obj;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "cannot instantiate new schema object", e);
        }
        return null;
    }

    public <T extends DBObject> T newObject(Class<T> clz) {
        return this.newObject(clz, null);
    }

    public <T extends DBObject> T newObject(Class<T> clz, DBObject parent) {
        return this.newObject(clz, parent, true);
    }

    public <T extends DBObject> T newObject(Class<T> clz, DBObject parent, boolean useDefaultTemplate) {
        DBObject obj = null;
        try {
            DBObject template;
            obj = (DBObject)clz.newInstance();
            if (useDefaultTemplate && obj instanceof SystemObject && (template = this.m_pro.getDefaultTemplateForType(obj.getType())) != null) {
                return (T)this.newObject(template, parent);
            }
            if (obj instanceof SchemaObject) {
                ((SchemaObject)obj).setSchema(this.getSchema(parent));
            }
            if (obj instanceof ChildDBObject) {
                ((ChildDBObject)obj).setParent(parent);
            }
            this.initialiseProperties(obj);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Cannot instantiate new schema object", e);
        }
        return (T)obj;
    }

    public Object getExternalDefaultValue(DBObject obj, String propertyName) {
        DatabaseDescriptor dd = this.getProvider().getDescriptor();
        return this.getValueImpl(obj, propertyName, dd.getExternalPropertyDefaulters(this.getProvider()));
    }

    public Object getInitialValue(DBObject obj, String propertyName) {
        DatabaseDescriptor dd = this.getProvider().getDescriptor();
        return this.getValueImpl(obj, propertyName, dd.getPropertyInitializers(this.getProvider()));
    }

    private Object getValueImpl(DBObject obj, String propertyName, List<PropertyInitializer> piList) {
        if (piList != null) {
            for (PropertyInitializer pi : piList) {
                String[] propNames = pi.getPropertyNames(obj.getClass());
                if (propNames == null) continue;
                for (String propName : propNames) {
                    if (!propertyName.equals(propName)) continue;
                    try {
                        return pi.getPropertyInitialValue(obj, propName);
                    }
                    catch (PropertyInitializer.InitializationVeto e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private void initialiseProperties(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id == null) {
            id = TemporaryObjectID.createID(obj);
            obj.setID(id);
        }
        DatabaseDescriptor dd = this.getProvider().getDescriptor();
        HashSet<String> done = new HashSet<String>();
        List<PropertyInitializer> piList = dd.getPropertyInitializers(this.getProvider());
        for (PropertyInitializer pi : piList) {
            String[] propNames = pi.getPropertyNames(obj.getClass());
            if (propNames == null) continue;
            for (String propName : propNames) {
                if (done.contains(propName)) continue;
                PropertyHelper help = new PropertyHelper();
                try {
                    help.setPropertyValue(obj, propName, pi.getPropertyInitialValue(obj, propName));
                    done.add(propName);
                }
                catch (PropertyInitializer.InitializationVeto e) {
                    // empty catch block
                }
            }
        }
    }

    public void ensureSchema(SchemaObject obj) {
        Schema objSchema = obj.getSchema();
        if (objSchema != null) {
            try {
                Schema proSchema = this.getProvider().getSchema(objSchema.getName());
                if (proSchema != null && proSchema != objSchema) {
                    obj.setSchema(proSchema);
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).log(Level.WARNING, dbe.getMessage());
            }
        }
    }

    public DBObjectID ensureID(DBObject obj, boolean recurse, boolean forceNames) {
        DBObjectID id;
        if (obj instanceof SchemaObject) {
            this.ensureSchema((SchemaObject)obj);
        }
        if (this.isValidID(id = obj.getID())) {
            this.ensureProvider((BaseObjectID)id);
            this.ensureBaseInfo((BaseObjectID)id, obj, forceNames);
        } else {
            id = this.createID(obj);
        }
        obj.setID(id);
        if (recurse) {
            for (DBObject kid : obj.getOwnedObjects()) {
                this.ensureID(kid, true, forceNames);
            }
        }
        return id;
    }

    protected boolean isValidID(DBObjectID id) {
        return id instanceof BaseObjectID;
    }

    protected BaseObjectID createID(DBObject obj) {
        return new NameBasedID(obj, (AbstractDBObjectProvider)this.getProvider());
    }

    protected void ensureBaseInfo(BaseObjectID id, DBObject obj, boolean forceName) {
        Schema s;
        DBObject parent;
        DBObjectID parentID;
        if (id.getType() == null) {
            id.setType(obj.getType());
        }
        if (forceName || !this.isNameTransient(obj)) {
            id.setName(obj.getName());
        }
        DBObjectID dBObjectID = parentID = (parent = obj.getParent()) == null ? null : this.findParentID(((AbstractDBObject)parent).obtainActualID());
        if (parentID != null) {
            id.setParent(parentID);
        }
        if (obj instanceof SchemaObject && (s = ((SchemaObject)obj).getSchema()) != null) {
            id.setSchemaName(s.getName());
        }
    }

    protected DBObjectID findParentID(DBObjectID parentID) {
        return parentID;
    }

    private boolean isNameTransient(DBObject obj) {
        PropertyInfo info = PropertyHelper.findPropertyInfo(obj.getClass(), "name", this.getProvider().getClass());
        return info == null || info.isTransient();
    }

    public final void ensureProvider(BaseObjectID id) {
        if (id != null && id.getProvider() == null) {
            id.setProvider(this.getProvider());
        }
    }
}

