/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.property.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Constraint
extends AbstractChildDBObject {
    public static final String TYPE = "CONSTRAINT";

    protected Constraint() {
        this((String)null, (Relation)null);
    }

    protected Constraint(String name, Relation relation) {
        super(name, relation);
        this.setEnabled(true);
        if (relation != null) {
            relation.addConstraint(this);
        }
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
    }

    public boolean isEnabled() {
        return (Boolean)this.getProperty("enabled", true);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public abstract String getConstraintType();

    @Transient
    public Relation getRelation() {
        return (Relation)this.getParent();
    }

    @Transient
    public void setRelation(Relation relation) {
        this.setParent(relation);
    }

    public static Collection<Constraint> getConstraints(Relation rel, String ... types) {
        ArrayList<Constraint> retval = new ArrayList<Constraint>();
        if (types != null) {
            Arrays.sort(types);
            for (Constraint con : rel.getConstraints()) {
                if (Arrays.binarySearch(types, con.getConstraintType()) < 0) continue;
                retval.add(con);
            }
        }
        return retval;
    }

    static Collection<String> getConstraintTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("UniqueConstraint");
        retval.add("PKConstraint");
        retval.add("FKConstraint");
        retval.add("CheckConstraint");
        return retval;
    }
}

