/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CascadeManager {
    private DBObjectProvider m_pro;

    protected CascadeManager(DBObjectProvider pro) {
        if (pro == null) {
            throw new NullPointerException("DBObjectProvider cannot be null");
        }
        this.m_pro = pro;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public abstract Collection<DBObjectID> listReferers(DBObject var1);

    public abstract Collection<DBObjectID> listTopLevelReferers(SystemObject var1, boolean var2);

    public SystemObject cascadeDelete(DBObject deleted, SystemObject referer) throws NoCascadeRequiredException {
        return this.cascadeDelete(deleted, referer, true);
    }

    public SystemObject cascadeDelete(DBObject deleted, SystemObject referer, boolean copyIfCascadeRequired) throws NoCascadeRequiredException {
        Schema s;
        SystemObject schemaObject = DBUtil.getSystemObject(deleted);
        SystemObject updated = null;
        boolean deleteReferer = false;
        if (deleted instanceof Schema && referer instanceof SchemaObject && (s = ((SchemaObject)referer).getSchema()) != null && ModelUtil.areEqual((Object)deleted.getName(), (Object)s.getName())) {
            deleteReferer = true;
        }
        if (!deleteReferer) {
            if (referer instanceof View || referer instanceof MaterializedView) {
                SQLQuery query = ((SQLQueryOwner)((Object)referer)).getSQLQuery();
                if (query != null && !(query instanceof NonDeclarativeSQLQuery)) {
                    updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                    SQLQueryOwner updatedOwner = (SQLQueryOwner)((Object)updated);
                    String sqlText = query.getSQLText();
                    SelectObject[] so = query.getSelectObjects();
                    if (so == null || so.length == 0) {
                        StringBuilder sb = new StringBuilder();
                        int pos = sqlText.toUpperCase().indexOf("SELECT");
                        sb.append(sqlText.substring(0, pos + 6)).append(" *").append(sqlText.substring(pos + 6));
                        sqlText = sb.toString();
                    }
                    NonDeclarativeSQLQuery newQuery = new NonDeclarativeSQLQuery(sqlText);
                    updatedOwner.setSQLQuery(newQuery);
                    ((Relation)updated).setColumns(null);
                }
            } else if (referer instanceof Table) {
                if (deleted instanceof ComplexType) {
                    Column[] cols = ((Relation)referer).getColumns();
                    ArrayList<Column> colsGone = new ArrayList<Column>();
                    for (int k = 0; k < cols.length; ++k) {
                        DBObjectID id = cols[k].getDataTypeUsage().getDataTypeID();
                        if (id == null || !id.equals(deleted.getID())) continue;
                        colsGone.add(cols[k]);
                    }
                    if (colsGone.size() > 0) {
                        updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                        Table updatedTable = (Table)updated;
                        for (Column colByeBye : colsGone) {
                            updatedTable.removeColumn(updatedTable.getColumn(colByeBye.getName()));
                        }
                    }
                } else if (deleted instanceof Sequence || deleted instanceof Trigger) {
                    for (Column column : ((Relation)referer).getColumns()) {
                        DBObjectID id = (DBObjectID)column.getProperty(deleted instanceof Sequence ? "AUTO_GENERATED_SEQUENCE" : "AUTO_GENERATED_SEQUENCE_TRIGGER");
                        if (id == null || !id.equals(deleted.getID())) continue;
                        updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                        Table updatedTable = (Table)updated;
                        Column updateCol = updatedTable.getColumn(column.getName());
                        updateCol.setProperty("AUTO_GENERATED_SEQUENCE", null);
                        updateCol.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", null);
                    }
                }
            } else if (referer instanceof Synonym && schemaObject == deleted) {
                DBObjectID refID = ((Synonym)referer).getReference();
                if (refID != null && refID.equals(schemaObject.getID())) {
                    updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                    Synonym updatedSynonym = (Synonym)updated;
                    ReferenceID newID = new ReferenceID(schemaObject);
                    updatedSynonym.setReference(newID);
                }
            } else if (referer instanceof Trigger) {
                if (deleted instanceof Table || deleted instanceof View) {
                    deleteReferer = true;
                }
            } else if (referer instanceof MaterializedViewLog && deleted instanceof Table) {
                deleteReferer = true;
            }
        }
        if (!deleteReferer && referer instanceof Relation && schemaObject instanceof Relation) {
            ArrayList<String> removedCons = new ArrayList<String>();
            ArrayList<String> removedIdxs = new ArrayList<String>();
            if (deleted == schemaObject) {
                Constraint[] cons = ((Relation)schemaObject).getConstraints();
                for (int i = 0; i < cons.length; ++i) {
                    if (!(cons[i] instanceof UniqueConstraint)) continue;
                    this.cascadeConstraintRemove((Relation)referer, (UniqueConstraint)cons[i], removedCons);
                }
            } else if (deleted instanceof UniqueConstraint) {
                this.cascadeConstraintRemove((Relation)referer, (UniqueConstraint)deleted, removedCons);
            } else if (deleted instanceof Column && referer instanceof Table) {
                for (DBObject o : DBUtil.findUsagesIn(deleted, referer)) {
                    if (o instanceof Constraint) {
                        removedCons.add(o.getName());
                        continue;
                    }
                    if (!(o instanceof Index)) continue;
                    removedIdxs.add(o.getName());
                }
            }
            if (removedCons.size() > 0 || removedIdxs.size() > 0) {
                updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                Relation updatedRelation = (Relation)updated;
                for (String conName : removedCons) {
                    updatedRelation.removeConstraint(updatedRelation.getConstraint(conName));
                }
                for (String idxName : removedIdxs) {
                    ((Table)updatedRelation).removeIndex(((Table)updatedRelation).getIndex(idxName));
                }
            }
        }
        if (updated == null && !deleteReferer) {
            throw new NoCascadeRequiredException(referer);
        }
        return updated;
    }

    private SystemObject copyIfRequired(SystemObject updated, SystemObject referer, boolean copy) {
        if (updated == null) {
            updated = copy ? DBUtil.makeTemporaryCopy(referer) : referer;
        }
        return updated;
    }

    private void cascadeConstraintRemove(Relation referer, UniqueConstraint uniqueCon, List<String> removed) {
        for (Constraint refCon : referer.getConstraints()) {
            DBObjectID refID;
            if (!(refCon instanceof FKConstraint) || !(refID = ((FKConstraint)refCon).getReferenceID()).equals(uniqueCon.getID(), true)) continue;
            removed.add(refCon.getName());
        }
    }

    protected void updateObjects(List<SystemObject> originals, List<SystemObject> updates, boolean bulkOperation) throws DBException {
        for (int i = 0; i < originals.size(); ++i) {
            SystemObject orig = originals.get(i);
            SystemObject update = updates.get(i);
            update.copyTo(orig);
            DBObjectChange.fireObjectUpdated(orig);
        }
    }

    public void doCascadeDelete(SystemObject deleted, SystemObject referer) throws DBException {
        try {
            SystemObject updated = this.cascadeDelete(deleted, referer);
            if (updated != null) {
                this.updateObjects(Arrays.asList(referer), Arrays.asList(updated), true);
            }
        }
        catch (NoCascadeRequiredException noCascadeRequiredException) {
            // empty catch block
        }
    }

    public Collection<SystemObject> listReferencedObjects(SystemObject obj, boolean recurse) {
        TreeSet<DBObject> deps = new TreeSet<DBObject>(DBUtil.getNameComparator());
        deps.add(obj);
        this.addDependencies(deps, obj, recurse);
        deps.remove(obj);
        return deps;
    }

    private final void addDependencies(Set<SystemObject> deps, DBObject obj, boolean recurse) {
        if (obj instanceof SystemObject) {
            try {
                DBUtil.ensureDerivedPropertiesBuilt((SystemObject)obj, this.getProvider());
            }
            catch (DBException dbe) {
                CascadeManager.getLogger().log(Level.WARNING, "Couldn't build derived properties of {0} : {1}", new Object[]{DBUtil.getFullyQualifiedName(obj), dbe.getMessage()});
            }
        }
        for (DBObjectID ref : obj.getReferenceIDs()) {
            try {
                DBObject refobj = ref.resolveID();
                if (refobj == null) {
                    CascadeManager.getLogger().log(DBLog.getTraceLogLevel(), "Reference type {0} resolved to null on {1}", new Object[]{ref.getClass().getSimpleName(), DBUtil.getFullyQualifiedName(obj)});
                    continue;
                }
                SystemObject parent = DBUtil.getSystemObject(refobj);
                if (parent == null || deps.contains(parent)) continue;
                deps.add(parent);
                if (!recurse) continue;
                this.addDependencies(deps, parent, recurse);
            }
            catch (DBException e) {
                CascadeManager.getLogger().log(Level.WARNING, "Failed to resolve reference on {0}: {1}" + new Object[]{DBUtil.getFullyQualifiedName(obj), e.getMessage()});
            }
        }
        for (DBObject child : obj.getOwnedObjects()) {
            this.addDependencies(deps, child, recurse);
        }
    }

    public boolean isUnresolvedReference(DBObjectID id) {
        return false;
    }

    public Collection<Difference> resolveUnresolvedReferences(SystemObject obj) {
        return Collections.emptyList();
    }

    private static Logger getLogger() {
        return DBLog.getLogger(CascadeManager.class);
    }

    public static class NoCascadeRequiredException
    extends DBException {
        public NoCascadeRequiredException(DBObject obj) {
            super(obj, "No cascade required.");
        }
    }
}

