/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractSystemObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectListener;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSchemaObject
extends AbstractSystemObject
implements SchemaObject {
    private Schema m_schema;

    protected AbstractSchemaObject() {
    }

    protected AbstractSchemaObject(String name, Schema schema, DBObjectID id) {
        super(name, id);
        this.setSchema(schema);
    }

    protected AbstractSchemaObject(String name, Schema schema) {
        this(name, schema, null);
    }

    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        ((AbstractSchemaObject)copy).m_schema = this.m_schema;
        super.copyToImpl(copy, copyParent, idPolicy);
    }

    protected boolean equalsImpl(AbstractDBObject target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_schema, (Object)((AbstractSchemaObject)target).m_schema);
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public Schema getSchema() {
        return this.m_schema;
    }

    public Object getProperty(String key) {
        if ("schema".equals(key)) {
            return this.getSchema();
        }
        return super.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        if ("schema".equals(key)) {
            this.setSchema((Schema)value);
        } else {
            super.setProperty(key, value);
        }
    }

    @Deprecated
    public final void removeObjectListener(SchemaObjectListener list) {
        if (list instanceof DBObjectListener) {
            this.removeObjectListener((DBObjectListener)((Object)list));
        } else if (list != null) {
            this.removeObjectListener(new ListenerBridge(list));
        }
    }

    @Deprecated
    public final void addObjectListener(SchemaObjectListener list) {
        if (list instanceof DBObjectListener) {
            this.addObjectListener((DBObjectListener)((Object)list));
        } else if (list != null) {
            this.addObjectListener(new ListenerBridge(list));
        }
    }

    private class ListenerBridge
    extends DBObjectListener {
        private SchemaObjectListener m_list;

        ListenerBridge(SchemaObjectListener list) {
            this.m_list = list;
        }

        public void objectUpdated(DBObjectChange change) {
            this.m_list.schemaObjectUpdated(change);
        }

        public boolean equals(Object obj) {
            return obj instanceof ListenerBridge && this.m_list.equals(((ListenerBridge)obj).m_list);
        }
    }
}

