/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabase
extends AbstractDBObjectProvider
implements Database {
    public static final String SQLSTATE_NOT_IMPLEMENTED = "S1C00";
    private String m_connStore;
    private String m_connName;
    private Connection m_conn;
    private Connection m_oldConn;
    private DatabaseDescriptor m_descriptor;
    private boolean m_reconnecting;
    private Statement m_statement;
    private final Lock m_aliveCheckLock = new ReentrantLock();

    protected AbstractDatabase(String connStore, String connName, Connection conn) {
        this.m_connStore = connStore;
        this.m_connName = connName;
        this.m_conn = conn;
        DBLog.getLogger().log(DBLog.getEventLogLevel(), "{0}: new {1}", new Object[]{connName, this.getClass().getName()});
        if (DBObjectRegistry.isActive()) {
            for (Map.Entry<String, DBObjectBuilder> entry : DBObjectRegistry.getInstance().getBuilders(this.getDatabaseType(), this.getDatabaseVersion(), this).entrySet()) {
                this.registerBuilder(entry.getKey(), entry.getValue());
            }
        }
        this.registerBuilders();
        this.registerValidators();
        this.registerExpanders();
    }

    @Deprecated
    protected void sqlTrace(String query) {
    }

    @Deprecated
    protected void sqlTrace(String query, Object[] params) {
    }

    @Override
    public final String getDatabaseType() {
        return this.getDescriptor().getDatabaseType();
    }

    @Override
    public final int getDatabaseVersion() {
        return this.getDescriptor().getDatabaseVersion();
    }

    protected void registerValidators() {
        Map<String, DBObjectValidator> v = this.getDescriptor().getValidators(this);
        for (String type : v.keySet()) {
            this.registerValidator(type, v.get(type));
        }
    }

    @Deprecated
    public DDLGenerator getDDLGenerator() {
        DatabaseDescriptor dd = this.getDescriptor();
        if (dd != null) {
            return dd.getDDLGenerator(this);
        }
        return null;
    }

    protected final boolean exists(SystemObject obj) {
        if (obj != null) {
            String name;
            String type;
            if (obj instanceof MaterializedViewLog) {
                type = "TABLE";
                name = ((MaterializedViewLog)obj).getLogTable();
            } else {
                type = obj.getType();
                name = AbstractDatabase.convertObject(obj);
            }
            return this.exists(type, AbstractDatabase.convertObject(DBUtil.getSchema(obj)), name);
        }
        return false;
    }

    protected abstract void registerBuilders();

    @Override
    public final Connection getConnection() {
        try {
            return this.getConnection(true);
        }
        catch (DBException dBException) {
            return this.getConnectionImpl();
        }
    }

    @Override
    public final Connection getConnection(boolean reconnect) throws DBException {
        if (!this.m_reconnecting && reconnect && !this.isConnectionAlive()) {
            this.reconnect();
        }
        return this.getConnectionImpl();
    }

    private Connection getConnectionImpl() {
        return this.m_conn == null ? this.m_oldConn : this.m_conn;
    }

    @Override
    public final boolean isConnectionAlive() {
        boolean alive = false;
        if (this.m_conn != null) {
            alive = this.testIsConnectionAlive(this.m_conn);
        }
        return alive;
    }

    protected boolean isConnectionAlive(Connection conn) {
        boolean alive = false;
        String stmt = this.getAliveTestStatement();
        if (ModelUtil.hasLength((String)stmt)) {
            StatementWrapper wrap = new StatementWrapper(this.m_connName, conn, stmt);
            wrap.setBypassExecutionProxy(true);
            try {
                alive = wrap.execute();
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.INFO, "isAlive failed for {0}: {1}", new Object[]{this.m_connName, dbe.getMessage()});
            }
        } else {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                alive = true;
            }
            catch (SQLException ex) {
                DBLog.getLogger().log(Level.INFO, "isAlive failed for {0}: {1}", new Object[]{this.m_connName, ex.getMessage()});
            }
        }
        return alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean testIsConnectionAlive(final Connection conn) {
        aliveKey = "CONNECTION_ALIVE";
        checked = this.getCachedTimestamp("CONNECTION_ALIVE");
        if (checked instanceof Boolean) {
            this.getLogger().log(Level.FINE, "Database {0}: isAlive test skipped", new Object[]{this.getName()});
            return (Boolean)checked;
        }
        isAlive = new Holder();
        if (this.m_aliveCheckLock.tryLock()) {
            try {
                r = new Runnable(){

                    public void run() {
                        if (isAlive.get() == null) {
                            isAlive.set((Object)AbstractDatabase.this.isConnectionAlive(conn));
                        }
                    }
                };
                if (Thread.holdsLock(conn)) {
                    r.run();
                }
                t = new Thread(r, "CONNECTION_ALIVE");
                var7_8 = isAlive;
                synchronized (var7_8) {
                    t.start();
                    state = t.getState();
                    while (isAlive.get() == null && state != Thread.State.BLOCKED && state != Thread.State.TERMINATED) {
                        try {
                            isAlive.wait(20L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        state = t.getState();
                    }
                }
                if (t.getState() != Thread.State.BLOCKED) ** GOTO lbl37
                DBLog.getLogger(this).log(Level.FINE, "Alive check for {0} was blocked (connection busy).", new Object[]{this.getConnectionName()});
            }
            finally {
                this.m_aliveCheckLock.unlock();
            }
        } else {
            DBLog.getLogger(this).log(Level.INFO, "Alive check for {0} was skipped (one already in progress).", new Object[]{this.getConnectionName()});
        }
lbl37:
        // 4 sources

        alive = Boolean.FALSE != isAlive.get();
        isAlive.set((Object)Boolean.FALSE);
        this.putCachedTimestampKey("CONNECTION_ALIVE", alive);
        return alive;
    }

    protected String getAliveTestStatement() {
        return null;
    }

    @Override
    public Boolean isConnectionClosed(SQLException sqe) {
        Boolean retval = null;
        if (sqe != null && sqe.getSQLState() == "08003") {
            this.getLogger().info(DBArb.format(432, this.getName()));
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasTransaction() {
        String queryText;
        if (this.m_statement != null) {
            return true;
        }
        if (this.m_conn != null && ModelUtil.hasLength((String)(queryText = this.getTransactionTestQuery()))) {
            final Holder retval = new Holder((Object)false);
            final Holder done = new Holder((Object)false);
            Runnable runner = new Runnable(){

                public void run() {
                    QueryWrapper wrap = new QueryWrapper((Database)AbstractDatabase.this, queryText);
                    QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void processResultSet(ResultSet rs) throws DBException {
                            String id;
                            try {
                                if (rs.next() && ModelUtil.hasLength((String)(id = rs.getString(1)))) {
                                    retval.set((Object)true);
                                }
                            }
                            catch (SQLException sQLException) {
                                Holder holder = done;
                                synchronized (holder) {
                                    done.set((Object)true);
                                    done.notifyAll();
                                }
                            }
                            finally {
                                id = done;
                                synchronized (id) {
                                    done.set((Object)true);
                                    done.notifyAll();
                                }
                            }
                        }
                    };
                    try {
                        wrap.executeQuery(r);
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger().log(Level.INFO, "hasTransaction query failed for {0}: {1}", new Object[]{AbstractDatabase.this.m_connName, dbe.getMessage()});
                    }
                }
            };
            Thread t = new Thread(runner, "DatabaseHasTransactionThread");
            t.start();
            while (!((Boolean)done.get()).booleanValue()) {
                Holder holder = done;
                synchronized (holder) {
                    try {
                        done.wait(200L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (t.getState() == Thread.State.BLOCKED) {
                        DBLog.getLogger().log(Level.INFO, "Connection for \"{0}\" is busy, cannot perform hasTransaction test.", new Object[]{this.m_connName});
                        break;
                    }
                    if (t.getState() == Thread.State.TERMINATED) {
                        break;
                    }
                }
            }
            return (Boolean)retval.get();
        }
        return false;
    }

    protected String getTransactionTestQuery() {
        return null;
    }

    @Override
    public void testSQLStatement(String sql) throws DBException {
        QueryWrapper wrap = new QueryWrapper((Database)this, sql);
        try {
            wrap.executeQuery(null);
        }
        catch (DBException dbe) {
            throw new InvalidSQLException(sql, dbe.getMessage());
        }
    }

    @Override
    public final String getName() {
        return this.m_connName;
    }

    final void setConnectionName(String name) {
        this.m_connName = name;
    }

    @Override
    public final String getConnectionName() {
        return this.m_connName;
    }

    @Override
    public final String getConnectionStore() {
        return this.m_connStore;
    }

    @Override
    public final String getQualifiedName() {
        return DatabaseFactory.encodeIdentifier(this.getConnectionStore(), this.getConnectionName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reconnect() throws DBException {
        if (this.m_reconnecting) {
            DBLog.getLogger().severe(this.getName() + ": failed to reconnect: cannot create new connection");
            return;
        }
        try {
            this.m_reconnecting = true;
            this.closeImpl(false);
            Connection c = DatabaseFactory.createConnection(this);
            if (c != null && c != this.m_conn) {
                this.m_conn = c;
                this.reconnected(this.m_conn);
                this.fireProviderReloaded();
                this.getLogger().info(DBArb.format(434, this.getName()));
            }
        }
        finally {
            this.m_reconnecting = false;
        }
    }

    protected void reconnected(Connection c) {
    }

    @Override
    public void close() {
        this.closeImpl(true);
    }

    private void closeImpl(boolean fireEvent) {
        if (this.m_conn != null) {
            try {
                if (!this.m_conn.isClosed()) {
                    DBLog.getLogger().log(Level.FINE, DBArb.format(366, this.m_connName));
                    this.m_conn.close();
                }
            }
            catch (SQLException sqe) {
                DBLog.getLogger().log(Level.WARNING, DBArb.format(367, this.m_connName) + sqe.getMessage());
            }
            catch (Exception ex) {
                DBLog.getLogger().log(Level.WARNING, DBArb.format(367, this.m_connName) + ex.getMessage(), ex);
            }
            this.m_oldConn = this.m_conn;
            this.m_conn = null;
            this.clearAllCaches();
            if (fireEvent) {
                this.fireProviderClosed();
            }
        }
    }

    @Override
    public boolean exists(String type, String schema, String name) {
        boolean exists = false;
        try {
            DBObjectCriteria<SystemObject> criteria = new DBObjectCriteria<SystemObject>(SystemObject.class, type);
            criteria.setSchemaName(schema);
            criteria.setNameLike(name);
            exists = !this.listObjects(criteria).isEmpty();
        }
        catch (DBException ex) {
            this.getLogger().log(Level.WARNING, DBArb.format(377, type, name, ex.getMessage()));
        }
        return exists;
    }

    @Override
    public boolean isObjectValid(String objectType, String schema, String objectName) {
        return this.exists(objectType, schema, objectName);
    }

    protected final Schema createSchema(String name) {
        Schema s = new Schema(name);
        s.setID(new NameBasedID((DBObject)s, (AbstractDBObjectProvider)this));
        return s;
    }

    protected void finishCreate(SystemObject[] objects, SystemObject[] oldObjects) throws DBException {
        ArrayList<SystemObject> newObjs = new ArrayList<SystemObject>();
        DBException dbe = null;
        for (int i = 0; i < objects.length; ++i) {
            Schema objSchema;
            SystemObject old;
            SystemObject object = objects[i];
            SystemObject systemObject = old = oldObjects == null ? null : oldObjects[i];
            if (old != null) {
                this.uncacheObject(old);
            }
            Schema schema = (objSchema = DBUtil.getSchema(object)) == null ? null : this.findSchema(objSchema.getName());
            SystemObject obj = this.getCreatedObject(object.getType(), schema, object.getName());
            if (obj == null) {
                DBException newE = new DBException((DBObject)object, DBArb.format(369, object.getType(), object.getName()));
                if (dbe == null) {
                    dbe = newE;
                    continue;
                }
                dbe.setNextException(newE);
                continue;
            }
            if (old != null) {
                this.resetObject(old, obj, null);
                continue;
            }
            newObjs.add(obj);
            this.cacheObject(obj, false);
        }
        if (newObjs.size() > 0) {
            ArrayList<SchemaObject> added = new ArrayList<SchemaObject>();
            for (SystemObject sysObj : newObjs) {
                if (!(sysObj instanceof SchemaObject)) continue;
                added.add((SchemaObject)sysObj);
            }
            if (added.size() > 0) {
                SchemaObject[] sos = added.toArray(new SchemaObject[added.size()]);
                this.fireObjectsAdded(sos[0].getSchema(), sos);
            }
        }
        if (dbe != null) {
            throw dbe;
        }
    }

    protected SystemObject getCreatedObject(String type, Schema schema, String name) throws DBException {
        return this.getObject(DBObjectCriteria.createCriteria(type, schema, name));
    }

    protected void finishDelete(SystemObject[] objs) {
        Map<Schema, Collection<SystemObject>> mapped = DBUtil.sortIntoSchemas(objs);
        for (Map.Entry<Schema, Collection<SystemObject>> entry : mapped.entrySet()) {
            Collection<SystemObject> col = entry.getValue();
            this.finishDelete(entry.getKey(), col.toArray(new SystemObject[col.size()]));
        }
    }

    protected void finishDelete(Schema schema, SystemObject[] objs) {
        if (schema != null) {
            ArrayList<SchemaObject> removed = new ArrayList<SchemaObject>();
            for (SystemObject sysObj : objs) {
                if (!(sysObj instanceof SchemaObject)) continue;
                removed.add((SchemaObject)sysObj);
            }
            this.fireObjectsRemoved(schema, removed.toArray(new SchemaObject[removed.size()]));
        }
        for (int i = 0; i < objs.length; ++i) {
            Table t;
            if (objs[i] instanceof Index && (t = ((Index)objs[i]).getTable()) != null) {
                t.removeIndex((Index)objs[i]);
                DBObjectChange.fireObjectUpdated(t);
            }
            SchemaObjectManager mgr = this.getCascadeManager();
            for (DBObjectID ref : ((CascadeManager)mgr).listTopLevelReferers(objs[i], false)) {
                try {
                    SystemObject referer = (SystemObject)ref.resolveID();
                    mgr.doCascadeDelete(objs[i], referer);
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, DBArb.format(374, objs[i].getType(), objs[i].getName(), dbe.getMessage()));
                }
            }
            this.uncacheObject(objs[i]);
        }
    }

    @Override
    protected SystemObject createByIDImpl(DBObjectID id) throws DBException {
        SystemObject object = null;
        if (id instanceof BaseObjectID && !(id instanceof ReferenceID)) {
            BaseObjectID dmdID = (BaseObjectID)id;
            Schema s = this.findSchema(dmdID.getSchemaName());
            object = this.createObjectImpl(dmdID.getType(), s, dmdID.getName());
            if (object != null) {
                object.setID(id);
            }
        }
        return object;
    }

    @Override
    public String getDatabaseSource(String objectType, Schema schema, String objectName) throws DBException {
        return null;
    }

    @Override
    public String getDatabaseSource(String objectType, Schema schema, String objectName, String sourceType) throws DBException {
        return null;
    }

    @Override
    public Schema getDefaultSchema() throws DBException {
        String userName = this.getUserName();
        Schema schema = this.findSchema(userName);
        if (schema == null && this.isUsernameCaseInsensitive() && ModelUtil.hasLength((String)userName)) {
            userName = this.getCasePolicy() == 1 ? userName.toLowerCase() : (this.getCasePolicy() == 2 ? userName.toUpperCase() : userName);
            for (Schema s : this.listSchemas()) {
                if (!userName.equals(s.getName())) continue;
                schema = s;
                break;
            }
        }
        return schema != null ? schema : this.getSchema(null);
    }

    protected boolean isUsernameCaseInsensitive() {
        return true;
    }

    String[] getDatabaseMultiSource(String objectType, Schema schema, String objectName) throws DBException {
        return null;
    }

    @Override
    public boolean supportsDebugging() {
        return false;
    }

    @Override
    protected <T extends SystemObject> T getObjectImpl(DBObjectCriteria<T> criteria) throws DBException {
        ComplexType type;
        if (criteria.isAllowedType("TYPE") && (type = DataTypeRegistry.getInstance().findComplexType(criteria.getNameLike(), criteria.getSchemaName(), this.getClass())) != null) {
            return (T)type;
        }
        return super.getObjectImpl(criteria);
    }

    @Override
    public DatabaseDescriptor getDescriptor() {
        if (this.m_descriptor == null) {
            this.m_descriptor = DatabaseFactory.getDatabaseDescriptor(this);
        }
        return this.m_descriptor;
    }

    @Override
    public boolean canRestrictSchemaList() {
        return false;
    }

    public void setStatement(Statement statement) {
        if (this.m_statement != null && statement != null) {
            throw new IllegalArgumentException("Cannot set statement when already set");
        }
        this.m_statement = statement;
    }

    public void cancelStatement() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected final SystemObject findOrCreateObject(String type, Schema schema, String name, Object idVal) throws DBException {
        DBObjectID id = this.createID(schema, name, type, idVal);
        SystemObject object = this.findObject(type, schema, name);
        if (object == null || ModelUtil.areDifferent((Object)object.getID(), (Object)id)) {
            DBObjectBuilder builder = this.getBuilderForType(type);
            if (builder == null) {
                throw new DBException(null, "missing builder for type " + type);
            }
            object = (SystemObject)builder.createObject(name, schema, id);
            if (object != null) {
                this.markForLazyInit((AbstractBuildableObject)object);
                this.cacheObject(object, true);
            }
        }
        return object;
    }

    public final DBObjectID createID(Schema schema, String name, String type, Object id) {
        BaseObjectID newID;
        if (id == null) {
            newID = new NameBasedID(type, schema == null ? null : schema.getName(), name, this);
        } else {
            IdentifierBasedID ibid = new IdentifierBasedID(type, id, (AbstractDBObjectProvider)this);
            ibid.setName(name);
            if (schema != null) {
                ibid.setSchemaName(schema.getName());
            }
            newID = ibid;
        }
        return newID;
    }

    public String getDBExceptionMessage(SQLException sqe) {
        return sqe.toString();
    }
}

