/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderAdapter;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ObjectCache;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.diff.ResultSetApplier;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObjectProvider
implements DBObjectProvider {
    public static final int MIXED_CASE_NAME_POLICY = 0;
    public static final int LOWER_CASE_NAME_POLICY = 1;
    public static final int UPPER_CASE_NAME_POLICY = 2;
    public static final int CASE_SENSITIVE_NAME_POLICY = 3;
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    public static final String NEW_FROM_TEMPLATE_TYPE = "<?>";
    private final Set<String> m_timestampKeys = new HashSet<String>();
    private final Map m_timestamps = new HashMap();
    private SchemaObjectManager m_objManager;
    private ObjectCache m_objectCache = new ObjectCache();
    private List<DBObjectProviderListener> m_listeners;
    private Collection<SchemaObjectExpander> m_expanders = new ArrayList<SchemaObjectExpander>();
    private DBObjectFactory m_dbObjFactory;
    protected static final String[] EMPTY_LIST = new String[0];

    @Override
    public final void removeProviderListener(DBObjectProviderListener list) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(list);
        }
    }

    @Override
    public final void addProviderListener(DBObjectProviderListener list) {
        if (list != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new ArrayList<DBObjectProviderListener>();
            }
            this.m_listeners.add(list);
        }
    }

    protected final void fireProviderClosed() {
        this.logEvent("fire provider {0} closed", this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.providerClosed(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    public final void fireProviderDeleted() {
        this.logEvent("fire provider {0} deleted", this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.providerDeleted(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireProviderOpened() {
        this.logEvent("fire provider {0} opened", this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.providerOpened(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireProviderReloaded() {
        this.logEvent("fire provider {0} reloaded", this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.providerReloaded(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaAdded(Schema schema) {
        this.logEvent("fire schema {0} added to {1}", schema.getName(), this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.schemaAdded(this, schema);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaUpdated(DBObjectChange change) {
        this.logEvent("fire schema {0} updated in {1}", change.getDBObject().getName(), this.getName());
        this.schemaUpdated(change);
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.schemaUpdated(this, change);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaObjectUpdated(DBObjectChange change) {
        this.logEvent("fire schema object {0} updated in {1}", change.getDBObject().getName(), this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                if (!(next instanceof DBObjectProviderAdapter)) continue;
                DBObjectProviderAdapter adapter = (DBObjectProviderAdapter)next;
                try {
                    adapter.schemaObjectUpdated(this, change);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaRemoved(Schema schema) {
        this.logEvent("fire schema {0} removed from {1}", schema.getName(), this.getName());
        if (this.m_listeners != null) {
            for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                try {
                    next.schemaRemoved(this, schema);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    public final void fireObjectsAdded(Schema schema, SchemaObject[] objs) {
        if (ModelUtil.hasNonNullElement((Object[])objs)) {
            Level level;
            Logger log = this.getLogger();
            if (log.isLoggable(level = DBLog.getEventLogLevel())) {
                StringBuffer b = new StringBuffer();
                b.append("fire SchemaObjects added to ");
                b.append(this.getName());
                b.append(": ");
                for (int i = 0; i < objs.length; ++i) {
                    b.append(DBUtil.getFullyQualifiedName(objs[i], true));
                    b.append(" ");
                }
                this.logEvent(b.toString(), new Object[0]);
            }
            if (this.m_listeners != null) {
                for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                    try {
                        next.schemaObjectsAdded(this, objs[0].getSchema(), objs);
                    }
                    catch (Exception e) {
                        this.processListenerException(next, e);
                    }
                }
            }
        }
    }

    protected final void fireObjectsRemoved(Schema schema, SchemaObject[] objs) {
        if (ModelUtil.hasNonNullElement((Object[])objs)) {
            Level level;
            Logger log = this.getLogger();
            if (log.isLoggable(level = DBLog.getEventLogLevel())) {
                StringBuffer b = new StringBuffer();
                b.append("fire SchemaObjects removed from ");
                b.append(this.getName());
                b.append(": ");
                for (int i = 0; i < objs.length; ++i) {
                    b.append(DBUtil.getFullyQualifiedName(objs[i], true));
                    b.append(" ");
                }
                this.logEvent(b.toString(), new Object[0]);
            }
            if (this.m_listeners != null) {
                for (DBObjectProviderListener next : new ArrayList<DBObjectProviderListener>(this.m_listeners)) {
                    try {
                        next.schemaObjectsRemoved(this, schema, objs);
                    }
                    catch (Exception e) {
                        this.processListenerException(next, e);
                    }
                }
            }
        }
    }

    protected void schemaUpdated(DBObjectChange change) {
    }

    private void processListenerException(DBObjectProviderListener l, Exception e) {
        this.getLogger().log(Level.WARNING, MessageFormat.format("listener {0} threw exception:", l.getClass()), e);
    }

    protected final void registerType(String type, DBObjectBuilder builder, DBObjectValidator validator) {
        this.m_objectCache.registerType(type, builder, validator);
    }

    protected final void registerBuilder(String type, DBObjectBuilder builder) {
        this.registerType(type, builder, null);
    }

    protected final void unregisterBuilder(String type) {
        this.m_objectCache.unregisterBuilder(type);
    }

    protected DBObjectBuilder getBuilderForType(String type) {
        return this.m_objectCache.getBuilderForType(type);
    }

    protected final void registerValidator(String type, DBObjectValidator validator) {
        this.registerType(type, null, validator);
    }

    protected final void unregisterValidator(String type) {
        this.m_objectCache.unregisterValidator(type);
    }

    protected final DBObjectValidator getValidatorForType(String type) {
        return this.m_objectCache.getValidatorForType(type);
    }

    protected SystemObject findObject(String type, Schema schema, String name) {
        return this.m_objectCache.findObject(type, schema, name);
    }

    protected final SystemObject findObject(DBObjectID id) {
        SystemObject object = null;
        if (id != null) {
            object = this.m_objectCache.findObject(id);
        }
        return object;
    }

    public void destroyCache() {
        this.m_objectCache = new ObjectCache();
    }

    protected final void clearCache(String type) {
        this.m_objectCache.clearCache(type);
    }

    protected final void clearAllCaches() {
        this.m_objectCache.clearAllCaches();
        if (this.m_objManager != null) {
            this.m_objManager.clearAllCaches();
        }
    }

    @Override
    public SchemaObjectManager getCascadeManager() {
        if (this.m_objManager == null) {
            this.m_objManager = this.createObjectManager();
        }
        return this.m_objManager;
    }

    @Override
    @Deprecated
    public final SchemaObjectManager getObjectManager() {
        return this.getCascadeManager();
    }

    protected SchemaObjectManager createObjectManager() {
        return new SchemaObjectManager(this);
    }

    protected void cacheObject(SystemObject object, boolean loadOperation) {
        if (object != null) {
            this.m_objectCache.cacheObject(object);
            this.getCascadeManager().registerObject(object, loadOperation);
        }
    }

    protected final void uncacheObject(SystemObject object) {
        if (object != null) {
            this.m_objectCache.uncacheObject(object);
            if (this.m_objManager != null) {
                this.m_objManager.unregisterObject(object);
            }
        }
    }

    protected String[] listObjectsImpl(String type, Schema schema, String ref) throws DBException {
        Collection<SystemObject> objects = this.listObjectsImpl(new String[]{type}, schema, ref);
        String[] names = new String[objects.size()];
        int i = 0;
        for (SystemObject obj : objects) {
            names[i] = obj.getName();
            ++i;
        }
        return names;
    }

    protected Collection<SystemObject> listObjectsImpl(String[] objectTypes, Schema schema, String ref) throws DBException {
        return this.listObjectsImpl(DBObjectCriteria.createCriteria(objectTypes, schema, ref));
    }

    protected abstract <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> var1) throws DBException;

    protected final <T extends SystemObject> Collection<T> listObjectsFromCache(DBObjectCriteria<T> criteria) {
        return this.m_objectCache.listObjectsFromCache(criteria);
    }

    protected <T extends SystemObject> T getObjectImpl(DBObjectCriteria<T> criteria) throws DBException {
        String objectType = criteria.getTypeArray()[0];
        String name = criteria.getNameLike();
        String schemaName = criteria.getSchemaName();
        if (!ModelUtil.hasLength((String)objectType) || !ModelUtil.hasLength((String)name)) {
            return null;
        }
        SystemObject object = null;
        if (this.m_objectCache.hasTypeEntry(objectType)) {
            Schema schema = null;
            if (ModelUtil.hasLength((String)schemaName) && Metadata.getInstance().isSchemaObject(objectType)) {
                schema = this.findSchema(schemaName);
            }
            if ((object = this.m_objectCache.findObject(objectType, schema, name)) == null) {
                object = this.createObjectImpl(objectType, schema, name);
                if (object != null) {
                    this.m_objectCache.cacheObject(object);
                }
            } else if (!criteria.getSkipTimestampCheck()) {
                object = this.checkCachedObject(object);
            }
        }
        return (T)object;
    }

    protected <T extends SystemObject> T checkCachedObject(T object) throws DBException {
        Long t;
        String objectType = object.getType();
        boolean checked = false;
        if (this.supportsTimestamps(objectType) && (t = (Long)object.getProperty(TIMESTAMP_PROPERTY)) != null) {
            checked = true;
            Long t2 = this.getExternalTimestamp(object);
            if (t2 == null || t2.compareTo(t) > 0) {
                SystemObject exists = this.createObjectImpl(objectType, DBUtil.getSchema(object), object.getName());
                if (exists != null) {
                    this.resetObject(object, exists, t2);
                } else {
                    this.uncacheObject(object);
                    object = null;
                }
            }
        }
        if (!checked) {
            DBObjectID id = object.getID();
            if (id != null) {
                boolean bl = checked = this.putCachedTimestampKey(id, true) != null;
            }
            if (checked) {
                this.getLogger().log(Level.FINE, "Database {0}: exists test skipped for {1} {2}", new Object[]{this.getName(), object.getType(), DBUtil.getFullyQualifiedName(object)});
            } else {
                SystemObject obj2 = this.createObjectImpl(objectType, DBUtil.getSchema(object), object.getName());
                if (obj2 == null) {
                    this.uncacheObject(object);
                    object = null;
                } else if (obj2 != object) {
                    this.resetObject(object, obj2, null);
                }
            }
        }
        return object;
    }

    @Override
    public Schema[] listSchemas() throws DBException {
        return this.listSchemas(true);
    }

    @Override
    public Schema[] listSchemas(boolean showAll) throws DBException {
        DBObjectCriteria<Schema> criteria = new DBObjectCriteria<Schema>(Schema.class, new String[0]);
        criteria.setUserOnly(!showAll);
        Collection<Schema> s = this.listObjectsImpl(criteria);
        return s.toArray(new Schema[s.size()]);
    }

    @Override
    public Schema getSchema(String name) throws DBException {
        return this.getSchemaImpl(name, false);
    }

    protected Schema findSchema(String name) throws DBException {
        return this.getSchemaImpl(name, true);
    }

    private Schema getSchemaImpl(String name, boolean skipTimestamps) throws DBException {
        Schema retval = null;
        if (ModelUtil.hasLength((String)name)) {
            DBObjectCriteria<Schema> criteria = new DBObjectCriteria<Schema>(Schema.class, new String[0]);
            criteria.setNameLike(name);
            criteria.setSkipTimestampCheck(skipTimestamps);
            retval = this.getObject(criteria);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resumeTimestampQueries(String key) {
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (this.m_timestampKeys.remove(key)) {
                    if (this.m_timestampKeys.size() == 0) {
                        this.m_timestamps.clear();
                        this.getLogger().log(Level.FINE, "Database {0}: timestamp resume", this.getName());
                    } else {
                        this.getLogger().log(Level.FINE, "Database {0}: timestamp resume called for key {1} but other keys remain.", new Object[]{this.getName(), key});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspendTimestampQueries(String key) {
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (this.m_timestampKeys.isEmpty()) {
                    this.m_timestamps.clear();
                    this.getLogger().log(Level.FINE, "Database {0}: timestamp suspend", this.getName());
                } else {
                    this.getLogger().log(Level.FINE, "Database {0}: timestamp suspend called for key {1} but suspend already active", new Object[]{this.getName(), key});
                }
                this.m_timestampKeys.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getCachedTimestamp(Object obj) {
        Object retval = null;
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (!this.m_timestampKeys.isEmpty()) {
                    retval = this.m_timestamps.get(obj);
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putCachedTimestampKey(Object obj, Object value) {
        Object retval = null;
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (!this.m_timestampKeys.isEmpty()) {
                    retval = this.m_timestamps.put(obj, value);
                }
            }
        }
        return retval;
    }

    public boolean supportsTimestamps(String objectType) {
        return false;
    }

    @Deprecated
    public boolean supportsTimestamps() {
        return false;
    }

    @Override
    public final Long getTimestamp(String type, Schema schema, String objectName) throws DBException {
        SystemObject obj;
        Long result = null;
        if (this.supportsTimestamps(type) && (obj = this.findObject(type, schema, objectName)) != null) {
            result = (Long)obj.getProperty(TIMESTAMP_PROPERTY);
        }
        return result;
    }

    @Override
    public final Long getTimestamp(DBObjectID id) throws DBException {
        if (this.supportsTimestamps(id.getType())) {
            SystemObject obj = this.findObject(id);
            return obj != null ? (Long)obj.getProperty(TIMESTAMP_PROPERTY) : null;
        }
        return null;
    }

    protected DBObject findByID(DBObjectID id) throws DBException {
        String type;
        SystemObject object = null;
        if (id != null && this.m_objectCache.hasTypeEntry(type = id.getType())) {
            Long t2;
            Long t;
            object = this.m_objectCache.findObject(id);
            if (object == null) {
                object = this.createByIDImpl(id);
                if (object != null) {
                    this.m_objectCache.cacheObject(object);
                }
            } else if (this.supportsTimestamps(type) && (t = (Long)object.getProperty(TIMESTAMP_PROPERTY)) != null && ((t2 = this.getExternalTimestamp(object)) == null || t2.compareTo(t) > 0)) {
                SystemObject exists = this.createByIDImpl(id);
                if (exists != null) {
                    this.resetObject(object, exists, t2);
                } else {
                    this.uncacheObject(object);
                    if (object instanceof SchemaObject) {
                        this.fireObjectsRemoved(((SchemaObject)object).getSchema(), new SchemaObject[]{(SchemaObject)object});
                    }
                    object = null;
                }
            }
        }
        return object;
    }

    protected void resetObject(SystemObject object, SystemObject listed, Long timestamp) {
        this.uncacheObject(object);
        this.uncacheObject(listed);
        SystemObject copyOfOriginal = null;
        copyOfOriginal = object instanceof AbstractBuildableObject ? (SystemObject)((AbstractBuildableObject)object).createStaticCopy() : (SystemObject)object.copyTo(null, new IDPolicy.SameIDPolicy());
        try {
            DBObjectID id;
            Schema schema;
            String name;
            if (listed == null) {
                name = object.getName();
                schema = DBUtil.getSchema(object);
                id = object.getID();
            } else {
                name = listed.getName();
                schema = DBUtil.getSchema(listed);
                id = listed.getID();
            }
            SystemObject emptyTemplate = (SystemObject)object.getClass().newInstance();
            emptyTemplate.copyTo((DBObject)object, false);
            object.setName(name);
            object.setID(id);
            if (object instanceof SchemaObject) {
                ((SchemaObject)object).setSchema(schema);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error wiping object properties - object reset may have failed", e);
        }
        if (timestamp != null) {
            object.setProperty(TIMESTAMP_PROPERTY, timestamp);
        }
        this.markForLazyInit((AbstractBuildableObject)object);
        this.cacheObject(object, true);
        if (listed != null && copyOfOriginal != null) {
            DBObjectChange change = ResultSetApplier.fireLazyChangeEvent(object, copyOfOriginal);
            this.fireSchemaObjectUpdated(change);
        }
    }

    protected SystemObject createObjectImpl(String type, Schema schema, String name) throws DBException {
        for (SystemObject obj : this.listObjectsImpl(new String[]{type}, schema, name)) {
            if (!this.isRequestedObject(obj, type, schema, name)) continue;
            return obj;
        }
        return null;
    }

    protected boolean isRequestedObject(SystemObject object, String type, Schema schema, String name) {
        boolean schemasSame = true;
        if (object instanceof SchemaObject) {
            schemasSame = DBUtil.getNameComparator().compare(schema, DBUtil.getSchema(object)) == 0;
        }
        return object != null && ModelUtil.areEqual((Object)type, (Object)object.getType()) && schemasSame && ModelUtil.areEqual((Object)name, (Object)object.getName());
    }

    protected SystemObject createByIDImpl(DBObjectID id) throws DBException {
        return null;
    }

    protected Long getExternalTimestampImpl(SystemObject object) throws DBException {
        return null;
    }

    protected final Long getExternalTimestamp(SystemObject object) throws DBException {
        DBObjectID id = object.getID();
        Object ts = this.getCachedTimestamp(id);
        if (ts instanceof Long) {
            this.getLogger().log(Level.FINE, "Database {0}: timestamp query skipped for id {1}", new Object[]{this.getName(), id});
            return (Long)ts;
        }
        Long result = this.getExternalTimestampImpl(object);
        if (result != null) {
            this.putCachedTimestampKey(id, result);
        }
        return result;
    }

    protected final void markForLazyInit(AbstractBuildableObject object) {
        DBObjectBuilder builder = this.getBuilderForType(object.getType());
        this.markForLazyInit(object, builder);
    }

    protected final void markForLazyInit(AbstractBuildableObject object, DBObjectBuilder builder) {
        if (builder != null) {
            object.getPropertySupport().setBuilder(builder);
        }
    }

    public static String convertObject(DBObject obj) {
        String name = obj != null ? obj.getName() : "";
        return ModelUtil.hasLength((String)name) ? name : "";
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String[] listObjectTypes() {
        return this.m_objectCache.listObjectTypes();
    }

    @Override
    public boolean supportsObjectType(String type) {
        if (this.isNewFromTemplateType(type)) {
            return true;
        }
        Object[] objTypes = this.listObjectTypes();
        return Arrays.binarySearch(objTypes, type) >= 0;
    }

    @Override
    public final String[] listObjects(String objectType, Schema schema) throws DBException {
        return this.listObjects(objectType, schema, null);
    }

    @Override
    public final String[] listObjects(String objectType, Schema schema, String ref) throws DBException {
        return this.listObjectsImpl(objectType, schema, ref);
    }

    @Override
    public final SchemaObject[] listObjects(String[] objectTypes, Schema schema) throws DBException {
        return this.listObjects(objectTypes, schema, null);
    }

    @Override
    public final SchemaObject[] listObjects(String[] objectTypes, Schema schema, String ref) throws DBException {
        Collection<SystemObject> retval = this.listObjectsImpl(this.filterSchemaObjectTypes(objectTypes), schema, ref);
        Iterator<SystemObject> iter = retval.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof SchemaObject) continue;
            iter.remove();
        }
        return retval.toArray(new SchemaObject[retval.size()]);
    }

    private String[] filterSchemaObjectTypes(String[] objectTypes) {
        ArrayList<String> types = new ArrayList<String>();
        if (objectTypes != null) {
            for (String t : objectTypes) {
                if (t != null && Metadata.getInstance().isSchemaObject(t)) {
                    types.add(t);
                    continue;
                }
                this.getLogger().log(Level.FINE, t + " is not a SchemaObject type for listing");
            }
        }
        return types.toArray(new String[types.size()]);
    }

    @Override
    public final <T extends SystemObject> Collection<T> listObjects(DBObjectCriteria<T> criteria) throws DBException {
        return this.listObjectsImpl(criteria);
    }

    @Override
    public final <T extends SystemObject> T getObject(DBObjectCriteria<T> criteria) throws DBException {
        String[] types = criteria.getTypeArray();
        if (types.length != 1) {
            throw new IllegalArgumentException("getObject must be called with a type criterion with only one type.");
        }
        return this.getObjectImpl(criteria);
    }

    @Override
    public final SchemaObject getObject(String objectType, Schema schema, String name) throws DBException {
        SystemObject obj;
        SchemaObject retval = null;
        if (objectType != null && schema != null && ModelUtil.hasLength((String)name) && (obj = this.getObjectImpl(DBObjectCriteria.createCriteria(objectType, schema, name))) instanceof SchemaObject) {
            retval = (SchemaObject)obj;
        }
        return retval;
    }

    @Override
    public boolean hasPriviledge(String type, Schema schema, String priv) {
        return true;
    }

    @Override
    public final void createObject(SystemObject obj, boolean replace) throws DBException {
        this.createObjects(new SystemObject[]{obj}, replace);
    }

    @Override
    public final void deleteObject(SystemObject obj, boolean cascade) throws DBException {
        this.deleteObjects(new SystemObject[]{obj}, cascade);
    }

    @Override
    public final void updateObject(SystemObject oldObject, SystemObject newObject) throws DBException {
        this.updateObjects(new SystemObject[]{oldObject}, new SystemObject[]{newObject});
    }

    @Override
    public final void updateObjects(SystemObject[] oldObjects, SystemObject[] newObjects) throws DBException {
        if (oldObjects == null || newObjects == null || oldObjects.length == 0) {
            return;
        }
        if (oldObjects.length != newObjects.length) {
            throw new IllegalArgumentException("Number of old and new objects don't match");
        }
        DiffEngine de = this.getDiffEngine();
        if (de == null) {
            throw new IllegalStateException("Diff not supported, cannot update objects.");
        }
        ResultSet rs = de.diff(oldObjects = DBUtil.getProviderDefinitions((SystemObject[])oldObjects, (DBObjectProvider)this), newObjects).getResult();
        if (!rs.isSame()) {
            this.updateObjects(rs, false, false);
        }
    }

    @Override
    public void createSchema(Schema schema, boolean replace) throws DBException {
        this.createObject(schema, replace);
    }

    @Override
    public void deleteSchema(Schema schema, boolean cascade) throws DBException {
        this.deleteObject(schema, cascade);
    }

    @Override
    public void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        this.updateObject(oldSchema, newSchema);
    }

    @Override
    public PropertyManager getPropertyManager() {
        DatabaseDescriptor desc = this.getDescriptor();
        if (desc != null) {
            return desc.getDDLGenerator(this);
        }
        return null;
    }

    private DatabaseDescriptor getDescriptorOrFail() {
        DatabaseDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("provider is missing a descriptor");
        }
        return descriptor;
    }

    protected final int getCasePolicy() {
        return this.getDescriptorOrFail().getCasePolicy();
    }

    protected final int getQuotedNameCasePolicy() {
        return this.getDescriptorOrFail().getQuotedNameCasePolicy();
    }

    @Override
    @Deprecated
    public final boolean isValidName(String name) {
        return this.isValidName(null, name);
    }

    @Override
    public final boolean isValidName(String type, String name) {
        return this.getDescriptorOrFail().isValidName(type, name);
    }

    @Override
    @Deprecated
    public final void validateName(String name) throws InvalidNameException {
        this.validateName(null, name);
    }

    @Override
    public final void validateName(String type, String name) throws InvalidNameException {
        this.getDescriptorOrFail().validateName(type, name);
    }

    @Override
    public final String quoteIdentifier(String internalName, boolean force) throws DBException {
        return this.getDescriptorOrFail().quoteIdentifier(internalName, force);
    }

    @Override
    public final String getInternalName(String name, String objectType) {
        return this.getDescriptorOrFail().getInternalName(name, objectType);
    }

    @Override
    public final String getInternalName(String name) {
        return this.getInternalName(name, null);
    }

    @Override
    public final String getExternalName(String name, String objectType) {
        return this.getDescriptorOrFail().getExternalName(name, objectType);
    }

    @Override
    public final String getExternalName(String name) {
        return this.getExternalName(name, null);
    }

    @Override
    public DataType[] listSupportedDataTypes() {
        Collection<DataType> types = this.getDescriptorOrFail().listSupportedDataTypes();
        return types.toArray(new DataType[types.size()]);
    }

    @Override
    public DataType getDataType(String typeName) {
        return this.getDescriptorOrFail().getDataType(typeName);
    }

    @Override
    public DataType getOrCreateDataType(String typeName) {
        DataType type = this.getDataType(typeName);
        if (type == null) {
            Class clz = this.getDescriptorOrFail().getDatabaseClass();
            this.getLogger().log(Level.FINE, "DataTypeRegistry had no \"" + typeName + "\" for provider " + clz.getName());
            type = DataTypeRegistry.getInstance().createUserDataType(typeName, clz);
        }
        return type;
    }

    @Override
    public void validateObject(DBObject object) throws ValidationException {
        DBObjectValidator v = this.getValidatorForType(object.getType());
        if (v == null) {
            throw new MissingValidatorException(object);
        }
        v.validateObject(object);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject object, String property) throws ValidationException {
        this.validateObjectProperty(object, property);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(DBObject object, Object property) throws ValidationException {
        this.validateObjectProperty(object, property == null ? null : String.valueOf(property));
    }

    @Override
    public void validateObjectProperty(DBObject object, String property) throws ValidationException {
        if (property == null) {
            this.validateObject(object);
        } else {
            DBObjectValidator v = this.getValidatorForType(object.getType());
            if (v == null) {
                throw new MissingValidatorException(object);
            }
            v.validateObjectProperty(object, property);
        }
    }

    @Override
    @Deprecated
    public void validateSchema(Schema schema) throws ValidationException {
        this.validateObject(schema);
    }

    @Override
    public void validateObject(DBObject original, DBObject update) throws ValidationException {
        DBObjectValidator v = this.getValidatorForType(update.getType());
        if (v == null) {
            throw new MissingValidatorException(update);
        }
        v.validateObject(original, update);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject original, DBObject update, String property) throws ValidationException {
        this.validateObjectProperty(original, update, property);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(DBObject original, DBObject updated, Object property) throws ValidationException {
        this.validateObjectProperty(original, updated, property == null ? null : String.valueOf(property));
    }

    @Override
    public void validateObjectProperty(DBObject original, DBObject update, String property) throws ValidationException {
        if (property == null) {
            this.validateObject(original, update);
        } else {
            DBObjectValidator v = this.getValidatorForType(update.getType());
            if (v == null) {
                throw new MissingValidatorException(update);
            }
            v.validateObjectProperty(original, update, property);
        }
    }

    @Override
    @Deprecated
    public void validateSchema(Schema original, Schema update) throws ValidationException {
        this.validateObject((DBObject)original, update);
    }

    @Override
    public void validateUniqueName(String type, DBObject contextObject, String name) throws NameInUseException {
        if (ModelUtil.hasLength((String)name)) {
            if (contextObject instanceof Schema) {
                if (this.normaliseType(type).equals("CONSTRAINT") || type.equals("INDEX")) {
                    SchemaObject[] schemaObjects = null;
                    try {
                        schemaObjects = this.listObjects(this.listObjectTypes(), (Schema)contextObject);
                    }
                    catch (DBException x) {
                        this.getLogger().log(Level.WARNING, DBArb.format(378, x.getMessage()));
                    }
                    if (schemaObjects != null) {
                        for (int i = 0; i < schemaObjects.length; ++i) {
                            DBObject[] objs = schemaObjects[i].getOwnedObjects(this.normaliseType(type));
                            if (this.normaliseType(type).equals("CONSTRAINT")) {
                                int numUKs = 0;
                                for (DBObject o : objs) {
                                    if (!(o instanceof UniqueConstraint)) continue;
                                    ++numUKs;
                                }
                                DBObject[] uks = new DBObject[numUKs];
                                numUKs = 0;
                                for (DBObject o : objs) {
                                    if (!(o instanceof UniqueConstraint)) continue;
                                    uks[numUKs++] = o;
                                }
                                objs = uks;
                            }
                            this.checkChildrenNames(name, objs);
                        }
                    }
                } else {
                    for (String typeToCheck : this.listObjectTypes()) {
                        SchemaObject existing = null;
                        try {
                            existing = this.getObject(typeToCheck, (Schema)contextObject, name);
                        }
                        catch (DBException dbe) {
                            this.getLogger().log(Level.WARNING, DBArb.format(378, dbe.getMessage()));
                        }
                        if (existing == null) continue;
                        throw new NameInUseException(name, existing.getName(), existing.getType());
                    }
                }
            } else if (contextObject instanceof SchemaObject) {
                this.checkChildrenNames(name, contextObject.getOwnedObjects(this.normaliseType(type)));
            }
        }
    }

    @Override
    public String getUniqueName(String type, DBObject contextObject, String base) {
        ArrayList<String> names = new ArrayList<String>();
        type = this.normaliseType(type);
        if (!ModelUtil.hasLength((String)base)) {
            base = type + 1;
        }
        if (contextObject == null) {
            Collection<SystemObject> systemObjects = null;
            try {
                DBObjectCriteria<SystemObject> dbc = DBObjectCriteria.createCriteria();
                dbc.setTypes(type);
                systemObjects = this.listObjects(dbc);
            }
            catch (DBException e) {
                // empty catch block
            }
            if (systemObjects != null) {
                for (SystemObject listedObj : systemObjects) {
                    names.add(listedObj.getName());
                }
            }
        } else if (contextObject instanceof Schema) {
            SchemaObject[] schemaObjects = null;
            try {
                schemaObjects = this.listObjects(this.listObjectTypes(), (Schema)contextObject);
            }
            catch (DBException x) {
                // empty catch block
            }
            if (schemaObjects != null) {
                for (int i = 0; i < schemaObjects.length; ++i) {
                    if (type.equals("INDEX") || type.equals("CONSTRAINT")) {
                        this.addChildrenNames(schemaObjects[i].getOwnedObjects(type), names);
                        continue;
                    }
                    names.add(schemaObjects[i].getName());
                }
            }
        } else if (contextObject instanceof SchemaObject) {
            this.addChildrenNames(contextObject.getOwnedObjects(type), names);
        }
        int casePolicy = this.getCasePolicy();
        int quotedNameCasePolicy = this.getQuotedNameCasePolicy();
        if (casePolicy != 3 && quotedNameCasePolicy != 3) {
            boolean lowerCase = casePolicy == 1 || quotedNameCasePolicy == 1;
            String normalisedBase = lowerCase ? base.toLowerCase() : base.toUpperCase();
            ArrayList<String> normalisedNames = new ArrayList<String>();
            for (String name : names) {
                normalisedNames.add(lowerCase ? name.toLowerCase() : name.toUpperCase());
            }
            String uniqueName = DBUtil.getUniqueName(normalisedNames, normalisedBase);
            return uniqueName.equals(normalisedBase) ? base : uniqueName;
        }
        return DBUtil.getUniqueName(names, base);
    }

    private void addChildrenNames(DBObject[] children, Collection names) {
        for (int i = 0; i < children.length; ++i) {
            names.add(children[i].getName());
        }
    }

    private void checkChildrenNames(String name, DBObject[] children) throws NameInUseException {
        for (int i = 0; i < children.length; ++i) {
            if (!name.equals(children[i].getName())) continue;
            throw new NameInUseException(name, children[i].getParent().getName(), children[i].getParent().getType());
        }
    }

    protected String normaliseType(String type) {
        return Constraint.getConstraintTypes().contains(type) ? "CONSTRAINT" : type;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return null;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected void logEvent(String msg, Object ... params) {
        this.getLogger().log(DBLog.getEventLogLevel(), msg, params);
    }

    protected abstract String getName();

    @Override
    public boolean isEditable(DBObject object) {
        return true;
    }

    @Override
    public DBObject getDefaultTemplateForType(String type) {
        return null;
    }

    @Override
    public void setDefaultTemplateForType(String type, DBObject template) {
        throw new RuntimeException("Cannot store defaults online");
    }

    @Override
    public boolean isNewFromTemplateType(String type) {
        return NEW_FROM_TEMPLATE_TYPE.equals(type);
    }

    protected abstract void registerExpanders();

    protected void registerSchemaObjectExpander(SchemaObjectExpander expander) {
        this.m_expanders.add(expander);
    }

    protected SchemaObjectExpander[] getSchemaObjectExpanders() {
        return this.m_expanders.toArray(new SchemaObjectExpander[this.m_expanders.size()]);
    }

    @Override
    public DBObjectFactory getObjectFactory() {
        if (this.m_dbObjFactory == null) {
            this.m_dbObjFactory = new DBObjectFactory(this);
        }
        return this.m_dbObjFactory;
    }
}

