/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObject
implements DBObject {
    private final PropertySupport m_properties = this.createPropertySupport();
    private DBObjectID m_id;

    protected AbstractDBObject() {
        this(null, null);
    }

    protected AbstractDBObject(String name) {
        this(name, null);
    }

    protected AbstractDBObject(String name, DBObjectID id) {
        this.setName(name);
        this.setID(id);
    }

    PropertySupport createPropertySupport() {
        return new PropertySupport();
    }

    PropertySupport getPropertySupport() {
        return this.m_properties;
    }

    @Override
    public final Object copyTo(Object target) {
        return this.copyTo((DBObject)target, false);
    }

    @Override
    public final DBObject copyTo(DBObject target, boolean temporaryCopy) {
        return this.copyTo(target, temporaryCopy ? new IDPolicy.TemporaryIDPolicy() : new IDPolicy.DefaultIDPolicy());
    }

    @Override
    public final DBObject copyTo(DBObject target, IDPolicy idPolicy) {
        DBObject parent = null;
        if (target instanceof ChildDBObject) {
            parent = ((ChildDBObject)target).getParent();
        }
        if (parent == null && this instanceof ChildDBObject) {
            parent = ((ChildDBObject)((Object)this)).getParent();
        }
        AbstractDBObject copy = (AbstractDBObject)this.copyTo(target, parent, idPolicy);
        copy.replaceReferenceIDsDirectly(idPolicy.getIDMap());
        return copy;
    }

    boolean replaceReferenceIDsDirectly(Map<DBObjectID, DBObjectID> idMap) {
        boolean retval = false;
        if (idMap != null && !idMap.isEmpty()) {
            retval = this.replaceReferenceIDs(idMap);
            for (DBObject kid : this.getPropertySupport().getOwnedObjects(new String[0])) {
                retval = ((AbstractDBObject)kid).replaceReferenceIDsDirectly(idMap) || retval;
            }
        }
        return retval;
    }

    protected final DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        if (target == null) {
            try {
                target = (DBObject)this.getClass().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("couldn't instantiate new object for copy", e);
            }
        }
        this.copyToImpl((AbstractDBObject)target, copyParent, idPolicy);
        return target;
    }

    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        if (this == copy) {
            throw new IllegalStateException("cannot copy an object to itself");
        }
        if (idPolicy != null) {
            idPolicy.copyID(this, copy);
        }
        this.m_properties.copyTo(copy.m_properties, idPolicy);
    }

    protected <T> T copyObject(T value, DBObject copy, IDPolicy idPolicy) {
        Object retval = null;
        if (value instanceof AbstractDBObject) {
            retval = ((AbstractDBObject)value).copyTo(null, copy, idPolicy);
        } else if (value instanceof Copyable) {
            retval = ((Copyable)value).copyTo(null);
        } else if (value instanceof Object[]) {
            Object[] newArray = (Object[])Array.newInstance(value.getClass().getComponentType(), ((Object[])value).length);
            for (int i = 0; i < newArray.length; ++i) {
                newArray[i] = this.copyObject(((Object[])value)[i], copy, idPolicy);
            }
            retval = newArray;
        } else if (value instanceof List) {
            Object[] newList = new ArrayList();
            for (Object child : (List)value) {
                newList.add(this.copyObject(child, copy, idPolicy));
            }
            retval = newList;
        } else if (value instanceof Map) {
            HashMap newMap = new HashMap();
            for (Map.Entry e : ((Map)value).entrySet()) {
                newMap.put(e.getKey(), this.copyObject(e.getValue(), copy, idPolicy));
            }
            retval = newMap;
        } else {
            retval = value;
        }
        return (T)retval;
    }

    public final boolean equals(Object other) {
        boolean retval = false;
        if (other != null && this.getClass().isAssignableFrom(other.getClass())) {
            retval = this.equalsImpl((AbstractDBObject)other);
        }
        return retval;
    }

    protected boolean equalsImpl(AbstractDBObject other) {
        return ModelUtil.areEqual((Object)this.getName(), (Object)other.getName()) && ModelUtil.areEqual((Object)this.m_properties, (Object)other.m_properties);
    }

    protected int compareToImpl(AbstractDBObject target) {
        String otherName = target.getName();
        String thisName = this.getName();
        return thisName == null ? (otherName == null ? 0 : -1) : (otherName == null ? 1 : thisName.compareTo(otherName));
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public void setName(String name) {
        this.setProperty("name", name);
    }

    @Override
    public String getName() {
        return (String)this.getProperty("name");
    }

    @Override
    public void setID(DBObjectID id) {
        if (id instanceof TemporaryObjectID) {
            try {
                DBObject obj = ((TemporaryObjectID)id).resolveOriginalID();
                if (obj == this) {
                    throw new IllegalStateException("an object's copied id cannot point back to itself as the original object.");
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        this.m_id = id;
    }

    @Override
    public final DBObjectID getID() {
        return this.m_id == null ? null : (DBObjectID)this.m_id.copyTo(null);
    }

    final DBObjectID obtainActualID() {
        return this.m_id;
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public Object getProperty(String key) {
        if ("type".equals(key)) {
            return this.getType();
        }
        if ("ID".equals(key)) {
            return this.m_id;
        }
        return this.m_properties.get(key);
    }

    public final Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public void setProperties(Map properties) {
        if (properties != this.m_properties) {
            Iterator keys = this.m_properties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (properties.containsKey(key) || Metadata.getInstance().isBeanProperty(this.getClass(), key)) continue;
                keys.remove();
            }
            this.m_properties.putAll(properties);
        }
    }

    public void setProperty(String key, Object value) {
        if ("ID".equals(key)) {
            this.m_id = (DBObjectID)value;
        } else {
            this.m_properties.put(key, value);
        }
    }

    protected final void removeThisAsParent(ChildDBObject child) {
        if (child != null && child.getParent() == this) {
            child.setParent(null);
        }
    }

    protected final void changeParent(ChildDBObject oldChild, ChildDBObject newChild) {
        this.removeThisAsParent(oldChild);
        if (newChild != null) {
            newChild.setParent(this);
        }
    }

    @Override
    public final DBObject[] getOwnedObjects() {
        return this.getOwnedObjects(null);
    }

    @Override
    public final DBObject[] getOwnedObjects(String ... types) {
        ArrayList<DBObject> kids = new ArrayList<DBObject>();
        this.getOwnedObjectsImpl(kids, types);
        return kids.toArray(new DBObject[kids.size()]);
    }

    @Override
    public final DBObject findOwnedObject(String type, String name) {
        DBObject retval = null;
        DBObject[] kids = this.getOwnedObjects(type);
        for (int i = 0; i < kids.length; ++i) {
            if (!ModelUtil.areEqual((Object)name, (Object)kids[i].getName())) continue;
            retval = kids[i];
            break;
        }
        return retval;
    }

    @Override
    public DBObject findOwnedObject(DBObjectID id) {
        return this.findOwnedObject(id, false);
    }

    protected final DBObject findOwnedObject(DBObjectID id, boolean deep) {
        DBObject retval = null;
        if (id instanceof TemporaryObjectID) {
            try {
                DBObject obj = id.resolveID();
                if (obj.getParent() == this) {
                    retval = obj;
                }
            }
            catch (DBException e) {}
        } else {
            DBObject kid;
            int i$;
            DBObject[] arr$ = this.getOwnedObjects(id.getType());
            int len$ = arr$.length;
            for (i$ = 0; !(i$ >= len$ || id.equals((kid = arr$[i$]).getID(), true) && (retval = kid) != null); ++i$) {
            }
            if (deep && retval == null) {
                arr$ = this.getOwnedObjects();
                len$ = arr$.length;
                for (i$ = 0; !(i$ >= len$ || (kid = arr$[i$]) instanceof AbstractDBObject && (retval = ((AbstractDBObject)kid).findOwnedObject(id, true)) != null); ++i$) {
                }
            }
        }
        return retval;
    }

    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        objs.addAll(this.m_properties.getOwnedObjects(types));
    }

    protected final void includeOwnedObject(Collection<DBObject> objs, DBObject obj, String ... types) {
        if (this.includesType(obj, types)) {
            objs.add(obj);
        }
    }

    protected final boolean includesType(String type, String ... types) {
        return this.includesType(type, (Class<? extends DBObject>)null, types);
    }

    protected final boolean includesType(DBObject obj, String ... types) {
        if (obj != null) {
            return this.includesType(obj.getType(), obj.getClass(), types);
        }
        return false;
    }

    private final boolean includesType(Class<? extends DBObject> clz, String ... types) {
        return this.includesType(Metadata.getType(clz), clz, types);
    }

    private final boolean includesType(String type, Class<? extends DBObject> clz, String ... types) {
        if (ModelUtil.hasNonNullElement((Object[])types)) {
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals(type)) continue;
                return true;
            }
            Metadata m = Metadata.getInstance();
            for (String searchType : types) {
                Collection<String> implTypes;
                Class<? extends DBObject> searchClass = m.getObjectClass(searchType);
                if (searchClass == null) continue;
                if (clz != null && searchClass.isAssignableFrom(clz)) {
                    return true;
                }
                if (Metadata.isRealBean(searchClass) || !(implTypes = m.getAllTypes(searchClass)).contains(type)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final DBObjectID[] getReferenceIDs() {
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        this.getReferenceIDsImpl(refs);
        return refs.toArray(new DBObjectID[refs.size()]);
    }

    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        this.m_properties.getReferenceIDsImpl(refs);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        return this.m_properties.replaceReferenceIDs(idMap);
    }

    protected final synchronized ChildSupport getChildSupport(String propName) {
        return new ChildSupport(propName);
    }

    private boolean isChildUnordered(String propName) {
        return propName.equals("constraints") || propName.equals("indexes");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertySupport
    extends AbstractMap<String, Object> {
        private final Map<String, Object> m_cache = new TreeMap<String, Object>();

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.m_cache.entrySet();
        }

        @Override
        public Object put(String name, Object value) {
            Object replaced = this.m_cache.put(name, value);
            if (replaced != value) {
                this.removeCurrentParent(replaced);
                this.setCurrentParent(value);
            }
            return replaced;
        }

        private void removeCurrentParent(Object child) {
            if (child instanceof ChildDBObject) {
                AbstractDBObject.this.removeThisAsParent((ChildDBObject)child);
            } else if (child instanceof Iterable) {
                for (Object obj : (Iterable)child) {
                    if (!(obj instanceof ChildDBObject)) continue;
                    AbstractDBObject.this.removeThisAsParent((ChildDBObject)obj);
                }
            }
        }

        private void setCurrentParent(Object child) {
            if (child instanceof ChildDBObject) {
                AbstractDBObject.this.changeParent(null, (ChildDBObject)child);
            } else if (child instanceof Iterable) {
                for (Object obj : (Iterable)child) {
                    if (!(obj instanceof ChildDBObject)) continue;
                    AbstractDBObject.this.changeParent(null, (ChildDBObject)obj);
                }
            }
        }

        private void getReferenceIDsImpl(Collection<DBObjectID> retval) {
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                String key = entry.getKey();
                if (Metadata.getInstance().isStaticReferenceProperty(key)) continue;
                Object obj = entry.getValue();
                if (obj instanceof DBObjectID) {
                    retval.add((DBObjectID)obj);
                    continue;
                }
                if (!(obj instanceof Iterable)) continue;
                for (Object item : (Iterable)obj) {
                    if (!(item instanceof DBObjectID)) continue;
                    retval.add((DBObjectID)item);
                }
            }
        }

        public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
            boolean replaced = false;
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                String key = entry.getKey();
                if (Metadata.getInstance().isStaticReferenceProperty(key)) continue;
                Object value = entry.getValue();
                if (value instanceof DBObjectID && idMap.containsKey((DBObjectID)value)) {
                    entry.setValue(idMap.get((DBObjectID)value));
                    replaced = true;
                    continue;
                }
                if (!(value instanceof List)) continue;
                List l = (List)value;
                for (int i = 0; i < l.size(); ++i) {
                    Object o = l.get(i);
                    if (!(o instanceof DBObjectID) || !idMap.containsKey((DBObjectID)o)) continue;
                    l.set(i, idMap.get((DBObjectID)o));
                    replaced = true;
                }
            }
            return replaced;
        }

        public Collection<DBObject> getOwnedObjects(String ... types) {
            ArrayList<DBObject> kids = new ArrayList<DBObject>();
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof DBObject && ModelUtil.areDifferent((Object)"schema", (Object)entry.getKey())) {
                    AbstractDBObject.this.includeOwnedObject(kids, (DBObject)value, types);
                    continue;
                }
                if (!(value instanceof Iterable)) continue;
                for (Object kid : (Iterable)value) {
                    if (!(kid instanceof DBObject)) continue;
                    AbstractDBObject.this.includeOwnedObject(kids, (DBObject)kid, types);
                }
            }
            return kids;
        }

        public void copyTo(PropertySupport target, IDPolicy idPolicy) {
            this.copyTo(target, idPolicy, null);
        }

        protected final void copyTo(PropertySupport target, IDPolicy idPolicy, Collection<String> excludes) {
            HashSet<String> allKeys = new HashSet<String>();
            allKeys.addAll(this.m_cache.keySet());
            allKeys.addAll(target.m_cache.keySet());
            if (excludes != null) {
                allKeys.removeAll(excludes);
            }
            for (String propName : allKeys) {
                Object value = this.m_cache.get(propName);
                AbstractDBObject targetParent = target.getParentForChildren();
                if (value instanceof List) {
                    ChildSupport sourceKids = new ChildSupport(propName);
                    AbstractDBObject abstractDBObject = targetParent;
                    abstractDBObject.getClass();
                    ChildSupport targetKids = abstractDBObject.new ChildSupport(propName);
                    sourceKids.copyTo(targetKids, targetParent, idPolicy);
                    continue;
                }
                if (value != null) {
                    target.put(propName, AbstractDBObject.this.copyObject(value, targetParent, idPolicy));
                    continue;
                }
                target.remove(propName);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PropertySupport && this.equalsImpl((PropertySupport)obj);
        }

        private boolean equalsImpl(PropertySupport other) {
            return DBUtil.areEqualIgnoreNullValues(this.m_cache, other.m_cache);
        }

        public AbstractDBObject getParentForChildren() {
            return AbstractDBObject.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChildSupport {
        private final String m_key;

        private ChildSupport(String key) {
            this.m_key = key;
        }

        private void addChildren(List childList, Object[] children) {
            if (children != null) {
                for (Object child : children) {
                    if (child == null) continue;
                    this.addChild(childList, child);
                }
            }
        }

        private void addChild(List childList, Object child) {
            if (this.canAddChild(childList, child)) {
                childList.add(child);
                AbstractDBObject.this.m_properties.setCurrentParent(child);
            }
        }

        private void addChild(List childList, Object child, int idx) {
            if (this.canAddChild(childList, child)) {
                childList.add(idx, child);
                AbstractDBObject.this.m_properties.setCurrentParent(child);
            }
        }

        private boolean canAddChild(List childList, Object child) {
            if (child != null) {
                for (Object listed : childList) {
                    if (!(child instanceof ChildDBObject) || child != listed) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void clearChildren(List childList) {
            if (childList != null) {
                AbstractDBObject.this.m_properties.removeCurrentParent(childList);
                childList.clear();
            }
        }

        public void addChild(Object child) {
            if (child != null) {
                List kids = this.getChildList(true);
                this.addChild(kids, child);
            }
        }

        public void addChild(int idx, Object child) {
            if (child != null) {
                List kids = this.getChildList(true);
                this.addChild(kids, child, idx);
            }
        }

        public boolean moveChild(Object child, int newIdx) {
            int oldIndex;
            List kids;
            if (child != null && (kids = this.getChildList(false)) != null && (oldIndex = kids.indexOf(child)) != newIdx && kids.remove(child)) {
                kids.add(newIdx, child);
                return true;
            }
            return false;
        }

        public int indexOfChild(Object child) {
            List kids = child == null ? null : this.getChildList(false);
            return kids == null ? -1 : kids.indexOf(child);
        }

        public <T> T setChildAt(int index, T child) {
            List kids = this.getChildList(index == 0);
            if (kids == null || kids.size() <= index) {
                throw new IndexOutOfBoundsException(index + " too big");
            }
            T replaced = kids.set(index, child);
            if (replaced != null) {
                AbstractDBObject.this.m_properties.removeCurrentParent(replaced);
            }
            return replaced;
        }

        public boolean removeChild(Object child) {
            boolean retval = false;
            List childList = this.getChildList(false);
            if (childList != null && childList.remove(child)) {
                retval = true;
                AbstractDBObject.this.m_properties.removeCurrentParent(child);
                if (childList.size() == 0) {
                    AbstractDBObject.this.setProperty(this.m_key, null);
                }
            }
            return retval;
        }

        public Object findChild(String childName) {
            List kids;
            if (childName != null && (kids = this.getChildList(false)) != null) {
                for (Object kid : kids) {
                    if (!(kid instanceof DBObject) || !ModelUtil.areEqual((Object)childName, (Object)((DBObject)kid).getName())) continue;
                    return kid;
                }
            }
            return null;
        }

        public void clearChildren() {
            List kids = this.getChildList(false);
            this.clearChildren(kids);
            AbstractDBObject.this.setProperty(this.m_key, null);
        }

        public <T> T[] getChildArray(Class<T> clz) {
            List kids = this.getChildList(false);
            Object[] retval = kids == null ? Array.newInstance(clz, 0) : kids.toArray((Object[])Array.newInstance(clz, kids.size()));
            if (AbstractDBObject.this.isChildUnordered(this.m_key) && DBObject.class.isAssignableFrom(clz)) {
                Arrays.sort((DBObject[])retval, DBUtil.getTypeComparator());
            }
            return retval;
        }

        public void setChildArray(Object[] newKids) {
            List kids = this.getChildList(true);
            this.clearChildren(kids);
            this.addChildren(kids, newKids);
        }

        public int getChildCount() {
            List kids = this.getChildList(false);
            return kids == null ? 0 : kids.size();
        }

        public List getChildList(boolean create) {
            ArrayList kids = null;
            Object obj = AbstractDBObject.this.getProperty(this.m_key);
            if (obj != null) {
                if (obj instanceof List) {
                    kids = (ArrayList)obj;
                } else {
                    throw new IllegalStateException("property is not a list: " + this.m_key);
                }
            }
            if (kids == null && create) {
                kids = new ArrayList();
                AbstractDBObject.this.setProperty(this.m_key, kids);
            }
            return kids == null ? null : kids;
        }

        private void copyTo(ChildSupport target, AbstractDBObject copyParent, IDPolicy idPolicy) {
            List kids = this.getChildList(false);
            if (kids == null) {
                target.clearChildren();
            } else {
                ArrayList newKids = new ArrayList();
                for (Object obj : kids) {
                    Object copy;
                    if (obj instanceof AbstractDBObject) {
                        String name = (String)((AbstractDBObject)obj).m_properties.get("name");
                        DBObject existing = name == null ? null : (DBObject)target.findChild(name);
                        copy = ((AbstractDBObject)obj).copyTo(existing, copyParent, idPolicy);
                    } else {
                        copy = AbstractDBObject.this.copyObject(obj, copyParent, idPolicy);
                    }
                    newKids.add(copy);
                }
                target.clearChildren();
                for (Object copy : newKids) {
                    target.addChild(copy);
                }
            }
        }
    }
}

