/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildableObject
extends AbstractDBObject
implements SystemObject {
    public AbstractBuildableObject() {
    }

    protected AbstractBuildableObject(String name, DBObjectID id) {
        super(name, id);
    }

    @Override
    AbstractDBObject.PropertySupport createPropertySupport() {
        return new BuildablePropertySupport();
    }

    @Override
    BuildablePropertySupport getPropertySupport() {
        return (BuildablePropertySupport)super.getPropertySupport();
    }

    synchronized boolean isBuilt(String prop) {
        return prop != null && (!this.getPropertySupport().canBuild(prop) || this.getPropertySupport().isBuilt(prop));
    }

    protected boolean needsInitialization() {
        return this.getPropertySupport().needsInitialization();
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected void checkInit(String prop) {
        this.getPropertySupport().checkInit(prop);
    }

    protected void checkInit() {
        this.checkInit(null);
    }

    @Override
    public Map getProperties() {
        return new LazyPropertiesMap();
    }

    @Override
    public Object getProperty(String prop) {
        this.checkInit(prop);
        return super.getProperty(prop);
    }

    @Override
    public void setProperty(String prop, Object value) {
        this.checkInit(prop);
        super.setProperty(prop, value);
        this.getPropertySupport().setBuilt(prop);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String ... types) {
        Collection<String> properties = this.getChildPropertiesForTypes(types);
        if (properties == null) {
            this.checkInit();
        } else {
            for (String prop : properties) {
                this.checkInit(prop);
            }
        }
        super.getOwnedObjectsImpl(c, types);
    }

    private Collection<String> getChildPropertiesForTypes(String[] types) {
        ArrayList<String> retval = null;
        if (types != null) {
            PropertyIterator pi = new PropertyIterator(this.getClass(), null);
            for (Map.Entry<String, PropertyInfo> entry : pi.getPropertyInfos(false, false, false).entrySet()) {
                String propName = entry.getKey();
                PropertyInfo info = entry.getValue();
                Class<?> clz = info.getPropertyClass();
                if (clz.isArray()) {
                    clz = clz.getComponentType();
                }
                if (!DBObject.class.isAssignableFrom(clz)) continue;
                String type = Metadata.getType(clz);
                for (String desiredType : types) {
                    if (!ModelUtil.areEqual((Object)desiredType, (Object)type)) continue;
                    if (retval == null) {
                        retval = new ArrayList<String>();
                    }
                    retval.add(propName);
                }
            }
        }
        return retval;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        this.checkInit();
        super.getReferenceIDsImpl(refs);
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        if (!this.getPropertySupport().supportsCopyBuilder(idPolicy) && !(idPolicy instanceof StaticCopyPolicy)) {
            this.checkInit();
            ((AbstractBuildableObject)copy).getPropertySupport().markAsBuilt();
        }
        super.copyToImpl(copy, copyParent, idPolicy);
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject target) {
        AbstractBuildableObject other = (AbstractBuildableObject)target;
        this.getPropertySupport().syncBuildState(other.getPropertySupport());
        return super.equalsImpl(target);
    }

    DBObject createStaticCopy() {
        return this.copyTo(null, new StaticCopyPolicy());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyPropertiesMap
    extends AbstractMap<String, Object> {
        private LazyPropertiesMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            AbstractBuildableObject.this.checkInit();
            return AbstractBuildableObject.super.getProperties().entrySet();
        }

        @Override
        public Object put(String key, Object value) {
            AbstractBuildableObject.this.setProperty(key, value);
            return true;
        }

        @Override
        public Object get(Object key) {
            Object retval = null;
            if (key instanceof String) {
                retval = AbstractBuildableObject.this.getProperty((String)key);
            }
            return retval;
        }

        @Override
        public Object remove(Object key) {
            Object retval = null;
            if (key instanceof String) {
                retval = AbstractBuildableObject.this.getProperty((String)key);
                AbstractBuildableObject.this.setProperty((String)key, null);
            }
            return retval;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }
    }

    class TemporaryCopyBuilder
    extends AbstractDBObjectBuilder {
        private final AbstractBuildableObject m_original;
        private final IDPolicy.TemporaryIDPolicy m_idPolicy;
        private final AbstractDBObjectBuilder m_delegate;

        TemporaryCopyBuilder(AbstractBuildableObject original, AbstractDBObjectBuilder delegate, IDPolicy.TemporaryIDPolicy idPolicy) {
            super(delegate.getProvider(), original.getType());
            this.m_original = original;
            this.m_idPolicy = idPolicy;
            this.m_delegate = delegate;
        }

        public AbstractBuildableObject createObject(String name, Schema schema, DBObjectID id) {
            throw new UnsupportedOperationException("TemporaryCopyBuilder doesn't support create");
        }

        protected boolean isBuildableProperty(String prop) {
            return "Timestamp".equals(prop) || !s_specialProps.contains(prop);
        }

        protected void fillInObject(AbstractBuildableObject copy) throws DBException {
            this.m_original.checkInit();
            BuildablePropertySupport origProps = this.m_original.getPropertySupport();
            BuildablePropertySupport copyProps = copy.getPropertySupport();
            origProps.copyTo(copyProps, this.m_idPolicy, copyProps.m_builtProps);
            copy.replaceReferenceIDsDirectly(this.m_idPolicy.getIDMap());
        }

        void fillInObjectComponentImpl(AbstractBuildableObject copy, String prop) throws DBException {
            BuildablePropertySupport origProps = this.m_original.getPropertySupport();
            BuildablePropertySupport copyProps = copy.getPropertySupport();
            origProps.checkInitEx(prop);
            Object v = AbstractBuildableObject.this.copyObject(origProps.get(prop), copy, this.m_idPolicy);
            copyProps.put(prop, v);
            copy.replaceReferenceIDsDirectly(this.m_idPolicy.getIDMap());
        }

        protected boolean canBuildComponents() {
            return true;
        }

        protected void registerObject(AbstractBuildableObject object) throws DBException {
        }

        String[] getPropertyDependencies(String property) {
            return this.m_delegate.getPropertyDependencies(property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BuiltStatus {
        UNBUILT,
        PARTIAL,
        BUILT;

    }

    private class StaticCopyPolicy
    extends IDPolicy.SameIDPolicy {
        private StaticCopyPolicy() {
        }
    }

    final class BuildablePropertySupport
    extends AbstractDBObject.PropertySupport {
        private DBObjectBuilder m_builder;
        private final Set<String> m_building;
        private boolean m_buildingAll;
        private ReentrantLock m_propertyLock;
        private final Set<String> m_builtProps;
        private BuiltStatus m_status;

        BuildablePropertySupport() {
            super(AbstractBuildableObject.this);
            this.m_building = new TreeSet<String>();
            this.m_builtProps = new TreeSet<String>();
            this.m_status = BuiltStatus.BUILT;
        }

        void setBuilder(DBObjectBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException("builder cannot be null");
            }
            this.m_builder = builder;
            this.m_builtProps.clear();
            this.m_status = BuiltStatus.UNBUILT;
        }

        private ReentrantLock getPropertyLock() {
            if (this.m_propertyLock == null) {
                this.m_propertyLock = new ReentrantLock();
            }
            return this.m_propertyLock;
        }

        void markAsBuilt() {
            this.m_status = BuiltStatus.BUILT;
        }

        boolean needsInitialization() {
            return this.m_status != BuiltStatus.BUILT;
        }

        void setBuildingAll() {
            this.m_buildingAll = true;
        }

        void startBuilding(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    if (this.m_building.contains(prop)) {
                        DBLog.getLogger(this).severe("already building " + prop);
                    }
                    this.m_building.add(prop);
                }
            }
        }

        void finishBuilding(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    this.m_building.remove(prop);
                }
            }
        }

        void setBuilt(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    this.m_builtProps.add(prop);
                    this.m_building.remove(prop);
                }
            }
        }

        boolean isBuilt(String prop) {
            boolean retval;
            boolean bl = retval = this.m_status == BuiltStatus.BUILT;
            if (!retval) {
                if (prop == null) {
                    retval = false;
                } else if (this.m_builtProps.contains(prop)) {
                    retval = true;
                }
            }
            return retval;
        }

        void checkInit(String prop) {
            try {
                this.checkInitEx(prop);
            }
            catch (DBSQLException sqle) {
                AbstractBuildableObject.this.getLogger().log(Level.SEVERE, "Error : \"" + sqle.getMessage() + "\" building {0}, executing sql:\n {1}", new Object[]{AbstractBuildableObject.this.getName(), sqle.getSQL()});
            }
            catch (CancelledException ce) {
                String msg = ModelUtil.hasLength((String)prop) ? DBArb.format(361, prop, AbstractBuildableObject.this.getType(), AbstractBuildableObject.this.getName()) : DBArb.format(360, AbstractBuildableObject.this.getType(), AbstractBuildableObject.this.getName());
                AbstractBuildableObject.this.getLogger().log(Level.WARNING, msg);
            }
            catch (DBException dbe) {
                String msg = ModelUtil.hasLength((String)prop) ? DBArb.format(363, new Object[]{dbe.getMessage(), prop, AbstractBuildableObject.this.getType(), AbstractBuildableObject.this.getName()}) : DBArb.format(362, dbe.getMessage(), AbstractBuildableObject.this.getType(), AbstractBuildableObject.this.getName());
                AbstractBuildableObject.this.getLogger().log(Level.WARNING, msg, dbe);
                AbstractBuildableObject.this.getLogger().severe(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void checkInitEx(String prop) throws DBException {
            if (this.m_builder == null) return;
            if (this.isBuilt(prop)) {
                return;
            }
            if (this.m_buildingAll || prop != null && this.m_building.contains(prop)) {
                AbstractBuildableObject.this.getLogger().log(Level.FINEST, "Querying " + prop + " while it is being built");
                return;
            }
            if (!this.canBuild(prop)) {
                return;
            }
            ReentrantLock lock = this.getPropertyLock();
            if (!lock.tryLock()) {
                AbstractBuildableObject.this.getLogger().log(Level.FINE, "Waiting for property lock on " + Thread.currentThread().getName());
                lock.lock();
            }
            try {
                if (this.isBuilt(prop)) {
                    lock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                lock.unlock();
                throw throwable;
            }
            {
                long millis = System.currentTimeMillis();
                boolean cancelled = false;
                try {
                    block16: {
                        try {
                            if (prop == null) {
                                this.m_buildingAll = true;
                                this.m_builder.buildObject(AbstractBuildableObject.this);
                                this.m_status = BuiltStatus.BUILT;
                                break block16;
                            }
                            this.m_builder.buildObjectComponent(AbstractBuildableObject.this, prop);
                            if (this.m_status == BuiltStatus.UNBUILT) {
                                this.m_status = BuiltStatus.PARTIAL;
                            }
                        }
                        catch (CancelledException ce) {
                            cancelled = true;
                            if (prop == null) throw ce;
                            this.m_builtProps.remove(prop);
                            throw ce;
                        }
                    }
                    Object var8_5 = null;
                    this.m_buildingAll = false;
                    if (prop != null && !cancelled) {
                        this.m_builtProps.add(prop);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this.m_buildingAll = false;
                    if (prop != null && !cancelled) {
                        this.m_builtProps.add(prop);
                    }
                    millis = System.currentTimeMillis() - millis;
                    AbstractBuildableObject.this.getLogger().log(DBLog.getTimingLogLevel(), "Building {0} of {1} took {2}ms", new Object[]{prop == null ? "all" : prop, AbstractBuildableObject.this.getName(), Long.toString(millis)});
                    throw throwable;
                }
                millis = System.currentTimeMillis() - millis;
                AbstractBuildableObject.this.getLogger().log(DBLog.getTimingLogLevel(), "Building {0} of {1} took {2}ms", new Object[]{prop == null ? "all" : prop, AbstractBuildableObject.this.getName(), Long.toString(millis)});
                Object var10_9 = null;
                lock.unlock();
                return;
            }
        }

        private boolean canBuild(String prop) {
            boolean retval = true;
            if (prop != null && this.m_builder instanceof AbstractDBObjectBuilder && !((AbstractDBObjectBuilder)this.m_builder).isBuildableProperty(prop)) {
                retval = false;
            }
            return retval;
        }

        public void copyTo(AbstractDBObject.PropertySupport target, IDPolicy idPolicy) {
            super.copyTo(target, idPolicy);
            BuildablePropertySupport copy = (BuildablePropertySupport)target;
            if (this.m_status != BuiltStatus.BUILT) {
                if (idPolicy instanceof StaticCopyPolicy) {
                    copy.markAsBuilt();
                } else if (this.supportsCopyBuilder(idPolicy)) {
                    copy.initCopyBuilder(AbstractBuildableObject.this, (AbstractDBObjectBuilder)this.m_builder, (IDPolicy.TemporaryIDPolicy)idPolicy);
                    copy.m_status = this.m_status;
                    copy.m_builtProps.clear();
                    copy.m_builtProps.addAll(this.m_builtProps);
                }
            }
        }

        private void initCopyBuilder(AbstractBuildableObject original, AbstractDBObjectBuilder builder, IDPolicy.TemporaryIDPolicy idPolicy) {
            this.setBuilder(new TemporaryCopyBuilder(original, builder, idPolicy));
        }

        private boolean supportsCopyBuilder(IDPolicy idPolicy) {
            return idPolicy instanceof IDPolicy.TemporaryIDPolicy && this.m_builder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)this.m_builder).canBuildComponents();
        }

        public boolean equals(Object obj) {
            return obj instanceof BuildablePropertySupport && super.equals(obj) && this.equalsImpl((BuildablePropertySupport)obj);
        }

        private boolean equalsImpl(BuildablePropertySupport other) {
            boolean same = ModelUtil.areEqual((Object)((Object)this.m_status), (Object)((Object)other.m_status));
            if (same && this.m_status != BuiltStatus.BUILT) {
                same = ((Object)this.m_builtProps).equals(other.m_builtProps);
            }
            return same;
        }

        private boolean isTempCopyOf(BuildablePropertySupport other) {
            boolean retval = false;
            if (this.m_builder instanceof TemporaryCopyBuilder) {
                retval = ((TemporaryCopyBuilder)this.m_builder).m_original == other.getParentForChildren();
            }
            return retval;
        }

        private void syncBuildState(BuildablePropertySupport other) {
            boolean first = this.isTempCopyOf(other);
            boolean second = other.isTempCopyOf(this);
            if (first || second) {
                if (!this.needsInitialization()) {
                    other.checkInit(null);
                } else if (!other.needsInitialization()) {
                    this.checkInit(null);
                } else {
                    BuildablePropertySupport copy;
                    BuildablePropertySupport original;
                    if (first) {
                        original = other;
                        copy = this;
                    } else {
                        original = this;
                        copy = other;
                    }
                    TreeSet<String> copyBuiltProps = new TreeSet<String>(copy.m_builtProps);
                    for (String prop : copyBuiltProps) {
                        original.checkInit(prop);
                    }
                    TreeSet<String> originalBuiltProps = new TreeSet<String>(original.m_builtProps);
                    originalBuiltProps.removeAll(copyBuiltProps);
                    for (String prop : originalBuiltProps) {
                        copy.checkInit(prop);
                    }
                }
            } else {
                this.checkInit(null);
                other.checkInit(null);
            }
        }
    }
}

