/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class CHAR
extends Datum {
    static final long serialVersionUID = 5559010489982176244L;
    public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
    private CharacterSet charSet;
    private int oracleId;
    private static final byte[] empty = new byte[0];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    protected CHAR() {
    }

    public CHAR(byte[] byArray, CharacterSet characterSet) {
        this.setValue(byArray, characterSet);
    }

    public CHAR(byte[] byArray, int n2, int n3, CharacterSet characterSet) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.setValue(byArray2, characterSet);
    }

    public CHAR(String string, CharacterSet characterSet) throws SQLException {
        if (characterSet == null) {
            characterSet = DEFAULT_CHARSET;
        }
        this.setValue(characterSet.convertWithReplacement(string), characterSet);
    }

    public CHAR(Object object, CharacterSet characterSet) throws SQLException {
        this(object.toString(), characterSet);
    }

    public CharacterSet getCharacterSet() {
        if (this.charSet == null) {
            if (this.oracleId == 0) {
                this.oracleId = -1;
            }
            this.charSet = DEFAULT_CHARSET != null && (this.oracleId == -1 || this.oracleId == DEFAULT_CHARSET.getOracleId()) ? DEFAULT_CHARSET : CharacterSet.make(this.oracleId);
        }
        return this.charSet;
    }

    public int oracleId() {
        return this.oracleId;
    }

    public String getString() throws SQLException {
        return this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
    }

    public String getStringWithReplacement() {
        byte[] byArray = this.shareBytes();
        return this.getCharacterSet().toStringWithReplacement(byArray, 0, byArray.length);
    }

    public String toString() {
        return this.getStringWithReplacement();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CHAR && this.getCharacterSet().equals(((CHAR)object).getCharacterSet()) && super.equals(object);
    }

    void setValue(byte[] byArray, CharacterSet characterSet) {
        this.charSet = characterSet == null ? DEFAULT_CHARSET : characterSet;
        this.oracleId = this.charSet.getOracleId();
        this.setShareBytes(byArray == null ? empty : byArray);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.stringValue();
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.sql.Date") == 0 || string.compareTo("java.sql.Time") == 0 || string.compareTo("java.sql.Timestamp") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    @Override
    public String stringValue() {
        return this.toString();
    }

    @Override
    public boolean booleanValue() throws SQLException {
        String string = this.stringValue();
        if (string == null) {
            return false;
        }
        string = string.trim();
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return bigDecimal.signum() != 0;
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public int intValue() throws SQLException {
        long l2 = this.longValue();
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (int)l2;
    }

    @Override
    public long longValue() throws SQLException {
        long l2 = 0L;
        try {
            l2 = Long.valueOf(this.stringValue().trim());
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return l2;
    }

    @Override
    public float floatValue() throws SQLException {
        float f2 = 0.0f;
        try {
            f2 = Float.valueOf(this.stringValue().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return f2;
    }

    @Override
    public double doubleValue() throws SQLException {
        double d2 = 0.0;
        try {
            d2 = Double.valueOf(this.stringValue().trim());
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return d2;
    }

    @Override
    public byte byteValue() throws SQLException {
        long l2 = this.longValue();
        if (l2 > 127L || l2 < -128L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (byte)l2;
    }

    @Override
    public Date dateValue() throws SQLException {
        return Date.valueOf(this.stringValue().trim());
    }

    @Override
    public Time timeValue() throws SQLException {
        return Time.valueOf(this.stringValue().trim());
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return Timestamp.valueOf(this.stringValue().trim());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(this.stringValue().trim());
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "bigDecimalValue");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bigDecimal;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return new StringReader(this.getString());
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.getStream();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new String[n2];
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

