/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;

public class Util {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    public static Object convertToObject(Datum datum, int n2, Object object) throws SQLException {
        Object object2 = Util._convertToObject(datum, n2, object);
        return object2;
    }

    public static Object _convertToObject(Datum datum, int n2, Object object) throws SQLException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof STRUCT) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2002);
            }
            return ((CustomDatumFactory)object).create(datum, 2002);
        }
        if (datum instanceof REF) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2006);
            }
            return ((CustomDatumFactory)object).create(datum, 2006);
        }
        if (datum instanceof ARRAY) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2003);
            }
            return ((CustomDatumFactory)object).create(datum, 2003);
        }
        if (datum instanceof OPAQUE) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2007);
            }
            return ((CustomDatumFactory)object).create(datum, 2007);
        }
        if (object != null) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, n2);
            }
            return ((CustomDatumFactory)object).create(datum, n2);
        }
        if (datum instanceof NUMBER) {
            if (n2 == 2 || n2 == 3) {
                return ((NUMBER)datum).bigDecimalValue();
            }
            if (n2 == 8 || n2 == 6) {
                return ((NUMBER)datum).doubleValue();
            }
            if (n2 == 4 || n2 == 5) {
                return ((NUMBER)datum).intValue();
            }
            if (n2 == 7) {
                return Float.valueOf(((NUMBER)datum).floatValue());
            }
            if (n2 == 16) {
                return ((NUMBER)datum).booleanValue();
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 48, " type: " + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return datum.toJdbc();
    }

    public static Datum convertToOracle(Object object, Connection connection) throws SQLException {
        return Util.convertToOracle(object, connection, false);
    }

    public static Datum convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        Datum datum = Util._convertToOracle(object, connection, bl);
        return datum;
    }

    private static Datum _convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof ORAData) {
            return ((ORAData)object).toDatum(connection);
        }
        if (object instanceof CustomDatum) {
            return ((CustomDatum)object).toDatum((OracleConnection)connection);
        }
        if (object instanceof String) {
            short s2;
            short s3 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (s2 = bl ? ((oracle.jdbc.internal.OracleConnection)connection).getNCharSet() : ((oracle.jdbc.internal.OracleConnection)connection).getDbCsId());
            if (s2 != lastCsId) {
                lastCsId = s2;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)object, lastCS);
        }
        if (object instanceof Character) {
            short s4;
            short s5 = s4 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (short)((oracle.jdbc.internal.OracleConnection)connection).getDbCsId();
            if (s4 != lastCsId) {
                lastCsId = s4;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)object).toString(), lastCS);
        }
        if (object instanceof BigDecimal) {
            return new NUMBER((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new NUMBER((BigInteger)object);
        }
        if (object instanceof Double) {
            return new NUMBER((Double)object);
        }
        if (object instanceof Float) {
            return new NUMBER(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new NUMBER((Integer)object);
        }
        if (object instanceof Boolean) {
            return new NUMBER((Boolean)object);
        }
        if (object instanceof Short) {
            return new NUMBER((Short)object);
        }
        if (object instanceof Byte) {
            return new NUMBER((Byte)object);
        }
        if (object instanceof Long) {
            return new NUMBER((Long)object);
        }
        if (object instanceof Timestamp) {
            return new TIMESTAMP((Timestamp)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)object).getTime()));
        }
        if (object instanceof byte[]) {
            return new RAW((byte[])object);
        }
        if (object instanceof Datum) {
            return (Datum)object;
        }
        SQLException sQLException = DatabaseError.createSqlException(null, 48);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static boolean isMutable(Datum datum, ORADataFactory oRADataFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || oRADataFactory != null && (datum instanceof STRUCT || datum instanceof OPAQUE || datum instanceof ARRAY);
    }

    static boolean isMutable(Datum datum, CustomDatumFactory customDatumFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || customDatumFactory != null && (datum instanceof STRUCT || datum instanceof OPAQUE || datum instanceof ARRAY);
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

