/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OracleTypeTIMESTAMP
extends OracleType
implements Serializable {
    static final long serialVersionUID = 3948043338303602796L;
    int precision = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    protected OracleTypeTIMESTAMP() {
    }

    public OracleTypeTIMESTAMP(OracleConnection oracleConnection) {
    }

    @Override
    public int getTypeCode() {
        return 93;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.precision);
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new TIMESTAMP(byArray);
            }
            case 2: {
                return TIMESTAMP.toTimestamp(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block10: {
            tIMESTAMP = null;
            if (object != null) {
                try {
                    if (object instanceof TIMESTAMP) {
                        tIMESTAMP = (TIMESTAMP)object;
                        break block10;
                    }
                    if (object instanceof byte[]) {
                        tIMESTAMP = new TIMESTAMP((byte[])object);
                        break block10;
                    }
                    if (object instanceof Timestamp) {
                        tIMESTAMP = new TIMESTAMP((Timestamp)object);
                        break block10;
                    }
                    if (object instanceof DATE) {
                        tIMESTAMP = new TIMESTAMP((DATE)object);
                        break block10;
                    }
                    if (object instanceof String) {
                        tIMESTAMP = new TIMESTAMP((String)object);
                        break block10;
                    }
                    if (object instanceof Date) {
                        tIMESTAMP = new TIMESTAMP((Date)object);
                        break block10;
                    }
                    if (object instanceof Time) {
                        tIMESTAMP = new TIMESTAMP((Time)object);
                        break block10;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (Exception exception) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return tIMESTAMP;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
        sQLException.fillInStackTrace();
        throw sQLException;
    }
}

