/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;

class IntervaldsAccessor
extends Accessor {
    static final int maxLength = 11;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    IntervaldsAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 183, 183, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    IntervaldsAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 183, 183, s2, false);
        this.initForDescribe(183, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 11;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            string = new INTERVALDS(byArray).toString();
        }
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getINTERVALDS(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getINTERVALDS(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getINTERVALDS(n2);
    }

    @Override
    INTERVALDS getINTERVALDS(int n2) throws SQLException {
        INTERVALDS iNTERVALDS = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            iNTERVALDS = new INTERVALDS(byArray);
        }
        return iNTERVALDS;
    }
}

