/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xdb.XMLType;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.core.OracleXMLTimer;
import oracle.xml.sql.dataset.OracleXMLDataSet;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.dataset.OracleXMLDataSetGenJdbc;
import oracle.xml.sql.name.OracleADTName;
import oracle.xml.sql.name.OracleCollectionName;
import oracle.xml.sql.name.OracleColumnName;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OracleXMLSave {
    public static int DEFAULT_BATCH_SIZE = 17;
    private int batchSize = DEFAULT_BATCH_SIZE;
    private int commitBatch = 0;
    private Connection conn;
    private String tableName;
    private DOMParser parser = null;
    private String rowtagName = "ROW";
    private boolean ignoreCase = false;
    private boolean usedbdates = false;
    public static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private Vector clobList = new Vector(5, 5);
    private Vector blobList = new Vector(5, 5);
    private String dateFormat = "MM/dd/yyyy HH:mm:ss";
    private boolean collectTimingInfo = false;
    private OracleXMLTimer tim = null;
    private PreparedStatement setSavePt = null;
    private PreparedStatement rollbackToSavePt = null;
    private static final int INSERT = 1;
    private static final int UPDATE = 2;
    private static final int DELETE = 3;
    private PreparedStatement updStmt = null;
    private PreparedStatement delStmt = null;
    private PreparedStatement insStmt = null;
    private String[] keyColNames = null;
    private String[] updColNames = null;
    private Hashtable updHash = null;
    private boolean updHashValid = true;
    private Hashtable keyHash = null;
    private boolean keyHashValid = true;
    private Hashtable insBindPos = null;
    private Hashtable delBindPos = null;
    private Hashtable updBindPos = null;
    XSLProcessor xslp = null;
    XSLStylesheet xslt = null;
    private boolean oracleconn = false;
    private SimpleDateFormat dateFormatter = null;
    OracleColumnName[] colNames = null;
    Hashtable tabColHash = null;
    int colCount = 0;
    static XSUMesg msg = OracleXMLConvert.msg;
    private BitSet nullVector = null;
    private int batched = 0;
    private int actualBatchSize;
    public boolean xDocIsEsc = false;

    public OracleXMLSave(Connection connection, String string) {
        this.conn = connection;
        if (this.conn instanceof OracleConnection) {
            this.oracleconn = true;
        }
        this.tableName = string;
    }

    public OracleXMLSave(Connection connection, OracleColumnName[] oracleColumnNameArray) {
        this.conn = connection;
        if (this.conn instanceof OracleConnection) {
            this.oracleconn = true;
        }
        this.tableName = null;
        this.colNames = oracleColumnNameArray;
    }

    private void initParser() {
        if (this.parser != null) {
            return;
        }
        try {
            this.parser = new DOMParser();
            this.parser.setErrorStream((OutputStream)System.err);
            this.parser.showWarnings(false);
            this.parser.setPreserveWhitespace(false);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
    }

    public void setPreserveWhitespace(boolean bl) {
        this.initParser();
        this.parser.setPreserveWhitespace(bl);
    }

    public void useDBDates(boolean bl) {
        this.usedbdates = bl;
    }

    public void setXSLT(String string, String string2) {
        if (string == null) {
            this.xslt = null;
        } else {
            try {
                if (this.xslp == null) {
                    this.xslp = new XSLProcessor();
                    this.xslp.setBaseURL(OracleXMLSave.getURL(string2));
                }
                this.xslt = this.xslp.newXSLStylesheet(OracleXMLSave.getURL(string));
            }
            catch (XSLException xSLException) {
                throw new OracleXMLSQLException((Exception)((Object)xSLException));
            }
        }
    }

    public void setXSLT(Reader reader, String string) {
        if (reader == null) {
            this.xslt = null;
        } else {
            try {
                if (this.xslp == null) {
                    this.xslp = new XSLProcessor();
                    this.xslp.setBaseURL(OracleXMLSave.getURL(string));
                }
                this.xslt = this.xslp.newXSLStylesheet(reader);
            }
            catch (XSLException xSLException) {
                throw new OracleXMLSQLException((Exception)((Object)xSLException));
            }
        }
    }

    public void setXSLTParam(String string, String string2) {
        if (this.xslp == null) {
            return;
        }
        try {
            this.xslp.setParam("", string, (Object)string2);
        }
        catch (XSLException xSLException) {
            throw new OracleXMLSQLException((Exception)((Object)xSLException));
        }
    }

    public void removeXSLTParam(String string) {
        if (this.xslp == null) {
            return;
        }
        try {
            this.xslp.removeParam("", string);
        }
        catch (XSLException xSLException) {
            throw new OracleXMLSQLException((Exception)((Object)xSLException));
        }
    }

    private void getTableMetaData() throws SQLException, IOException {
        if (this.colNames == null) {
            String string = " select * from " + this.tableName + " where 1 = 0";
            OracleXMLDataSet oracleXMLDataSet = this.oracleconn ? new OracleXMLDataSetExtJdbc(this.conn, string) : new OracleXMLDataSetGenJdbc(this.conn, string);
            OracleXMLConvert oracleXMLConvert = new OracleXMLConvert(this.conn, oracleXMLDataSet);
            oracleXMLConvert.setMiscFlags(1);
            if (this.ignoreCase) {
                oracleXMLConvert.setMiscFlags(2);
            }
            if (this.xDocIsEsc) {
                oracleXMLConvert.setMiscFlags(4);
            }
            this.colNames = oracleXMLConvert.createColNames();
            this.colCount = oracleXMLDataSet.getColumnCount();
            oracleXMLDataSet.close();
            this.tabColHash = null;
        }
        if (this.tabColHash == null) {
            this.tabColHash = new Hashtable(2 * this.colCount);
            for (int i = 0; i < this.colCount; ++i) {
                if (this.ignoreCase) {
                    this.tabColHash.put(this.colNames[i].getLabel().toLowerCase(), new Integer(i + 1));
                    continue;
                }
                this.tabColHash.put(this.colNames[i].getLabel(), new Integer(i + 1));
            }
        }
    }

    private int getColNamesIndex(String string) {
        Integer n = (Integer)this.tabColHash.get(this.ignoreCase ? string.toLowerCase() : string);
        if (n == null) {
            String string2 = msg.getMessage1("XSUE-0200", string);
            throw new OracleXMLSQLException(string2);
        }
        return n - 1;
    }

    public void setCommitBatch(int n) {
        this.commitBatch = n > 0 ? n : 0;
    }

    public void setSQLToXMLNameEscaping(boolean bl) {
        this.xDocIsEsc = bl;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
        this.tabColHash = null;
        this.colNames = null;
        this.clearInsertSettings();
        this.clearUpdateSettings();
        this.clearDeleteSettings();
        this.updHash = null;
        this.keyHash = null;
    }

    public void setRowTag(String string) {
        this.rowtagName = string == null || string.length() == 0 ? null : string;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string == null || string.length() == 0 ? DATE_FORMAT : string;
    }

    public URL createURL(String string) {
        return OracleXMLSave.getURL(string);
    }

    public static URL getURL(String string) {
        URL uRL = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists()) {
                String string2 = msg.getMessage1("XSUE-0016", string);
                throw new OracleXMLSQLException(string2);
            }
            try {
                String string3 = file.getAbsolutePath();
                String string4 = System.getProperty("file.separator");
                if (string4.length() == 1) {
                    char c = string4.charAt(0);
                    if (c != '/') {
                        string3 = string3.replace(c, '/');
                    }
                    if (string3.charAt(0) != '/') {
                        string3 = '/' + string3;
                    }
                }
                string3 = "file://" + string3;
                if (file.isDirectory()) {
                    string3 = string3 + '/';
                }
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new OracleXMLSQLException(malformedURLException2);
            }
        }
        return uRL;
    }

    private void validateColHash(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string2 = this.ignoreCase ? string2.toLowerCase() : string2;
            if (this.tabColHash.containsKey(string2)) continue;
            String string3 = msg.getMessage2(string, string2, this.tableName);
            throw new OracleXMLSQLException(string3);
        }
    }

    private Hashtable createHashFromStrArray(String[] stringArray, String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(stringArray.length);
        Integer n = new Integer(1);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (stringArray[i] == null) {
                String string3 = msg.getMessage0("XSUE-0201");
                throw new OracleXMLSQLException(string3);
            }
            String string4 = string2 = this.ignoreCase ? stringArray[i].toLowerCase() : stringArray[i];
            if (!this.tabColHash.containsKey(string2)) {
                String string5 = msg.getMessage2(string, string2, this.tableName);
                throw new OracleXMLSQLException(string5);
            }
            hashtable.put(string2, n);
        }
        return hashtable;
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            this.clearSavePoint();
            this.clearInsertSettings();
            this.clearUpdateSettings();
            this.clearDeleteSettings();
            this.cleanLobList();
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        finally {
            this.setAllToNull();
        }
    }

    private void setAllToNull() {
        this.keyHash = null;
        this.updHash = null;
        this.keyColNames = null;
        this.updColNames = null;
        this.insStmt = null;
        this.updStmt = null;
        this.delStmt = null;
        this.insBindPos = null;
        this.updBindPos = null;
        this.delBindPos = null;
    }

    private void createSavePoint() throws SQLException {
        this.setSavePt = this.conn.prepareStatement("savepoint SYS_XSU_hope_0001000");
        this.rollbackToSavePt = this.conn.prepareStatement("rollback to savepoint SYS_XSU_hope_0001000");
    }

    private void clearSavePoint() {
        try {
            if (this.setSavePt != null) {
                this.setSavePt.close();
            }
            if (this.rollbackToSavePt != null) {
                this.rollbackToSavePt.close();
            }
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        finally {
            this.setSavePt = null;
            this.rollbackToSavePt = null;
        }
    }

    private Object getObjectVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        int n = oracleColumnName.getColumnType();
        if (n == 2002) {
            return this.getStructVal(node, oracleColumnName);
        }
        if (n == 2003) {
            return this.getArrayVal(node, oracleColumnName);
        }
        if (node.getFirstChild() == null) {
            return null;
        }
        switch (n) {
            case 2006: {
                return this.getRefVal(node, oracleColumnName);
            }
            case 91: 
            case 92: 
            case 93: {
                if (!this.usedbdates) {
                    return this.createTimestamp(node.getFirstChild().getNodeValue());
                }
                return node.getFirstChild().getNodeValue();
            }
            case 2004: 
            case 2005: {
                return this.getLobVal(node, oracleColumnName);
            }
            case -5: {
                String string = node.getFirstChild().getNodeValue();
                if (string.length() > 19) {
                    return new BigInteger(string);
                }
                return new Long(string);
            }
            case 2: {
                return new Integer(node.getFirstChild().getNodeValue());
            }
            case 6: {
                if (oracleColumnName.scale < 7) {
                    return new Float(node.getFirstChild().getNodeValue());
                }
            }
            case 8: {
                return new Double(node.getFirstChild().getNodeValue());
            }
            case -4: 
            case -3: 
            case -2: {
                return OracleXMLConvert.convertHexStringToByte(node.getFirstChild().getNodeValue());
            }
            case 2007: {
                return this.getXMLTypeVal(node, oracleColumnName);
            }
        }
        return node.getFirstChild().getNodeValue();
    }

    public STRUCT getStructVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        int n;
        OracleADTName oracleADTName = (OracleADTName)oracleColumnName;
        Object[] objectArray = new Object[oracleADTName.getAttributeCount()];
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        String string = null;
        for (n = objectArray.length - 1; n >= 0; --n) {
            objectArray[n] = null;
        }
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            string = nodeList.item(i).getNodeName();
            if (string.startsWith("#", 0)) continue;
            n = oracleADTName.getAttributePos(string);
            if (n < 0) {
                String string2 = msg.getMessage1("XSUE-0200", string);
                throw new OracleXMLSQLException(string2);
            }
            objectArray[n] = this.getObjectVal(nodeList.item(i), oracleADTName.getAttributeName(n));
        }
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)((String)oracleADTName.getBaseTypeObj()), (Connection)this.conn);
        return new STRUCT(structDescriptor, this.conn, objectArray);
    }

    private Object getLobVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        BLOB bLOB;
        String string = node.getFirstChild().getNodeValue();
        if (oracleColumnName.getColumnType() == 2005) {
            bLOB = oracleColumnName.precision == -1 ? this.createTempCLOBFromString(string, true) : this.createTempCLOBFromString(string);
            this.clobList.addElement(bLOB);
        } else {
            bLOB = this.createTempBLOBFromString(string);
            this.blobList.addElement(bLOB);
        }
        return bLOB;
    }

    private OPAQUE getXMLTypeVal(Node node, OracleColumnName oracleColumnName) throws SQLException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ((XMLNode)node.getFirstChild()).print(printWriter);
        String string = stringWriter.toString();
        XMLType xMLType = XMLType.createXML((Connection)this.conn, (String)string);
        return xMLType;
    }

    private REF getRefVal(Node node, OracleColumnName oracleColumnName) throws SQLException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("REFTYPE");
        if (node2 == null) {
            if (this.ignoreCase) {
                node2 = namedNodeMap.getNamedItem("REFTYPE".toLowerCase());
            }
            if (node2 == null) {
                String string = msg.getMessage2("XSUE-0204", oracleColumnName.getLabel(), "REFTYPE");
                throw new OracleXMLSQLException(string);
            }
        }
        StructDescriptor structDescriptor = new StructDescriptor(node2.getNodeValue(), this.conn);
        byte[] byArray = OracleXMLConvert.convertHexStringToByte(node.getFirstChild().getNodeValue());
        return new REF(structDescriptor, this.conn, byArray);
    }

    private ARRAY getArrayVal(Node node, OracleColumnName oracleColumnName) throws SQLException, ParseException, IOException {
        Object[] objectArray;
        int n;
        OracleCollectionName oracleCollectionName = (OracleCollectionName)oracleColumnName;
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)((String)oracleCollectionName.getBaseTypeObj()), (Connection)this.conn);
        NodeList nodeList = node.getChildNodes();
        Object[] objectArray2 = new Object[nodeList.getLength()];
        OracleColumnName oracleColumnName2 = oracleCollectionName.getBaseColumnName();
        int n2 = arrayDescriptor.getBaseType();
        int n3 = oracleColumnName2.getColumnType();
        if (n3 == 0 && (n2 == 2002 || n2 == 2003)) {
            String string = oracleCollectionName.getBaseColumnName().getColumnType() + " != " + arrayDescriptor.getBaseType();
            String string2 = "getArrayVal:  " + msg.getMessage1("XSUE-0001", string);
            throw new OracleXMLSQLException(string2);
        }
        int n4 = 0;
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray = nodeList.item(n);
            if (objectArray.getNodeName().startsWith("#", 0)) continue;
            objectArray2[n4] = this.getObjectVal((Node)objectArray, oracleColumnName2);
            ++n4;
        }
        if (n != n4) {
            objectArray = new Object[n4];
            --n4;
            while (n4 >= 0) {
                objectArray[n4] = objectArray2[n4];
                --n4;
            }
            return new ARRAY(arrayDescriptor, this.conn, (Object)objectArray);
        }
        return new ARRAY(arrayDescriptor, this.conn, (Object)objectArray2);
    }

    public void cleanLobList() {
        int n = this.clobList.size();
        int n2 = this.blobList.size();
        if (n == 0 && n2 == 0) {
            return;
        }
        try {
            int n3;
            if (n > 0) {
                for (n3 = 0; n3 < n; ++n3) {
                    CLOB.freeTemporary((CLOB)((CLOB)this.clobList.elementAt(n3)));
                }
                this.clobList.removeAllElements();
            }
            if (n2 > 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    BLOB.freeTemporary((BLOB)((BLOB)this.blobList.elementAt(n3)));
                }
                this.blobList.removeAllElements();
            }
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception.toString());
        }
    }

    private Timestamp createTimestamp(String string) throws ParseException {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(this.dateFormat);
        }
        Date date = this.dateFormatter.parse(string);
        return new Timestamp(date.getTime());
    }

    public void collectTimingInfo(boolean bl) {
        this.collectTimingInfo = bl;
        if (bl) {
            this.tim = new OracleXMLTimer();
        }
    }

    public String getTimingInfo() {
        if (this.tim == null) {
            return "No timing result to display.  Execute getXML first before.";
        }
        return this.tim.getResult();
    }

    private void clearInsertSettings() {
        this.insBindPos = null;
        try {
            if (this.insStmt != null) {
                this.insStmt.close();
            }
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        finally {
            this.insStmt = null;
        }
    }

    public int insertXML(URL uRL) {
        return this.saveXML(uRL, 1);
    }

    public int insertXML(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        int n = this.saveXML(stringReader, 1);
        ((Reader)stringReader).close();
        return n;
    }

    public int insertXML(Reader reader) {
        return this.saveXML(reader, 1);
    }

    public int insertXML(InputStream inputStream) {
        return this.saveXML(inputStream, 1);
    }

    public int insertXML(Document document) {
        return this.saveXML(document, 1);
    }

    private PreparedStatement createInsStmt(NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        hashtableArray[0] = null;
        if (this.insStmt != null && this.insBindPos != null) {
            hashtableArray[0] = this.insBindPos;
            return this.insStmt;
        }
        Hashtable hashtable = nodeList != null ? this.createHashFromNodeList(null, nodeList) : (this.updHash == null || this.updHash.isEmpty() ? this.tabColHash : this.updHash);
        StringBuffer stringBuffer = new StringBuffer("insert into " + this.tableName + " (");
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        String string = null;
        int n = 1;
        while (enumeration.hasMoreElements()) {
            if (n != 1) {
                stringBuffer.append(",");
            }
            string = (String)enumeration.nextElement();
            if (this.ignoreCase) {
                if (this.xDocIsEsc) {
                    stringBuffer.append(OracleXMLConvert.xmlToSqlName(string));
                } else {
                    stringBuffer.append(string);
                }
            } else if (this.xDocIsEsc) {
                stringBuffer.append("\"" + OracleXMLConvert.xmlToSqlName(string) + "\"");
            } else {
                stringBuffer.append("\"" + string + "\"");
            }
            hashtable2.put(string, new Integer(n));
            ++n;
        }
        if (this.nullVector == null) {
            this.nullVector = new BitSet(n - 1);
        }
        stringBuffer.append(") values (");
        for (int i = 0; i < n - 1; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append(")");
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        hashtableArray[0] = hashtable2;
        return preparedStatement;
    }

    private boolean isOracleSpecificType(int n) {
        return n == 2002 || n == 2006 || n == 2003 || n == 2007;
    }

    private void clearUpdateSettings() {
        this.updBindPos = null;
        try {
            if (this.updStmt != null) {
                this.updStmt.close();
            }
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        finally {
            this.updStmt = null;
        }
    }

    public int updateXML(URL uRL) {
        return this.saveXML(uRL, 2);
    }

    public int updateXML(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        int n = this.saveXML(stringReader, 2);
        ((Reader)stringReader).close();
        return n;
    }

    public int updateXML(Reader reader) {
        return this.saveXML(reader, 2);
    }

    public int updateXML(InputStream inputStream) {
        return this.saveXML(inputStream, 2);
    }

    public int updateXML(Document document) {
        return this.saveXML(document, 2);
    }

    private PreparedStatement createUpdStmt(NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        hashtableArray[0] = null;
        if (this.keyHash == null || this.keyHash.isEmpty()) {
            String string = msg.getMessage1("XSUE-0206", "setKeyColumnList()");
            throw new OracleXMLSQLException(string);
        }
        if (this.updStmt != null && this.updBindPos != null) {
            hashtableArray[0] = this.updBindPos;
            return this.updStmt;
        }
        Hashtable hashtable = nodeList != null ? this.createHashFromNodeList(this.keyHash, nodeList) : this.updHash;
        if (hashtable == null || hashtable.isEmpty()) {
            if (nodeList == null) {
                return null;
            }
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0207"));
        }
        StringBuffer stringBuffer = new StringBuffer("update " + this.tableName + " set ");
        String string = null;
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(hashtable.size() + this.keyHash.size());
        Enumeration enumeration = hashtable.keys();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            if (n != 1) {
                stringBuffer.append(", ");
            }
            string = (String)enumeration.nextElement();
            if (this.ignoreCase) {
                if (this.xDocIsEsc) {
                    stringBuffer.append(OracleXMLConvert.xmlToSqlName(string));
                } else {
                    stringBuffer.append(string);
                }
            } else if (this.xDocIsEsc) {
                stringBuffer.append("\"" + OracleXMLConvert.xmlToSqlName(string) + "\"");
            } else {
                stringBuffer.append("\"" + string + "\"");
            }
            stringBuffer.append(" = ? ");
            hashtable2.put(string, new Integer(n));
            ++n;
        }
        boolean bl = true;
        enumeration = this.keyHash.keys();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
                stringBuffer.append(" where ");
            } else {
                stringBuffer.append(" and ");
            }
            string = (String)enumeration.nextElement();
            if (this.ignoreCase) {
                if (this.xDocIsEsc) {
                    stringBuffer.append(OracleXMLConvert.xmlToSqlName(string));
                } else {
                    stringBuffer.append(string);
                }
            } else if (this.xDocIsEsc) {
                stringBuffer.append("\"" + OracleXMLConvert.xmlToSqlName(string) + "\"");
            } else {
                stringBuffer.append("\"" + string + "\"");
            }
            stringBuffer.append(" = ? ");
            hashtable2.put(string, new Integer(n));
            ++n;
        }
        if (this.nullVector == null) {
            this.nullVector = new BitSet(n - 1);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        hashtableArray[0] = hashtable2;
        return preparedStatement;
    }

    private void clearDeleteSettings() {
        this.delBindPos = null;
        try {
            if (this.delStmt != null) {
                this.delStmt.close();
            }
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        finally {
            this.delStmt = null;
        }
    }

    public int deleteXML(URL uRL) {
        return this.saveXML(uRL, 3);
    }

    public int deleteXML(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        int n = this.saveXML(stringReader, 3);
        ((Reader)stringReader).close();
        return n;
    }

    public int deleteXML(Reader reader) {
        return this.saveXML(reader, 3);
    }

    public int deleteXML(InputStream inputStream) {
        return this.saveXML(inputStream, 3);
    }

    public int deleteXML(Document document) {
        return this.saveXML(document, 3);
    }

    private PreparedStatement createDelStmt(NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        Hashtable hashtable;
        hashtableArray[0] = null;
        if (this.delStmt != null && this.delBindPos != null) {
            hashtableArray[0] = this.delBindPos;
            return this.delStmt;
        }
        if (nodeList != null) {
            hashtable = this.createHashFromNodeList(null, nodeList);
        } else {
            if (this.keyHash == null || this.keyHash.isEmpty()) {
                return null;
            }
            hashtable = this.keyHash;
        }
        StringBuffer stringBuffer = new StringBuffer("delete from " + this.tableName + " where 1=1");
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(hashtable.size());
        int n = 1;
        Enumeration enumeration = hashtable.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(" and ");
            string = (String)enumeration.nextElement();
            if (this.ignoreCase) {
                if (this.xDocIsEsc) {
                    stringBuffer.append(OracleXMLConvert.xmlToSqlName(string));
                } else {
                    stringBuffer.append(string);
                }
            } else if (this.xDocIsEsc) {
                stringBuffer.append("\"" + OracleXMLConvert.xmlToSqlName(string) + "\"");
            } else {
                stringBuffer.append("\"" + string + "\"");
            }
            stringBuffer.append(" = ? ");
            hashtable2.put(string, new Integer(n));
            ++n;
        }
        if (this.nullVector == null) {
            this.nullVector = new BitSet(n);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        hashtableArray[0] = hashtable2;
        return preparedStatement;
    }

    private Hashtable createHashFromNodeList(Hashtable hashtable, NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        String string = null;
        Integer n2 = new Integer(10);
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>(n);
        for (int i = 0; i < n; ++i) {
            string = nodeList.item(i).getNodeName();
            if (string.startsWith("#", 0)) continue;
            String string2 = string = this.ignoreCase ? string.toLowerCase() : string;
            if (hashtable != null && hashtable.containsKey(string)) continue;
            hashtable2.put(string, n2);
        }
        return hashtable2;
    }

    public void setBatchSize(int n) {
        this.batchSize = n > 0 ? n : DEFAULT_BATCH_SIZE;
    }

    public void setKeyColumnList(String[] stringArray) {
        if (stringArray.length <= 0) {
            String string = "setKeyColumnList:  " + msg.getMessage0("XSUE-0208");
            throw new OracleXMLSQLException(string);
        }
        this.clearUpdateSettings();
        this.clearDeleteSettings();
        this.keyHash = null;
        this.keyColNames = stringArray;
        this.keyHashValid = false;
    }

    void setKeyColumn(String string) {
        if (string == null) {
            String string2 = "setKeyColumn:  " + msg.getMessage0("XSUE-0201");
            throw new OracleXMLSQLException(string2);
        }
        if (this.keyHash == null) {
            this.keyHash = new Hashtable(10);
        }
        this.keyHash.put(this.ignoreCase ? string.toLowerCase() : string, this.keyHash);
        this.keyHashValid = false;
        this.clearUpdateSettings();
        this.clearDeleteSettings();
    }

    void clearKeyColumnList() {
        this.keyHash = null;
        this.keyHashValid = true;
        this.clearUpdateSettings();
        this.clearDeleteSettings();
    }

    public void setUpdateColumnList(String[] stringArray) {
        if (stringArray.length <= 0) {
            String string = "setUpdateColumnList:  " + msg.getMessage0("XSUE-0209");
            throw new OracleXMLSQLException(string);
        }
        this.clearInsertSettings();
        this.clearUpdateSettings();
        this.updHash = null;
        this.updColNames = stringArray;
        this.updHashValid = false;
    }

    void setUpdateColumn(String string) {
        if (string == null) {
            String string2 = "setUpdateColumn:  " + msg.getMessage0("XSUE-0201");
            throw new OracleXMLSQLException(string2);
        }
        if (this.updHash == null) {
            this.updHash = new Hashtable(10);
        }
        this.updHash.put(this.ignoreCase ? string.toLowerCase() : string, this.updHash);
        this.updHashValid = false;
        this.clearInsertSettings();
        this.clearUpdateSettings();
    }

    void clearUpdateColumnList() {
        this.updHash = null;
        this.updHashValid = true;
        this.clearInsertSettings();
        this.clearUpdateSettings();
    }

    private int saveXML(URL uRL, int n) {
        try {
            this.initParser();
            this.parser.parse(uRL);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        return this.saveXML((Document)this.parser.getDocument(), n);
    }

    private int saveXML(Reader reader, int n) {
        try {
            this.initParser();
            this.parser.parse(reader);
            return this.saveXML((Document)this.parser.getDocument(), n);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
    }

    private int saveXML(InputStream inputStream, int n) {
        try {
            this.initParser();
            this.parser.parse(inputStream);
            return this.saveXML((Document)this.parser.getDocument(), n);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
    }

    private int saveXML(Document document, int n) {
        try {
            Object object;
            if (this.xslt != null) {
                object = this.xslp.processXSL(this.xslt, (XMLDocument)document);
                document = new XMLDocument();
                document.appendChild((Node)object);
            }
            boolean bl = false;
            if (this.rowtagName != null) {
                this.rowtagName = OracleXMLConvert.validateName(this.rowtagName, this.xDocIsEsc ? 4 : 0);
                object = document.getElementsByTagName(this.rowtagName);
                if (this.ignoreCase && (object == null || object.getLength() == 0)) {
                    object = document.getDocumentElement().getChildNodes();
                }
                bl = true;
            } else {
                object = document.getDocumentElement().getChildNodes();
            }
            if (object == null || object.getLength() == 0 || object.getLength() == 1 && object.item(0).getNodeName().startsWith("#", 0)) {
                throw new OracleXMLSQLException(msg.getMessage0("XSUE-0210"));
            }
            if (this.collectTimingInfo) {
                this.tim.start("modifyNodeVal ----", 0);
            }
            int n2 = this.saveNodes((NodeList)object, bl, n);
            if (this.collectTimingInfo) {
                this.tim.stop();
            }
            int n3 = n2;
            return n3;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
        finally {
            this.cleanLobList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int saveNodes(NodeList nodeList, boolean bl, int n) throws SQLException, ParseException, IOException {
        int n3;
        if (this.colNames == null || this.tabColHash == null) {
            this.getTableMetaData();
        }
        if (this.keyHash == null && this.keyColNames != null) {
            this.keyHash = this.createHashFromStrArray(this.keyColNames, "XSUE-0202");
            this.keyHashValid = true;
        } else if (!this.keyHashValid) {
            this.validateColHash(this.keyHash, "XSUE-0202");
        }
        if (this.updHash == null && this.updColNames != null) {
            this.updHash = this.createHashFromStrArray(this.updColNames, "XSUE-0203");
            this.updHashValid = true;
        } else if (!this.updHashValid) {
            this.validateColHash(this.updHash, "XSUE-0202");
        }
        boolean bl2 = this.conn.getAutoCommit();
        if (bl2) {
            this.conn.setAutoCommit(false);
        }
        Hashtable[] hashtableArray = new Hashtable[1];
        PreparedStatement preparedStatement = this.createStmt(n, null, hashtableArray);
        int n2 = n3 = bl2 ? this.batchSize : this.commitBatch;
        if (this.oracleconn) {
            if (this.setSavePt == null || this.rollbackToSavePt == null) {
                this.createSavePoint();
            }
            this.setSavePt.executeUpdate();
        }
        int n5 = bl ? nodeList.getLength() : 1;
        NodeList nodeList2 = null;
        int n6 = 0;
        int n7 = 0;
        int n22 = 0;
        boolean bl3 = false;
        this.batched = 0;
        try {
            try {}
            catch (Exception exception) {
                if (bl3) {
                    this.conn.rollback();
                } else if (this.rollbackToSavePt != null) {
                    this.rollbackToSavePt.execute();
                } else {
                    n22 += n7;
                }
                String string = exception instanceof OracleXMLSQLException ? "" : exception.getClass().getName() + ": ";
                if (exception.getMessage() != null) {
                    string = string + exception.getMessage();
                }
                String string2 = String.valueOf(n6) + ".  ";
                string2 = bl3 || !this.oracleconn ? string2 + msg.getMessage1("XSUE-0212", String.valueOf(n22)) : string2 + msg.getMessage0("XSUE-0213");
                String string3 = msg.getMessage2("XSUE-0211", string, string2);
                throw new OracleXMLSQLException(string3, exception, false);
            }
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            if (hashtableArray[0] == null && preparedStatement != null) {
                preparedStatement.close();
            } else {
                switch (n) {
                    case 1: {
                        this.insStmt = preparedStatement;
                        this.insBindPos = hashtableArray[0];
                        break;
                    }
                    case 2: {
                        this.updStmt = preparedStatement;
                        this.updBindPos = hashtableArray[0];
                        break;
                    }
                    case 3: {
                        this.delStmt = preparedStatement;
                        this.delBindPos = hashtableArray[0];
                        break;
                    }
                }
            }
            preparedStatement = null;
            hashtableArray = null;
            this.cleanLobList();
            if (!bl2) throw throwable;
            this.conn.setAutoCommit(bl2);
            throw throwable;
        }
        while (n6 < n5) {
            if (bl) {
                if (nodeList.item(n6).getNodeName().startsWith("#", 0)) {
                    ++n6;
                    continue;
                }
                nodeList2 = nodeList.item(n6).getChildNodes();
            } else {
                nodeList2 = nodeList;
            }
            if (hashtableArray[0] != null) {
                n7 += this.saveNodeVal(preparedStatement, hashtableArray[0], nodeList2);
            } else {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                preparedStatement = this.createStmt(n, nodeList2, hashtableArray);
                n7 += this.saveNodeVal(preparedStatement, hashtableArray[0], nodeList2);
                hashtableArray[0] = null;
            }
            ++n6;
            if (n3 > 0) {
                if (n6 % n3 != 0) continue;
                if (this.batched > 0) {
                    n7 += ((OraclePreparedStatement)preparedStatement).sendBatch();
                    this.batched = 0;
                }
                this.conn.commit();
                this.cleanLobList();
                bl3 = true;
                n22 += n7;
                n7 = 0;
                continue;
            }
            if (n7 == 0) continue;
            n22 += n7;
            n7 = 0;
        }
        if (this.batched > 0 || n3 == 0) {
            n7 += ((OraclePreparedStatement)preparedStatement).sendBatch();
        }
        if (n3 > 0) {
            this.conn.commit();
        }
        if (n7 != n3) {
            n22 += n7;
        }
        Object var19_14 = null;
        if (hashtableArray[0] == null && preparedStatement != null) {
            preparedStatement.close();
        } else {
            switch (n) {
                case 1: {
                    this.insStmt = preparedStatement;
                    this.insBindPos = hashtableArray[0];
                    break;
                }
                case 2: {
                    this.updStmt = preparedStatement;
                    this.updBindPos = hashtableArray[0];
                    break;
                }
                case 3: {
                    this.delStmt = preparedStatement;
                    this.delBindPos = hashtableArray[0];
                    break;
                }
            }
        }
        preparedStatement = null;
        hashtableArray = null;
        this.cleanLobList();
        if (!bl2) return n22;
        this.conn.setAutoCommit(bl2);
        return n22;
    }

    private PreparedStatement createStmt(int n, NodeList nodeList, Hashtable[] hashtableArray) throws SQLException, ParseException, IOException {
        PreparedStatement preparedStatement;
        switch (n) {
            case 1: {
                preparedStatement = this.createInsStmt(nodeList, hashtableArray);
                break;
            }
            case 2: {
                preparedStatement = this.createUpdStmt(nodeList, hashtableArray);
                break;
            }
            case 3: {
                preparedStatement = this.createDelStmt(nodeList, hashtableArray);
                break;
            }
            default: {
                return null;
            }
        }
        if (preparedStatement != null) {
            if (this.oracleconn) {
                this.actualBatchSize = nodeList == null ? this.batchSize : 1;
                ((OraclePreparedStatement)preparedStatement).setExecuteBatch(this.actualBatchSize);
            } else {
                this.actualBatchSize = 1;
            }
        }
        return preparedStatement;
    }

    private int saveNodeVal(PreparedStatement preparedStatement, Hashtable hashtable, NodeList nodeList) throws SQLException, ParseException, IOException {
        Integer n;
        String string;
        int n2;
        this.nullVector.xor(this.nullVector);
        int n3 = nodeList.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            Node node = nodeList.item(n2);
            string = node.getNodeName();
            if (string.startsWith("#", 0) || (n = (Integer)hashtable.get(this.ignoreCase ? string.toLowerCase() : string)) == null) continue;
            this.nullVector.set(n);
            this.setBindValue(preparedStatement, node, this.getColNamesIndex(string), n);
        }
        n2 = 0;
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        OracleColumnName oracleColumnName = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (Integer)hashtable.get(this.ignoreCase ? string.toLowerCase() : string);
            if (this.nullVector.get(n)) continue;
            oracleColumnName = this.colNames[this.getColNamesIndex(string)];
            if (oracleColumnName.precision == -1) {
                ((OraclePreparedStatement)preparedStatement).setFormOfUse(n.intValue(), (short)2);
            }
            if (this.isOracleSpecificType(oracleColumnName.getColumnType())) {
                bl = true;
                ((OraclePreparedStatement)preparedStatement).setNull(n.intValue(), oracleColumnName.getColumnType(), (String)oracleColumnName.getBaseTypeObj());
                continue;
            }
            preparedStatement.setNull(n, oracleColumnName.getColumnType());
        }
        if (bl && this.actualBatchSize > 1) {
            if (this.batched > 0) {
                n2 += ((OraclePreparedStatement)preparedStatement).sendBatch();
                this.batched = 0;
            }
            preparedStatement.executeUpdate();
            n2 += ((OraclePreparedStatement)preparedStatement).sendBatch();
            bl = false;
        } else {
            n2 = preparedStatement.executeUpdate();
            ++this.batched;
            if (this.batched == this.actualBatchSize) {
                this.batched = 0;
            }
        }
        return n2;
    }

    private void setBindValue(PreparedStatement preparedStatement, Node node, int n, int n2) throws SQLException, ParseException, IOException {
        OracleColumnName oracleColumnName = this.colNames[n];
        String string = null;
        switch (oracleColumnName.getColumnType()) {
            case 2002: {
                ((OraclePreparedStatement)preparedStatement).setSTRUCT(n2, this.getStructVal(node, oracleColumnName));
                break;
            }
            case 2003: {
                ((OraclePreparedStatement)preparedStatement).setARRAY(n2, this.getArrayVal(node, oracleColumnName));
                break;
            }
            case 2006: {
                ((OraclePreparedStatement)preparedStatement).setREF(n2, this.getRefVal(node, oracleColumnName));
                break;
            }
            case 2007: {
                if (node.getFirstChild() != null) {
                    ((OraclePreparedStatement)preparedStatement).setOPAQUE(n2, this.getXMLTypeVal(node, oracleColumnName));
                    break;
                }
                preparedStatement.setNull(n2, oracleColumnName.getColumnType());
                break;
            }
            case 2005: {
                if (oracleColumnName.precision == -1) {
                    ((OraclePreparedStatement)preparedStatement).setFormOfUse(n2, (short)2);
                }
                if (node.getFirstChild() != null) {
                    string = node.getFirstChild().getNodeValue();
                    CLOB cLOB = null;
                    cLOB = oracleColumnName.precision == -1 ? this.createTempCLOBFromString(string, true) : this.createTempCLOBFromString(string);
                    ((OraclePreparedStatement)preparedStatement).setCLOB(n2, cLOB);
                    this.clobList.addElement(cLOB);
                    break;
                }
                preparedStatement.setNull(n2, oracleColumnName.getColumnType());
                break;
            }
            case 2004: {
                if (node.getFirstChild() != null) {
                    string = node.getFirstChild().getNodeValue();
                    BLOB bLOB = this.createTempBLOBFromString(string);
                    ((OraclePreparedStatement)preparedStatement).setBLOB(n2, bLOB);
                    this.blobList.addElement(bLOB);
                    break;
                }
                preparedStatement.setNull(n2, oracleColumnName.getColumnType());
                break;
            }
            case 93: {
                if (node.getFirstChild() != null) {
                    if (!this.usedbdates) {
                        preparedStatement.setTimestamp(n2, this.createTimestamp(node.getFirstChild().getNodeValue()));
                        break;
                    }
                    preparedStatement.setString(n2, node.getFirstChild().getNodeValue());
                    break;
                }
                preparedStatement.setNull(n2, 93);
                break;
            }
            case 2: {
                if (node.getFirstChild() != null) {
                    preparedStatement.setInt(n2, Integer.parseInt(node.getFirstChild().getNodeValue()));
                    break;
                }
                preparedStatement.setNull(n2, 2);
                break;
            }
            case 6: {
                if (node.getFirstChild() != null) {
                    preparedStatement.setFloat(n2, Float.parseFloat(node.getFirstChild().getNodeValue()));
                    break;
                }
                preparedStatement.setNull(n2, 6);
                break;
            }
            case 8: {
                if (node.getFirstChild() != null) {
                    preparedStatement.setDouble(n2, Double.parseDouble(node.getFirstChild().getNodeValue()));
                    break;
                }
                preparedStatement.setNull(n2, 8);
                break;
            }
            default: {
                if (oracleColumnName.precision == -1) {
                    ((OraclePreparedStatement)preparedStatement).setFormOfUse(n2, (short)2);
                }
                if (node.getFirstChild() != null) {
                    preparedStatement.setString(n2, node.getFirstChild().getNodeValue());
                    break;
                }
                preparedStatement.setNull(n2, oracleColumnName.getColumnType());
            }
        }
    }

    private CLOB createTempCLOBFromString(String string) throws SQLException, IOException {
        return this.createTempCLOBFromString(string, false);
    }

    private CLOB createTempCLOBFromString(String string, boolean bl) throws SQLException, IOException {
        short s = 1;
        if (bl) {
            s = 2;
        }
        CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)true, (int)10, (short)s);
        try {
            cLOB.putString(1L, string);
        }
        catch (SQLException sQLException) {
            int n = cLOB.getChunkSize();
            n = n < 4000 ? 4000 / n * n : 4000;
            char[] cArray = new char[n];
            long l = 0L;
            int n2 = 0;
            StringReader stringReader = new StringReader(string);
            int n3 = string.length();
            while ((n2 = stringReader.read(cArray, 0, n)) > -1) {
                cLOB.putChars(l + 1L, cArray);
                if ((long)n3 >= (l += (long)n2) + (long)n) continue;
                n = n3 % n;
                cArray = new char[n];
            }
            stringReader.close();
        }
        return cLOB;
    }

    private BLOB createTempBLOBFromString(String string) throws SQLException, IOException {
        BLOB bLOB = BLOB.createTemporary((Connection)this.conn, (boolean)true, (int)10);
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        byte[] byArray = OracleXMLConvert.convertHexStringToByte(string);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.flush();
        outputStream.close();
        return bLOB;
    }
}

