/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSet;

public class OracleXMLDataSetExtJdbc
extends OracleXMLDataSet {
    OracleXMLDataSetExtJdbc[] dsetList = null;
    ResultSet[] rsetList = null;
    private boolean ncharSuported = true;
    private int[] cursorCols = null;

    public OracleXMLDataSetExtJdbc(Connection connection, OracleResultSet oracleResultSet) throws SQLException {
        this.conn = connection;
        this.rset = oracleResultSet;
        this.rsetIsExt = true;
        this.rmdata = this.rset.getMetaData();
        this.rsetVal = this.rset.next();
        if (this.cursorCols == null) {
            this.rememberCursorCols();
        }
        this.isConsistent = true;
    }

    public OracleXMLDataSetExtJdbc(Connection connection, String string) throws SQLException, IOException {
        this(connection, new StringReader(string));
    }

    public OracleXMLDataSetExtJdbc(Connection connection, Reader reader) throws SQLException, IOException {
        this.conn = connection;
        String string = this.processSQLQuery(reader);
        reader.close();
        this.stmt = this.conn.prepareStatement(string);
        if (this.bindPosHash != null) {
            this.isConsistent = false;
            return;
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetExtJdbc(Connection connection, Reader reader, Vector vector, Vector vector2) throws IOException, SQLException {
        this.conn = connection;
        if (vector != null) {
            String string = null;
            if (vector2 == null || vector.size() != vector2.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0010"));
            }
            string = this.processSQLQuery(reader);
            if (vector.size() != this.bindPosHash.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0011"));
            }
            this.stmt = this.conn.prepareStatement(string);
            for (int i = vector.size() - 1; i >= 0; --i) {
                this.bindValue((String)vector.elementAt(i), (String)vector2.elementAt(i));
            }
        } else {
            StringBuffer stringBuffer = OracleXMLConvert.ReaderToStrBuf(reader, null);
            this.stmt = this.conn.prepareStatement(stringBuffer.toString());
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetExtJdbc(Connection connection) {
        this.conn = connection;
    }

    public void refreshDataSet() {
        super.refreshDataSet();
        if (this.cursorCols == null) {
            this.rememberCursorCols();
        }
    }

    public void close() throws SQLException {
        super.close();
        this.closeRsetList();
        if (this.rset != null && !this.rsetIsExt) {
            this.rset.close();
        }
    }

    private final void rememberCursorCols() {
        int n;
        try {
            this.cursorCols = new int[this.rmdata.getColumnCount()];
            n = 0;
            for (int i = 0; i < this.rmdata.getColumnCount(); ++i) {
                if (this.rmdata.getColumnType(i + 1) != -10) continue;
                this.cursorCols[n++] = i + 1;
            }
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
        int[] nArray = new int[n];
        System.arraycopy(this.cursorCols, 0, nArray, 0, nArray.length);
        this.cursorCols = nArray;
        nArray = null;
    }

    public int isNullable(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        if (this.rmdata.getColumnType(n) == -10) {
            return 0;
        }
        return this.rmdata.isNullable(n);
    }

    public Object getColumnTypeObject(int n) throws SQLException {
        OracleXMLDataSetExtJdbc oracleXMLDataSetExtJdbc;
        int n2;
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        if (this.rmdata.getColumnType(n) != -10) {
            return this.rmdata.getColumnTypeName(n);
        }
        if (this.dsetList == null) {
            this.dsetList = new OracleXMLDataSetExtJdbc[this.rmdata.getColumnCount()];
            for (n2 = this.rmdata.getColumnCount() - 1; n2 >= 0; --n2) {
                this.dsetList[n2] = null;
            }
        }
        if (this.rsetList == null) {
            this.rsetList = new ResultSet[this.rmdata.getColumnCount()];
            for (n2 = this.rmdata.getColumnCount() - 1; n2 >= 0; --n2) {
                this.rsetList[n2] = null;
            }
        }
        if (this.isEmpty()) {
            return null;
        }
        OracleResultSet oracleResultSet = (OracleResultSet)this.rset.getObject(n);
        this.rsetList[n - 1] = oracleResultSet;
        this.dsetList[n - 1] = oracleXMLDataSetExtJdbc = new OracleXMLDataSetExtJdbc(this.conn, oracleResultSet);
        return oracleXMLDataSetExtJdbc;
    }

    public void getStructMetaData(Object object, String[][] stringArray, Object[][] objectArray, int[][] nArray, int[][] nArray2, int[][] nArray3) throws SQLException {
        String string = (String)object;
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)string, (Connection)this.conn);
        int n = structDescriptor.getLength();
        stringArray[0] = new String[n];
        objectArray[0] = new Object[n];
        nArray[0] = new int[n];
        nArray2[0] = new int[n];
        nArray3[0] = new int[n];
        ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
        for (int i = 1; i <= n; ++i) {
            stringArray[0][i - 1] = resultSetMetaData.getColumnLabel(i);
            nArray[0][i - 1] = resultSetMetaData.getColumnType(i);
            if (nArray[0][i - 1] == 2006) {
                String string2 = resultSetMetaData.getColumnTypeName(i);
                objectArray[0][i - 1] = string2.substring("REF ".length());
            } else {
                objectArray[0][i - 1] = resultSetMetaData.getColumnTypeName(i);
            }
            if (OracleXMLDataSetExtJdbc.isNumeric(nArray[0][i - 1])) {
                nArray2[0][i - 1] = resultSetMetaData.getPrecision(i);
                nArray3[0][i - 1] = resultSetMetaData.getScale(i);
            } else if (OracleXMLDataSetExtJdbc.isString(nArray[0][i - 1])) {
                nArray3[0][i - 1] = resultSetMetaData.getColumnDisplaySize(i);
            }
            if (!OracleXMLDataSetExtJdbc.isCHARic(nArray[0][i - 1]) || !((OracleResultSetMetaData)resultSetMetaData).isNCHAR(i)) continue;
            nArray2[0][i - 1] = -1;
        }
    }

    public void getCollectionMetaData(Object object, Object[] objectArray, int[] nArray, int[] nArray2, int[] nArray3) throws SQLException {
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)((String)object), (Connection)this.conn);
        objectArray[0] = arrayDescriptor.getBaseName();
        nArray[0] = arrayDescriptor.getBaseType();
        OracleType oracleType = arrayDescriptor.getOracleTypeCOLLECTION().getElementType();
        if (oracleType instanceof OracleTypeNUMBER) {
            nArray2[0] = ((OracleTypeNUMBER)oracleType).getPrecision();
            nArray3[0] = ((OracleTypeNUMBER)oracleType).getScale();
        } else if (oracleType instanceof OracleTypeCHAR) {
            nArray3[0] = ((OracleTypeCHAR)oracleType).getLength();
        }
    }

    public boolean fetchNextRow() throws SQLException {
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        if (this.rsetFirstTime) {
            this.rsetFirstTime = false;
            return this.rsetVal;
        }
        this.dsetList = null;
        this.closeRsetList();
        return this.rset.next();
    }

    public boolean skipNextRow() throws SQLException {
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        if (this.rsetFirstTime) {
            this.rsetFirstTime = false;
            return this.rsetVal;
        }
        this.dsetList = null;
        for (int i = 0; i < this.cursorCols.length; ++i) {
            int n = this.cursorCols[i];
            try {
                ((OracleResultSet)this.rset).getCursor(n).close();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.closeRsetList();
        return this.rset.next();
    }

    public Object getObject(int n) throws SQLException {
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        if (this.dsetList == null || this.dsetList[n - 1] == null) {
            if (this.rmdata.getColumnType(n) != -10) {
                return ((OracleResultSet)this.rset).getOracleObject(n);
            }
            if (this.rsetList == null) {
                this.rsetList = new ResultSet[this.rmdata.getColumnCount()];
                for (int i = this.rmdata.getColumnCount() - 1; i >= 0; --i) {
                    this.rsetList[i] = null;
                }
            }
            OracleResultSet oracleResultSet = (OracleResultSet)this.rset.getObject(n);
            this.rsetList[n - 1] = oracleResultSet;
            return new OracleXMLDataSetExtJdbc(this.conn, oracleResultSet);
        }
        return this.dsetList[n - 1];
    }

    public void closeDsetList() throws SQLException {
        if (this.dsetList == null) {
            return;
        }
        for (int i = this.dsetList.length - 1; i >= 0; --i) {
            if (this.dsetList[i] == null) continue;
            this.dsetList[i].close();
        }
        this.dsetList = null;
    }

    private void closeRsetList() throws SQLException {
        if (this.rsetList == null) {
            return;
        }
        for (int i = this.rsetList.length - 1; i >= 0; --i) {
            if (this.rsetList[i] == null) continue;
            this.rsetList[i].close();
        }
        this.rsetList = null;
    }

    public Object[] getStructAttributes(Object object) throws SQLException {
        return ((STRUCT)object).getOracleAttributes();
    }

    public Object[] getCollectionValues(Object object) throws SQLException {
        return ((ARRAY)object).getOracleArray();
    }

    public boolean cursorFetchNextRow(Object object, int n) throws SQLException {
        return ((OracleXMLDataSetExtJdbc)object).fetchNextRow();
    }

    public Object cursorGetColumnObject(Object object, int n) throws SQLException {
        return ((OracleXMLDataSetExtJdbc)object).getObject(n);
    }

    public void cursorGetMetaData(Object object, String[][] stringArray, Object[][] objectArray, int[][] nArray, int[][] nArray2, int[][] nArray3) throws SQLException {
        OracleXMLDataSetExtJdbc oracleXMLDataSetExtJdbc = (OracleXMLDataSetExtJdbc)object;
        int n = oracleXMLDataSetExtJdbc.getColumnCount();
        stringArray[0] = new String[n];
        objectArray[0] = new Object[n];
        nArray[0] = new int[n];
        nArray2[0] = new int[n];
        nArray3[0] = new int[n];
        for (int i = 0; i < n; ++i) {
            stringArray[0][i] = oracleXMLDataSetExtJdbc.getColumnLabel(i + 1);
            objectArray[0][i] = oracleXMLDataSetExtJdbc.getColumnTypeObject(i + 1);
            nArray[0][i] = oracleXMLDataSetExtJdbc.getColumnType(i + 1);
            if (OracleXMLDataSetExtJdbc.isNumeric(nArray[0][i])) {
                nArray2[0][i] = oracleXMLDataSetExtJdbc.getPrecision(i + 1);
                nArray3[0][i] = oracleXMLDataSetExtJdbc.getScale(i + 1);
                continue;
            }
            if (!OracleXMLDataSetExtJdbc.isString(nArray[0][i])) continue;
            nArray3[0][i] = oracleXMLDataSetExtJdbc.getColumnDisplaySize(i + 1);
        }
    }

    public void cursorClose(Object object) throws SQLException {
        ((OracleXMLDataSetExtJdbc)object).close();
    }

    public static CLOB createTempCLOBFromString(Connection connection, String string, String string2) throws SQLException, IOException {
        if (string2 == null) {
            string2 = "DBMS_LOB.SESSION";
        }
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(" declare x CLOB := null;  begin dbms_lob.createtemporary(x, FALSE, " + string2 + ");" + " ? := x; end;");
        oracleCallableStatement.registerOutParameter(1, 2005);
        oracleCallableStatement.execute();
        CLOB cLOB = oracleCallableStatement.getCLOB(1);
        try {
            cLOB.putString(1L, string);
        }
        catch (SQLException sQLException) {
            int n = cLOB.getChunkSize();
            n = n < 4000 ? 4000 / n * n : 4000;
            char[] cArray = new char[n];
            long l = 0L;
            int n2 = 0;
            StringReader stringReader = new StringReader(string);
            int n3 = string.length();
            while ((n2 = stringReader.read(cArray, 0, n)) > -1) {
                cLOB.putChars(l + 1L, cArray);
                if ((long)n3 >= (l += (long)n2) + (long)n) continue;
                n = n3 % n;
                cArray = new char[n];
            }
            stringReader.close();
        }
        oracleCallableStatement.close();
        return cLOB;
    }

    public static BLOB createTempBLOBFromString(Connection connection, String string, String string2) throws SQLException, IOException {
        if (string2 == null) {
            string2 = "DBMS_LOB.SESSION";
        }
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(" declare x BLOB := null;  begin dbms_lob.createtemporary(x, FALSE, " + string2 + ");" + " ? := x; end;");
        oracleCallableStatement.registerOutParameter(1, 2004);
        oracleCallableStatement.execute();
        BLOB bLOB = oracleCallableStatement.getBLOB(1);
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        byte[] byArray = OracleXMLConvert.convertHexStringToByte(string);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.flush();
        outputStream.close();
        oracleCallableStatement.close();
        return bLOB;
    }

    public String getScalarStrValue(Object object) throws SQLException {
        return ((Datum)object).stringValue();
    }

    public String getDateString(Object object) throws SQLException {
        if (this.sdf == null) {
            return this.getScalarStrValue(object);
        }
        return this.sdf.format(((Datum)object).timestampValue());
    }

    public boolean isNCHAR(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        try {
            if (this.ncharSuported) {
                return ((OracleResultSetMetaData)this.rmdata).isNCHAR(n);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.ncharSuported = false;
        }
        return false;
    }
}

