/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.core;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.gss.util.XmlValidate;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.util.RepConversion;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.xdb.XMLType;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.OracleXMLSQLNoRowsException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.XSUXSchemaHandler;
import oracle.xml.sql.core.OracleXMLTimer;
import oracle.xml.sql.dataset.OracleXMLDataSet;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.dataset.OracleXMLDataSetGenJdbc;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenDOM;
import oracle.xml.sql.name.OracleADTName;
import oracle.xml.sql.name.OracleCollectionName;
import oracle.xml.sql.name.OracleColumnName;
import oracle.xml.sql.name.OracleCursorName;
import oracle.xml.sql.name.OracleScalarName;
import org.w3c.dom.Document;

public class OracleXMLConvert {
    static final String VERSION_TARGET = "xml";
    static final String VERSION_NUM = "1.0";
    static final String VERSION_DATA = "version=\"1.0\"";
    static final String STYLESHEET_TARGET = "xml-stylesheet";
    static final String STYLESHEET_TYPE_DATA = "text/xsl";
    static final String FOOTER = "</>";
    static final String WHITESPACE = " ";
    static final String NULL_ATTR_ID = "NULL";
    static final String NULL_ATTR_VAL = " (TRUE|FALSE) \"FALSE\">\n";
    static final String NULL_ATTR_VAL2 = " (TRUE|FALSE) #FIXED \"FALSE\">\n";
    static final String COLL_ITEM_TAG = "_ITEM";
    static final String COLL_ID_ATTR_TAG = "itemNo";
    public static final String DOC_T = "DOCUMENT";
    public static final String ROWCOUNT = "num";
    public static final String ROWSET_TAG = "ROWSET";
    public static final String ROW_TAG = "ROW";
    public static final String ERROR_TAG = "ERROR";
    public static final String REFATTRNAME = "REFTYPE";
    public static final String ELEMENT_NAME = "<!ELEMENT ";
    public static final String ATTLIST_NAME = "<!ATTLIST ";
    public static final String PCDATA_NAME = " (#PCDATA)>\n";
    public static final String EMPTY_NAME = " EMPTY";
    public static final String NULLABLE = "nillable";
    public static final String XSNULL = "xsi:nil";
    public static final String XSTRUE = "true";
    public static final String XSFALSE = "false";
    public static final String XSD = "xsd:";
    public static final String NONSSLOC = "xsi:noNamespaceSchemaLocation";
    public static final String SLOC = "xsi:schemaLocation";
    public static final String ORANS = "http://xmlns.oracle.com/xdb/";
    static final int SQLXml = 0;
    static final int SQLXmlWithDTD = 1;
    public static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    public static final int DEFAULT_CASE = 0;
    public static final int MAXROWS_NONE = 0;
    public static final int MAXROWS_ALL = -1;
    public static final int MAXROWS_DEFAULT = -1;
    public static final int SKIPROWS_NONE = 0;
    public static final int SKIPROWS_ALL = -1;
    public static final int SKIPROWS_DEFAULT = 0;
    public static final int NONE = 0;
    int metaType = 0;
    public static final int DTD = 1;
    public static final int SCHEMA = 2;
    int docType = 1;
    public static final int XML = 1;
    public static final int VER = 2;
    private int miscFlags = 0;
    public static final int PUT = 1;
    public static final int IGNORE_CASE = 2;
    public static final int WITH_ESCAPE = 4;
    public Reader metaHeader = null;
    public Reader dataHeader = null;
    private String DTDString = null;
    private int tagCase = 0;
    String rowCountStr = "num";
    String rowTag = "ROW";
    String rowsetTag = "ROWSET";
    String errTag = "ERROR";
    String collItemTag = "_ITEM";
    String collIdAttrName = null;
    String refAttrName = "REFTYPE";
    String nullAttrId = "NULL";
    String isNull = "TRUE";
    String notNull = "FALSE";
    public String docTag = null;
    private boolean objClosed = false;
    private int rowIdColNum = 0;
    private String rowIdColName = null;
    private int rowIdAttrDt = 2;
    private boolean keepCursor = false;
    private boolean rootNodeSupplied = false;
    private boolean useColumnLabelAsRoot = false;
    private boolean useTypeForCollElemTag = false;
    private OracleColumnName[] colNames;
    private Hashtable colNamesHash = null;
    private int[] xAttrIdxs = null;
    private int xElemCnt = 0;
    private int firstXElemNmIdx = 0;
    private boolean xAttrAfterElem = false;
    private OracleColumnName val;
    private String qstring = null;
    private ResultSet rset = null;
    private OracleXMLDataSet dset = null;
    private int maxRows = -1;
    private int skipRows = 0;
    private String styleSheetType = null;
    private String styleSheetURI = null;
    boolean noRowsException = false;
    boolean raiseException = false;
    boolean useNullAttrId = false;
    boolean ignoreEmptyElements = true;
    private Connection conn;
    private OracleXMLTimer tim = null;
    private boolean collectTimingInfo = false;
    private String tns = null;
    public long curCount = 1L;
    Exception extException = null;
    boolean dsetIsExt = false;
    boolean rsetIsExt = false;
    public static XSUMesg msg = new XSUMesg();
    public static XmlValidate xmlValidate = null;
    boolean namesValid = false;
    String dateFormat = null;
    boolean updateDateFormat = false;
    int colCount = -1;

    public OracleXMLConvert(Connection connection) {
        this.conn = connection;
    }

    public OracleXMLConvert(Connection connection, String string) {
        this.conn = connection;
        this.qstring = string;
    }

    public OracleXMLConvert(Connection connection, ResultSet resultSet) {
        this.conn = connection;
        this.rset = resultSet;
        this.rsetIsExt = true;
    }

    public OracleXMLConvert(Connection connection, OracleXMLDataSet oracleXMLDataSet) {
        this.conn = connection;
        this.dset = oracleXMLDataSet;
        this.dsetIsExt = true;
        this.colNamesHash = new Hashtable(20);
    }

    private void initObject() throws SQLException, IOException {
        if (this.dset == null) {
            if (this.qstring != null) {
                this.dset = this.conn instanceof OracleConnection ? new OracleXMLDataSetExtJdbc(this.conn, this.qstring) : new OracleXMLDataSetGenJdbc(this.conn, this.qstring);
            } else if (this.rset != null) {
                this.dset = this.conn instanceof OracleConnection ? (this.rset instanceof OracleResultSet ? new OracleXMLDataSetExtJdbc(this.conn, (OracleResultSet)this.rset) : new OracleXMLDataSetGenJdbc(this.conn, this.rset)) : new OracleXMLDataSetGenJdbc(this.conn, this.rset);
            }
        }
        if (this.updateDateFormat) {
            this.dset.setDateFormat(this.dateFormat);
            this.updateDateFormat = false;
        }
        this.colCount = this.dset.getColumnCount();
        if (this.rowIdColName != null) {
            for (int i = this.colCount; i > 0; --i) {
                if (this.dset.getColumnName(i).compareTo(this.rowIdColName) != 0) continue;
                this.rowIdAttrDt = this.dset.getColumnType(i);
                if (this.rowIdAttrDt != 1 && this.rowIdAttrDt != 12 && this.rowIdAttrDt != 2 && this.rowIdAttrDt != 3 && this.rowIdAttrDt != 4 && this.rowIdAttrDt != 91 && this.rowIdAttrDt != 93) {
                    throw new OracleXMLSQLException(msg.getMessage1("XSUE-0002", this.rowIdColName), this.errTag);
                }
                this.rowIdColNum = i;
            }
            if (this.rowIdColNum == 0) {
                throw new OracleXMLSQLException(msg.getMessage1("XSUE-0003", this.rowIdColName), this.errTag);
            }
            this.rowIdColName = null;
        }
    }

    public void resetResultSet() {
        if (this.dset != null) {
            this.dset.resetResultSet();
        }
    }

    public void bindValue(String string, String string2) {
        this.dset.bindValue(string, string2);
    }

    public void clearBindValues() {
        this.dset.clearBindValues();
    }

    public void setColNames(OracleColumnName[] oracleColumnNameArray) {
        this.colNames = oracleColumnNameArray;
    }

    public void keepObjectOpen(boolean bl) {
        this.keepCursor = bl;
    }

    public void setRootNodeSupplied(boolean bl) {
        this.rootNodeSupplied = bl;
    }

    public void setRowsetTag(String string) {
        this.rowsetTag = string == null || string.length() == 0 ? null : string;
        this.namesValid = false;
    }

    public void setRowTag(String string) {
        this.rowTag = string == null || string.length() == 0 ? null : string;
        this.namesValid = false;
    }

    public void setRowIdAttrName(String string) {
        this.rowCountStr = string == null || string.length() == 0 ? null : string;
        this.namesValid = false;
    }

    public void setRowIdAttrValue(String string) {
        this.rowIdColName = string == null || string.length() == 0 ? null : string;
        this.rowIdColNum = 0;
    }

    public void setCollIdAttrName(String string) {
        this.collIdAttrName = string == null || string.length() == 0 ? null : string;
    }

    public void useTypeForCollElemTag(boolean bl) {
        this.useTypeForCollElemTag = bl;
        this.DTDString = null;
    }

    public void useNullAttrId(boolean bl) {
        if (this.useNullAttrId != bl) {
            this.DTDString = null;
            this.colNames = null;
            this.colNamesHash = null;
            this.useNullAttrId = bl;
        }
    }

    public void setIgnoreEmptyElements(boolean bl) {
        this.ignoreEmptyElements = bl;
    }

    public void setStylesheetHeader(String string) {
        this.styleSheetURI = string;
        this.styleSheetType = STYLESHEET_TYPE_DATA;
    }

    public void setStylesheetHeader(String string, String string2) {
        this.styleSheetURI = string;
        this.styleSheetType = string2;
    }

    public void setTagNameCase(int n) {
        if (n != this.tagCase) {
            this.tagCase = n;
            this.errTag = this.convCase(this.errTag);
            this.rowsetTag = this.convCase(this.rowsetTag);
            this.rowTag = this.convCase(this.rowTag);
            this.docTag = this.convCase(this.docTag);
            this.rowCountStr = this.convCase(this.rowCountStr);
            this.refAttrName = this.convCase(this.refAttrName);
            this.collIdAttrName = this.convCase(this.collIdAttrName);
            this.collItemTag = this.convCase(this.collItemTag);
            this.nullAttrId = this.convCase(this.nullAttrId);
            this.DTDString = null;
            this.colNames = null;
            this.colNamesHash = null;
        }
    }

    public void setErrorTag(String string) {
        if (string != null && string.length() != 0) {
            this.errTag = string;
        }
    }

    public void setException(Exception exception) {
        if (this.extException == null) {
            this.extException = exception;
        }
    }

    public void setRaiseException(boolean bl) {
        this.raiseException = bl;
    }

    public void setRaiseNoRowsException(boolean bl) {
        this.noRowsException = bl;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setSkipRows(int n) {
        this.skipRows = n;
    }

    private String convCase(String string) {
        String string2 = string == null ? null : (this.tagCase == 0 ? string : (this.tagCase == 2 ? string.toUpperCase() : (this.tagCase == 1 ? string.toLowerCase() : string.toLowerCase())));
        return string2;
    }

    private void createErrorDocument(OracleXMLDocGen oracleXMLDocGen, String string) {
        oracleXMLDocGen.createNewDocument(true);
        oracleXMLDocGen.setVersion(VERSION_NUM);
        oracleXMLDocGen.addTextElement(this.errTag, string, false);
    }

    private void close(OracleXMLDocGen oracleXMLDocGen) {
        this.objClosed = true;
        try {
            if (this.dset != null && !this.dsetIsExt) {
                this.dset.close();
            }
            if (this.rset != null && !this.rsetIsExt) {
                this.rset.close();
            }
        }
        catch (SQLException sQLException) {
            if (!this.raiseException) {
                if (oracleXMLDocGen != null) {
                    this.createErrorDocument(oracleXMLDocGen, sQLException.getMessage());
                }
            }
            throw new OracleXMLSQLException(sQLException, this.errTag);
        }
    }

    public void close() {
        this.close(null);
    }

    public void collectTimingInfo(boolean bl) {
        this.collectTimingInfo = bl;
    }

    public String getTimingInfo() {
        if (this.tim == null) {
            return "No timing result to display.  Execute getXML first before.";
        }
        return this.tim.getResult();
    }

    public void setDateFormat(String string) {
        this.dateFormat = string == null || string.length() == 0 ? null : string;
        this.updateDateFormat = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getXML(OracleXMLDocGen oracleXMLDocGen, int n) {
        boolean bl = !this.noRowsException;
        try {
            if (this.extException != null) {
                throw this.extException;
            }
            if (this.objClosed) {
                throw new OracleXMLSQLException(msg.getMessage1("XSUE-0004", "keepObjectOpen()"), this.errTag);
            }
            if (n == 0 && this.docType == 0) {
                return;
            }
            this.initObject();
            this.metaType = n;
            oracleXMLDocGen.createNewDocument(false);
            if (this.collectTimingInfo) {
                if (this.tim == null) {
                    this.tim = new OracleXMLTimer();
                }
                this.tim.start("TOTAL GENERATION TIME ----", 0);
                this.tim.start("DTD generation (getDTD)", 0);
            }
            if (this.metaType != 0 || !this.dset.isEmpty()) {
                this.createColNames();
                this.validateNames();
            }
            if (!this.rootNodeSupplied && this.docType != 0) {
                oracleXMLDocGen.setVersion(VERSION_NUM);
            }
            if (this.styleSheetURI != null) {
                oracleXMLDocGen.createProcessingInstruction(STYLESHEET_TARGET, "href=\"" + this.styleSheetURI + "\" type=\"" + this.styleSheetType + "\"");
            }
            if (this.metaType == 1 && oracleXMLDocGen.supportMetatype(this.metaType) && !this.rootNodeSupplied) {
                this.getDTD(oracleXMLDocGen);
            }
            if (this.collectTimingInfo) {
                this.tim.stop();
            }
            Object object = null;
            Object object2 = null;
            Document[] documentArray = null;
            if (this.metaType == 2) {
                if (this.docType == 1) {
                    object = oracleXMLDocGen.startNewElement(DOC_T);
                    oracleXMLDocGen.addAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                }
                documentArray = this.getSchema(true);
                for (int i = documentArray.length - 1; i >= 0; --i) {
                    oracleXMLDocGen.insertXMLFragment(documentArray[i]);
                }
            }
            if (this.dataHeader != null && this.docType == 1) {
                object2 = oracleXMLDocGen.startNewElement(this.docTag);
                this.dataHeader.reset();
                oracleXMLDocGen.insertXMLFragment(this.dataHeader);
            }
            if (this.collectTimingInfo) {
                this.tim.start("Row to XML conversion", 0);
            }
            if (this.docType == 1) {
                Object object3 = null;
                if (this.rowsetTag != null) {
                    object3 = oracleXMLDocGen.startNewElement(this.rowsetTag);
                }
                if (documentArray != null) {
                    oracleXMLDocGen.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    oracleXMLDocGen.addAttribute(NONSSLOC, "#/DOCUMENT/xsd:schema[not(@targetNamespace)]");
                }
                if (this.skipRows != -1 && this.maxRows != 0 && !this.dset.isEmpty()) {
                    Object object4 = null;
                    if (this.skipRows > 0) {
                        this.dset.closeDsetList();
                    }
                    this.curCount = 0L;
                    while (this.curCount < (long)this.skipRows && this.dset.skipNextRow()) {
                        ++this.dset.rowCount;
                        ++this.curCount;
                    }
                    this.curCount = 1L;
                    while ((this.maxRows == -1 || this.curCount <= (long)this.maxRows) && this.dset.fetchNextRow()) {
                        if (this.curCount > 1L) {
                            if (this.useColumnLabelAsRoot) {
                                throw new OracleXMLSQLException(msg.getMessage0("XSUE-0005"), this.errTag);
                            }
                            if (this.rowTag == null && (this.colCount > 1 || this.xElemCnt != this.colCount)) {
                                throw new OracleXMLSQLException(msg.getMessage0("XSUE-0006"), this.errTag);
                            }
                        }
                        if (this.rowTag != null) {
                            if (this.rowCountStr != null) {
                                int n2;
                                String string = this.rowIdColNum != 0 && this.dset.getObject(this.rowIdColNum) != null ? ((n2 = this.colNames[this.rowIdColNum - 1].getColumnType()) >= 91 && n2 <= 93 ? this.dset.getDateString(this.dset.getObject(this.rowIdColNum)) : this.dset.getScalarStrValue(this.dset.getObject(this.rowIdColNum))) : Long.toString(this.dset.rowCount);
                                object4 = oracleXMLDocGen.startNewElementWithAttr(this.rowTag, this.rowCountStr, string);
                            } else {
                                object4 = oracleXMLDocGen.startNewElement(this.rowTag);
                            }
                        }
                        this.convertRow(this.dset, oracleXMLDocGen);
                        bl = true;
                        if (this.rowTag != null) {
                            oracleXMLDocGen.endElement(object4);
                        }
                        ++this.dset.rowCount;
                        ++this.curCount;
                    }
                }
                if (this.rowsetTag != null) {
                    oracleXMLDocGen.endElement(object3);
                }
            }
            if (this.collectTimingInfo) {
                this.tim.stop();
                this.tim.stop();
            }
            if (!bl) {
                throw new OracleXMLSQLNoRowsException(this.errTag);
            }
            if (this.dataHeader != null && this.docType == 1) {
                oracleXMLDocGen.endElement(object2);
            }
            if (this.metaType == 2 && this.docType == 1) {
                oracleXMLDocGen.endElement(object);
            }
        }
        catch (OracleXMLSQLNoRowsException oracleXMLSQLNoRowsException) {
            throw (OracleXMLSQLNoRowsException)oracleXMLSQLNoRowsException.fillInStackTrace();
        }
        catch (Exception exception) {
            if (this.raiseException) {
                if (exception instanceof OracleXMLSQLException) {
                    throw (OracleXMLSQLException)exception.fillInStackTrace();
                }
                throw new OracleXMLSQLException(exception, this.errTag);
            }
            this.createErrorDocument(oracleXMLDocGen, new OracleXMLSQLException(exception, this.errTag).toString());
            return;
        }
        finally {
            this.extException = null;
            if (!this.keepCursor) {
                this.close(oracleXMLDocGen);
            }
        }
    }

    public long getNumRowsProcessed() {
        return this.curCount - 1L;
    }

    public OracleColumnName[] createColNames() throws SQLException {
        if (this.colNames == null) {
            int n;
            int n2 = this.dset.getColumnCount();
            this.colNames = new OracleColumnName[n2];
            this.colNamesHash = new Hashtable(n2 * 2);
            for (n = 1; n <= n2; ++n) {
                int n3;
                int n4;
                int n5 = this.dset.getColumnType(n);
                if (OracleXMLDataSet.isNumeric(n5)) {
                    n4 = this.dset.getPrecision(n);
                    n3 = this.dset.getScale(n);
                } else {
                    n3 = 0;
                    n4 = 0;
                    if (OracleXMLDataSet.isString(n5)) {
                        n3 = this.dset.getColumnDisplaySize(n);
                    }
                    if (OracleXMLDataSet.isCHARic(n5) && this.dset.isNCHAR(n)) {
                        n4 = -1;
                    }
                }
                String string = this.dset.getColumnLabel(n);
                String string2 = (this.miscFlags & 1) == 0 ? this.convCase(string) : string;
                Object object = this.dset.getColumnTypeObject(n);
                boolean bl = this.dset.isNullable(n) == 1;
                this.colNames[n - 1] = this.createColName(n5, n4, n3, string2, object, bl);
                if (this.colNames[n - 1].isAttribute) {
                    if (this.xElemCnt <= 0) continue;
                    this.xAttrAfterElem = true;
                    continue;
                }
                if (this.xElemCnt == 0) {
                    this.firstXElemNmIdx = n - 1;
                }
                ++this.xElemCnt;
            }
            if (this.xAttrAfterElem) {
                this.xAttrIdxs = new int[n2 - this.xElemCnt];
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!this.colNames[i].isAttribute) continue;
                    this.xAttrIdxs[n] = i;
                    ++n;
                }
            }
        }
        return this.colNames;
    }

    private OracleColumnName createColName(int n, int n2, int n3, String string, Object object, boolean bl) throws SQLException {
        if (this.collectTimingInfo) {
            if (n == 2002) {
                this.tim.start(" ADT Col Name object (" + string + ")", 0);
            } else if (n == -10) {
                this.tim.start(" Cursor Col Name object (" + string + ")", 0);
            } else if (n == 2003) {
                this.tim.start(" Collection Col Name object (" + string + ")", 0);
            } else if (n == 2006) {
                this.tim.start(" REF Col Name object (" + string + ")", 0);
            } else {
                this.tim.start(" Scalar Col Name object (" + string + ")", 0);
            }
        }
        String string2 = this.convCase(string);
        switch (n) {
            case 2002: {
                this.val = this.createADTName(string, object);
                break;
            }
            case 2003: {
                this.val = this.createCollName(string, object);
                break;
            }
            case -10: {
                this.val = this.createCursorName(string, object);
                break;
            }
            case 91: 
            case 92: {
                n = 93;
            }
            default: {
                this.val = string.charAt(0) == '@' && (this.miscFlags & 1) == 0 ? new OracleScalarName(string.substring(1), n, n2, n3, object, true, this.miscFlags) : new OracleScalarName(string, n, n2, n3, object, false, this.miscFlags);
            }
        }
        this.val.isNullable = bl;
        if (this.collectTimingInfo) {
            this.tim.stop();
        }
        return this.val;
    }

    OracleColumnName createADTName(String string, Object object) throws SQLException {
        int n;
        int n2;
        OracleColumnName oracleColumnName = null;
        String[][] stringArray = new String[1][];
        Object[][] objectArray = new Object[1][];
        int[][] nArrayArray = new int[1][];
        int[][] nArrayArray2 = new int[1][];
        int[][] nArrayArray3 = new int[1][];
        OracleADTName oracleADTName = null;
        OracleColumnName oracleColumnName2 = (OracleColumnName)this.colNamesHash.get(object);
        if (oracleColumnName2 == null) {
            this.dset.getStructMetaData(object, stringArray, objectArray, nArrayArray, nArrayArray2, nArrayArray3);
        } else {
            n2 = ((OracleADTName)oracleColumnName2).getAttributeCount();
            stringArray[0] = new String[n2];
            objectArray[0] = new Object[n2];
            nArrayArray[0] = new int[n2];
            nArrayArray2[0] = new int[n2];
            nArrayArray3[0] = new int[n2];
            for (n = 0; n < n2; ++n) {
                OracleColumnName oracleColumnName3 = ((OracleADTName)oracleColumnName2).getAttributeName(n);
                stringArray[0][n] = oracleColumnName3.getLabel();
                objectArray[0][n] = oracleColumnName3.getBaseTypeObj();
                nArrayArray[0][n] = oracleColumnName3.getColumnType();
                nArrayArray2[0][n] = oracleColumnName3.precision;
                nArrayArray3[0][n] = oracleColumnName3.scale;
            }
        }
        oracleADTName = new OracleADTName(string, object, stringArray[0].length, this.miscFlags);
        for (n2 = 0; n2 < stringArray[0].length; ++n2) {
            oracleColumnName = this.createColName(nArrayArray[0][n2], nArrayArray2[0][n2], nArrayArray3[0][n2], this.convCase(stringArray[0][n2]), objectArray[0][n2], true);
            oracleADTName.setAttributeName(n2, oracleColumnName);
            if (oracleColumnName.isAttribute) {
                if (oracleADTName.xElemCnt <= 0) continue;
                oracleADTName.xAttrAfterElem = true;
                continue;
            }
            ++oracleADTName.xElemCnt;
        }
        if (oracleADTName.xAttrAfterElem) {
            oracleADTName.xAttrIdxs = new int[oracleADTName.attrCount - oracleADTName.xElemCnt];
            n2 = 0;
            for (n = 0; n < oracleADTName.attrCount; ++n) {
                if (!oracleADTName.attributeNames[n].isAttribute) continue;
                oracleADTName.xAttrIdxs[n2] = n;
                ++n2;
            }
        }
        if (oracleColumnName2 == null) {
            this.colNamesHash.put(object, oracleADTName);
        }
        return oracleADTName;
    }

    private OracleColumnName createCursorName(String string, Object object) throws SQLException {
        int n;
        if (object == null) {
            return new OracleCursorName(string, object, 0, 0);
        }
        OracleCursorName oracleCursorName = null;
        String[][] stringArray = new String[1][];
        Object[][] objectArray = new Object[1][];
        int[][] nArrayArray = new int[1][];
        int[][] nArrayArray2 = new int[1][];
        int[][] nArrayArray3 = new int[1][];
        this.dset.cursorGetMetaData(object, stringArray, objectArray, nArrayArray, nArrayArray2, nArrayArray3);
        oracleCursorName = new OracleCursorName(string, object, stringArray[0].length, this.miscFlags);
        OracleColumnName oracleColumnName = null;
        for (n = 0; n < stringArray[0].length; ++n) {
            oracleColumnName = this.createColName(nArrayArray[0][n], nArrayArray2[0][n], nArrayArray3[0][n], this.convCase(stringArray[0][n]), objectArray[0][n], true);
            oracleCursorName.setColumnName(n, oracleColumnName);
            if (oracleColumnName.isAttribute) {
                if (oracleCursorName.xElemCnt <= 0) continue;
                oracleCursorName.xAttrAfterElem = true;
                continue;
            }
            ++oracleCursorName.xElemCnt;
        }
        if (oracleCursorName.xAttrAfterElem) {
            oracleCursorName.xAttrIdxs = new int[oracleCursorName.colCount - oracleCursorName.xElemCnt];
            n = 0;
            for (int i = 0; i < oracleCursorName.colCount; ++i) {
                if (!oracleCursorName.curColNames[i].isAttribute) continue;
                oracleCursorName.xAttrIdxs[n] = i;
                ++n;
            }
        }
        this.colNamesHash.put(object, oracleCursorName);
        return oracleCursorName;
    }

    private OracleColumnName createCollName(String string, Object object) throws SQLException {
        int n;
        int n2;
        int n3;
        String string2 = null;
        Object object2 = null;
        OracleColumnName oracleColumnName = null;
        OracleColumnName oracleColumnName2 = (OracleColumnName)this.colNamesHash.get(object);
        if (oracleColumnName2 == null) {
            Object[] objectArray = new Object[1];
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            this.dset.getCollectionMetaData(object, objectArray, nArray, nArray2, nArray3);
            object2 = objectArray[0];
            n3 = nArray[0];
            n2 = nArray2[0];
            n = nArray3[0];
        } else {
            oracleColumnName = ((OracleCollectionName)oracleColumnName2).getBaseColumnName();
            object2 = oracleColumnName.getBaseTypeObj();
            n3 = oracleColumnName.getColumnType();
            n2 = oracleColumnName.precision;
            n = oracleColumnName.scale;
        }
        string2 = this.useTypeForCollElemTag ? OracleXMLDataSet.getTypesName(object2) : string + this.collItemTag;
        oracleColumnName = this.createColName(n3, n2, n, string2, object2, true);
        oracleColumnName = new OracleCollectionName(string, object, oracleColumnName, this.miscFlags);
        if (oracleColumnName2 == null) {
            this.colNamesHash.put(object, oracleColumnName);
        }
        return oracleColumnName;
    }

    public String getDTD(OracleXMLDocGen oracleXMLDocGen) throws SQLException {
        int n;
        if (this.DTDString != null) {
            oracleXMLDocGen.appendDTD(this.DTDString);
            return this.DTDString;
        }
        this.nullAttrId = this.convCase(NULL_ATTR_ID);
        this.isNull = "TRUE";
        this.notNull = "FALSE";
        String string = null;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(1000);
        try {
            if (this.metaHeader != null) {
                this.metaHeader.reset();
                OracleXMLConvert.ReaderToStrBuf(this.metaHeader, stringBuffer);
            } else {
                stringBuffer.append("<!DOCTYPE ");
                if (this.useColumnLabelAsRoot) {
                    stringBuffer.append(this.convCase(this.convCase(this.colNames[this.firstXElemNmIdx].getLabel())));
                } else {
                    stringBuffer.append(this.rowsetTag);
                }
                stringBuffer.append(" [\n");
            }
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException, this.errTag);
        }
        if (!this.useColumnLabelAsRoot) {
            stringBuffer.append(ELEMENT_NAME);
            stringBuffer.append(this.rowsetTag);
            if (this.rowTag != null) {
                stringBuffer.append(" (");
                stringBuffer.append(this.rowTag);
                stringBuffer.append(")*>\n");
                stringBuffer.append(ELEMENT_NAME);
                stringBuffer.append(this.rowTag);
            }
            if (this.xElemCnt < 1) {
                stringBuffer.append(EMPTY_NAME);
            } else {
                stringBuffer.append(" (");
                stringBuffer.append(this.convCase(this.convCase(this.colNames[this.firstXElemNmIdx].getLabel())));
                if (this.xElemCnt > 1 && !this.useNullAttrId && this.colNames[this.firstXElemNmIdx].isNullable) {
                    stringBuffer.append("?");
                }
                for (n = this.firstXElemNmIdx + 1; n < this.colCount; ++n) {
                    if (this.colNames[n].isAttribute) continue;
                    stringBuffer.append(", ");
                    stringBuffer.append(this.convCase(this.convCase(this.colNames[n].getLabel())));
                    if (this.useNullAttrId || !this.colNames[n].isNullable) continue;
                    stringBuffer.append("?");
                }
                stringBuffer.append(")");
            }
            if (this.rowTag == null) {
                if (0 < this.xElemCnt && this.xElemCnt < 2) {
                    stringBuffer.append("*>\n");
                } else {
                    stringBuffer.append(">\n");
                }
                string = this.rowsetTag;
            } else {
                stringBuffer.append(">\n");
                string = this.rowTag;
                if (this.rowCountStr != null) {
                    stringBuffer.append(ATTLIST_NAME);
                    stringBuffer.append(string);
                    stringBuffer.append(WHITESPACE);
                    stringBuffer.append(this.rowCountStr);
                    stringBuffer.append(" CDATA #REQUIRED>\n");
                }
            }
        }
        for (n = 0; n < this.colCount; ++n) {
            if (this.colNames[n].isAttribute) {
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(string);
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.convCase(this.colNames[n].getLabel()));
                stringBuffer.append(" CDATA #REQUIRED>\n");
                continue;
            }
            this.getObjectDTD(this.colNames[n], this.colNames[n].isNullable, stringBuffer, 1);
        }
        stringBuffer.append("]>\n");
        this.DTDString = stringBuffer.toString();
        oracleXMLDocGen.appendDTD(this.DTDString);
        return this.DTDString;
    }

    private void getObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        int n2 = oracleColumnName.getColumnType();
        switch (n2) {
            case 2002: {
                this.getADTObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            case 2003: {
                this.getCollObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            case -10: {
                this.getCursorObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            case 2006: {
                this.getREFObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            default: {
                String string = this.convCase(oracleColumnName.getLabel());
                stringBuffer.append(ELEMENT_NAME);
                stringBuffer.append(string);
                stringBuffer.append(PCDATA_NAME);
                if (!this.useNullAttrId) break;
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(string);
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.nullAttrId);
                if (bl) {
                    stringBuffer.append(NULL_ATTR_VAL);
                    break;
                }
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        }
        if (this.collectTimingInfo) {
            this.tim.stop();
        }
    }

    private void getADTObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        OracleColumnName oracleColumnName2;
        int n2;
        String string = this.convCase(oracleColumnName.getLabel());
        OracleADTName oracleADTName = (OracleADTName)oracleColumnName;
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(" (");
        int n3 = oracleADTName.getAttributeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleColumnName2 = oracleADTName.getAttributeName(n2);
            if (oracleColumnName2.isAttribute) continue;
            stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
            if (!this.useNullAttrId) {
                stringBuffer.append("?");
            }
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(", ");
        }
        if (this.useNullAttrId) {
            stringBuffer.append(")?>\n");
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        } else {
            stringBuffer.append(")>\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            oracleColumnName2 = oracleADTName.getAttributeName(n2);
            if (oracleColumnName2.isAttribute) {
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(string);
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
                stringBuffer.append(" CDATA #REQUIRED>\n");
                continue;
            }
            this.getObjectDTD(oracleColumnName2, oracleColumnName2.isNullable, stringBuffer, n + 1);
        }
    }

    private void getCursorObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        OracleColumnName oracleColumnName2;
        int n2;
        OracleCursorName oracleCursorName = (OracleCursorName)oracleColumnName;
        if (oracleCursorName.isIncomplete) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0101"));
        }
        int n3 = oracleCursorName.getColumnCount();
        String string = this.convCase(oracleCursorName.getLabel());
        String string2 = string + "_" + this.convCase(ROW_TAG);
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(string2);
        stringBuffer.append(")*>\n");
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string2);
        if (oracleCursorName.xElemCnt < 1) {
            stringBuffer.append(EMPTY_NAME);
        } else {
            stringBuffer.append(" (");
            for (n2 = 0; n2 < n3; ++n2) {
                oracleColumnName2 = oracleCursorName.getColumnName(n2);
                if (oracleColumnName2.isAttribute) continue;
                stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
                if (!this.useNullAttrId) {
                    stringBuffer.append("?");
                }
                if (n2 >= n3 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        if (this.useNullAttrId) {
            stringBuffer.append("?>\n");
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        } else {
            stringBuffer.append(">\n");
        }
        if (this.rowCountStr != null) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string2);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.convCase(ROWCOUNT));
            stringBuffer.append(" CDATA #REQUIRED>\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            oracleColumnName2 = oracleCursorName.getColumnName(n2);
            if (oracleColumnName2.isAttribute) {
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(string);
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
                stringBuffer.append(" CDATA #REQUIRED>\n");
                continue;
            }
            this.getObjectDTD(oracleColumnName2, oracleColumnName2.isNullable, stringBuffer, n + 1);
        }
    }

    private void getCollObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        String string = this.convCase(oracleColumnName.getLabel());
        OracleColumnName oracleColumnName2 = ((OracleCollectionName)oracleColumnName).getBaseColumnName();
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
        stringBuffer.append(")*>\n");
        if (this.collIdAttrName != null) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.collIdAttrName);
            stringBuffer.append(" CDATA #REQUIRED>\n");
        }
        if (this.useNullAttrId) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        }
        if (oracleColumnName2.getColumnType() == 2006) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.refAttrName);
            stringBuffer.append(" NMTOKEN #FIXED ");
            stringBuffer.append("\"");
            stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
            stringBuffer.append("\"");
            stringBuffer.append(">\n");
        }
        if (oracleColumnName2.getColumnType() == 2002 || oracleColumnName2.getColumnType() == 2003) {
            this.getObjectDTD(oracleColumnName2, true, stringBuffer, n + 1);
        } else {
            stringBuffer.append(ELEMENT_NAME);
            stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
            stringBuffer.append(PCDATA_NAME);
            if (this.useNullAttrId) {
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(this.convCase(oracleColumnName2.getLabel()));
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.nullAttrId);
                stringBuffer.append(NULL_ATTR_VAL);
            }
        }
    }

    private void getREFObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        String string = this.convCase(oracleColumnName.getLabel());
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(PCDATA_NAME);
        if (this.useNullAttrId) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        }
        stringBuffer.append(ATTLIST_NAME);
        stringBuffer.append(string);
        stringBuffer.append(WHITESPACE);
        stringBuffer.append(this.refAttrName);
        stringBuffer.append(" NMTOKEN #FIXED ");
        stringBuffer.append("\"");
        stringBuffer.append(oracleColumnName.getBaseTypeObj());
        stringBuffer.append("\"");
        stringBuffer.append(">\n");
    }

    private void convertRow(OracleXMLDataSet oracleXMLDataSet, OracleXMLDocGen oracleXMLDocGen) throws SQLException {
        if (this.xAttrAfterElem) {
            int n;
            for (n = 0; n < this.xAttrIdxs.length; ++n) {
                this.convertObjectToAttr(this.colNames[this.xAttrIdxs[n]], oracleXMLDataSet.getObject(this.xAttrIdxs[n] + 1), oracleXMLDocGen);
            }
            for (n = 0; n < this.colCount; ++n) {
                if (this.colNames[n].isAttribute) continue;
                this.convertObject(this.colNames[n].getColumnType(), this.colNames[n], oracleXMLDataSet.getObject(n + 1), oracleXMLDocGen, 2, -1);
            }
        } else {
            for (int i = 0; i < this.colCount; ++i) {
                this.convertObject(this.colNames[i].getColumnType(), this.colNames[i], oracleXMLDataSet.getObject(i + 1), oracleXMLDocGen, 2, -1);
            }
        }
    }

    private void convertObjectToAttr(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen) throws SQLException {
        if (object == null) {
            return;
        }
        int n = oracleColumnName.getColumnType();
        String string = this.convCase(oracleColumnName.getLabel());
        if (n == 2006) {
            OracleXMLConvert.convertByteToHexString(((REF)object).getBytes());
            oracleXMLDocGen.addAttribute(string, OracleXMLConvert.convertByteToHexString(((REF)object).getBytes()));
        } else if (n >= 91 && n <= 93) {
            oracleXMLDocGen.addAttribute(string, this.dset.getDateString(object));
        } else {
            oracleXMLDocGen.addAttribute(string, this.dset.getScalarStrValue(object));
        }
    }

    private void convertObject(int n, OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n2, int n3) throws SQLException {
        boolean bl = true;
        Object object2 = null;
        String string = oracleColumnName.getLabel();
        String string2 = (this.miscFlags & 1) == 0 ? string : this.convCase(string);
        if (object == null) {
            if (!this.useNullAttrId && this.ignoreEmptyElements) {
                return;
            }
            if (oracleColumnName.isAttribute) {
                return;
            }
            boolean bl2 = true;
            object2 = oracleXMLDocGen.startNewElement(string2);
            if (n3 != -1) {
                oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
            }
            if (this.useNullAttrId) {
                oracleXMLDocGen.addAttribute(this.nullAttrId, this.isNull);
                bl2 = false;
            }
            if (oracleXMLDocGen instanceof OracleXMLDocGenDOM) {
                ((OracleXMLDocGenDOM)oracleXMLDocGen).endElement(object2, bl2);
            } else {
                oracleXMLDocGen.endElement(object2);
            }
            return;
        }
        if (oracleColumnName.isAttribute) {
            if (n >= 91 && n <= 93) {
                oracleXMLDocGen.addAttribute(string2, this.dset.getDateString(object));
            } else {
                oracleXMLDocGen.addAttribute(string2, this.dset.getScalarStrValue(object));
            }
            return;
        }
        object2 = oracleXMLDocGen.startNewElement(string2);
        if (n3 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
        }
        if (n == 1 || n == 12 || n == -1) {
            oracleXMLDocGen.addTextValue(this.dset.getScalarStrValue(object), bl);
        } else if (n >= 2 && n <= 8) {
            bl = false;
            oracleXMLDocGen.addTextValue(this.dset.getScalarStrValue(object), bl);
        } else if (n >= 91 && n <= 93) {
            bl = false;
            oracleXMLDocGen.addTextValue(this.dset.getDateString(object), bl);
        } else {
            switch (n) {
                case 2002: {
                    this.convertADTObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2003: {
                    this.convertCollObject(oracleColumnName, object, oracleXMLDocGen, n2);
                    break;
                }
                case 2004: {
                    this.convertBlobObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2005: {
                    this.convertClobObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -8: {
                    this.convertRowIdObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -10: {
                    this.convertCursorObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2006: {
                    this.convertREFObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -13: {
                    this.convertBFileObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.convertRawObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2007: {
                    this.convertXMLObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                default: {
                    oracleXMLDocGen.addTextValue(this.dset.getScalarStrValue(object), bl);
                }
            }
        }
        oracleXMLDocGen.endElement(object2);
    }

    void convertADTObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        Object[] objectArray = this.dset.getStructAttributes(object);
        OracleADTName oracleADTName = (OracleADTName)oracleColumnName;
        OracleColumnName oracleColumnName2 = null;
        if (oracleADTName.xAttrAfterElem) {
            int n3;
            for (n3 = 0; n3 < oracleADTName.xAttrIdxs.length; ++n3) {
                oracleColumnName2 = oracleADTName.getAttributeName(oracleADTName.xAttrIdxs[n3]);
                this.convertObjectToAttr(oracleColumnName2, objectArray[oracleADTName.xAttrIdxs[n3]], oracleXMLDocGen);
            }
            for (n3 = 0; n3 < oracleADTName.attrCount; ++n3) {
                oracleColumnName2 = oracleADTName.getAttributeName(n3);
                if (oracleColumnName2.isAttribute) continue;
                this.convertObject(oracleColumnName2.getColumnType(), oracleColumnName2, objectArray[n3], oracleXMLDocGen, n + 1, -1);
            }
        } else {
            for (int i = 0; i < oracleADTName.attrCount; ++i) {
                oracleColumnName2 = oracleADTName.getAttributeName(i);
                this.convertObject(oracleColumnName2.getColumnType(), oracleColumnName2, objectArray[i], oracleXMLDocGen, n + 1, -1);
            }
        }
    }

    private void convertCursorObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        OracleCursorName oracleCursorName = (OracleCursorName)oracleColumnName;
        int n3 = 1;
        String string = this.convCase(oracleColumnName.getLabel()) + "_" + this.convCase(ROW_TAG);
        Object object2 = null;
        while (this.dset.cursorFetchNextRow(object, n3)) {
            OracleColumnName oracleColumnName2;
            Object object3;
            int n4;
            object2 = oracleXMLDocGen.startNewElementWithAttr(string, this.convCase(ROWCOUNT), Integer.toString(n3));
            if (oracleCursorName.xAttrAfterElem) {
                for (n4 = 0; n4 < oracleCursorName.xAttrIdxs.length; ++n4) {
                    object3 = this.dset.cursorGetColumnObject(object, oracleCursorName.xAttrIdxs[n4] + 1);
                    oracleColumnName2 = oracleCursorName.getColumnName(oracleCursorName.xAttrIdxs[n4]);
                    this.convertObjectToAttr(oracleColumnName2, object3, oracleXMLDocGen);
                }
                for (n4 = 0; n4 < oracleCursorName.colCount; ++n4) {
                    object3 = this.dset.cursorGetColumnObject(object, n4 + 1);
                    oracleColumnName2 = oracleCursorName.getColumnName(n4);
                    if (oracleColumnName2.isAttribute) continue;
                    if (oracleColumnName2 instanceof OracleCursorName && ((OracleCursorName)oracleColumnName2).isIncomplete) {
                        oracleCursorName.curColNames[n4] = oracleColumnName2 = this.createCursorName(this.convCase(oracleColumnName2.getLabel()), object3);
                        this.colNamesHash.put(object3, oracleColumnName2);
                    }
                    this.convertObject(oracleColumnName2.getColumnType(), oracleColumnName2, object3, oracleXMLDocGen, n + 1, -1);
                }
            } else {
                for (n4 = 0; n4 < oracleCursorName.colCount; ++n4) {
                    object3 = this.dset.cursorGetColumnObject(object, n4 + 1);
                    oracleColumnName2 = oracleCursorName.getColumnName(n4);
                    if (oracleColumnName2 instanceof OracleCursorName && ((OracleCursorName)oracleColumnName2).isIncomplete) {
                        oracleCursorName.curColNames[n4] = oracleColumnName2 = this.createCursorName(this.convCase(oracleColumnName2.getLabel()), object3);
                        this.colNamesHash.put(object3, oracleColumnName2);
                    }
                    this.convertObject(oracleColumnName2.getColumnType(), oracleColumnName2, object3, oracleXMLDocGen, n + 1, -1);
                }
            }
            oracleXMLDocGen.endElement(object2);
            ++n3;
        }
        this.dset.cursorClose(object);
    }

    private void convertCollObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n) throws SQLException {
        Object[] objectArray = this.dset.getCollectionValues(object);
        OracleColumnName oracleColumnName2 = ((OracleCollectionName)oracleColumnName).getBaseColumnName();
        int n2 = oracleColumnName2.getColumnType();
        for (int i = 0; i < objectArray.length; ++i) {
            this.convertObject(n2, oracleColumnName2, objectArray[i], oracleXMLDocGen, n + 1, this.collIdAttrName != null ? i + 1 : -1);
        }
    }

    private void convertREFObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        byte[] byArray = ((REF)object).getBytes();
        if (this.metaType == 0 || this.metaType == 1 && !oracleXMLDocGen.supportMetatype(this.metaType)) {
            oracleXMLDocGen.addAttribute(this.refAttrName, (String)oracleColumnName.getBaseTypeObj());
        }
        oracleXMLDocGen.addTextValue(OracleXMLConvert.convertByteToHexString(byArray), false);
    }

    private void convertClobObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        CLOB cLOB = (CLOB)object;
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        oracleXMLDocGen.addTextValue(string, true);
    }

    private void convertBlobObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        BLOB bLOB = (BLOB)object;
        byte[] byArray = bLOB.getBytes(1L, (int)bLOB.length());
        String string = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string, false);
    }

    private void convertBFileObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        BFILE bFILE = (BFILE)object;
        bFILE.openFile();
        byte[] byArray = bFILE.getBytes(1L, (int)bFILE.length());
        String string = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string, true);
    }

    private void convertXMLObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        OPAQUE oPAQUE = (OPAQUE)object;
        XMLType xMLType = XMLType.createXML((OPAQUE)oPAQUE);
        if (xMLType == null) {
            throw new OracleXMLSQLException("convertXMLObject(): " + msg.getMessage1("XSUE-0022", oPAQUE.getSQLTypeName()));
        }
        CLOB cLOB = xMLType.getClobVal();
        try {
            Reader reader = cLOB.getCharacterStream();
            oracleXMLDocGen.insertXMLFragment(reader);
            reader.close();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception, this.errTag);
        }
    }

    private void convertRawObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        byte[] byArray = null;
        if (object instanceof RAW) {
            byArray = ((RAW)object).getBytes();
        } else if (object instanceof byte[]) {
            byArray = (byte[])object;
        }
        String string = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string, false);
    }

    private void convertRowIdObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        byte[] byArray = ((ROWID)object).getBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        oracleXMLDocGen.addTextValue(stringBuffer.toString(), false);
    }

    private static String convertByteToHexString(byte[] byArray) {
        return RepConversion.bArray2String((byte[])byArray);
    }

    private static int convertCharToInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 48;
    }

    public static byte[] convertHexStringToByte(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 2];
        for (int i = string.length() - 1; i >= 0; i -= 2) {
            byArray[i / 2] = 0;
            int n = OracleXMLConvert.convertCharToInt(string.charAt(i));
            Integer n2 = new Integer(0xF & n);
            byArray[i / 2] = n2.byteValue();
            if (i == 0) break;
            n = OracleXMLConvert.convertCharToInt(string.charAt(i - 1));
            n2 = new Integer(0xF0 & n << 4);
            int n3 = i / 2;
            byArray[n3] = (byte)(byArray[n3] | n2.byteValue());
        }
        return byArray;
    }

    private int parseDotedStr(String string, String[] stringArray) {
        int n = 0;
        int n2 = string.indexOf(46);
        int n3 = 0;
        while (n2 != -1 && n3 < stringArray.length) {
            stringArray[n3++] = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        if (n < string.length() && n3 < stringArray.length) {
            stringArray[n3++] = string.substring(n, string.length() - 1);
        }
        return n3;
    }

    public Document[] getSchema(boolean bl) {
        try {
            this.initObject();
            if (this.metaHeader != null) {
                this.metaHeader.reset();
            }
            this.createColNames();
            this.validateNames();
            this.nullAttrId = XSNULL;
            this.isNull = XSTRUE;
            this.notNull = XSFALSE;
            Hashtable<String, XSUXSchemaHandler> hashtable = new Hashtable<String, XSUXSchemaHandler>(4);
            this.tns = "";
            XSUXSchemaHandler xSUXSchemaHandler = new XSUXSchemaHandler(bl);
            hashtable.put(this.tns, xSUXSchemaHandler);
            if (this.rowsetTag != null) {
                xSUXSchemaHandler.startCTypeElement(this.rowsetTag);
            }
            if (this.rowTag != null) {
                xSUXSchemaHandler.startCTypeElement(this.rowTag);
                xSUXSchemaHandler.addAttribute("minOccurs", "0");
                xSUXSchemaHandler.addAttribute("maxOccurs", "unbounded");
                if (this.rowCountStr != null) {
                    xSUXSchemaHandler.startAttribute(this.rowCountStr, xSUXSchemaHandler.getQTypeName(this.rowIdAttrDt));
                    xSUXSchemaHandler.endAttribute();
                }
            }
            if (this.rowTag == null) {
                if (this.rowsetTag == null) {
                    this.genColumnSchema(xSUXSchemaHandler, this.colNames[0], null, null);
                } else if (this.xElemCnt > 1) {
                    this.genColumnSchema(xSUXSchemaHandler, this.colNames[0], "0", null);
                } else {
                    this.genColumnSchema(xSUXSchemaHandler, this.colNames[0], "0", "unbounded");
                }
            } else {
                for (int i = 0; i < this.colCount; ++i) {
                    this.genColumnSchema(xSUXSchemaHandler, this.colNames[i], this.useNullAttrId ? null : "0", null);
                }
            }
            if (this.rowTag != null) {
                xSUXSchemaHandler.endCTypeElement();
            }
            if (this.rowsetTag != null) {
                xSUXSchemaHandler.endCTypeElement();
            }
            this.genTypeSchemas(xSUXSchemaHandler, hashtable, bl);
            Document[] documentArray = new Document[hashtable.size()];
            documentArray[0] = (Document)hashtable.remove(this.tns);
            ((XSUXSchemaHandler)((Object)documentArray[0])).endElement();
            int n = 1;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                documentArray[n] = (Document)enumeration.nextElement();
                ((XSUXSchemaHandler)((Object)documentArray[n])).endElement();
                ++n;
            }
            return documentArray;
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception);
        }
    }

    private void genTypeSchemas(XSUXSchemaHandler xSUXSchemaHandler, Hashtable hashtable, boolean bl) {
        Enumeration enumeration = this.colNamesHash.elements();
        while (enumeration.hasMoreElements()) {
            OracleColumnName oracleColumnName;
            OracleColumnName oracleColumnName2 = (OracleColumnName)enumeration.nextElement();
            if (oracleColumnName2.getColumnType() == -10) continue;
            Object object = oracleColumnName2.getBaseTypeObj();
            String string = this.dset.getTypesSchema(object);
            XSUXSchemaHandler xSUXSchemaHandler2 = (XSUXSchemaHandler)((Object)hashtable.get(string));
            if (xSUXSchemaHandler2 == null) {
                xSUXSchemaHandler2 = new XSUXSchemaHandler(string, ORANS + string, null, bl);
                hashtable.put(string, xSUXSchemaHandler2);
            }
            xSUXSchemaHandler2.startCType(OracleXMLDataSet.getTypesName(object));
            if (oracleColumnName2.getColumnType() == 2002) {
                oracleColumnName = (OracleADTName)oracleColumnName2;
                for (int i = 0; i < ((OracleADTName)oracleColumnName).getAttributeCount(); ++i) {
                    oracleColumnName2 = ((OracleADTName)oracleColumnName).getAttributeName(i);
                    if (OracleXMLDataSet.isString(oracleColumnName2.getColumnType())) {
                        xSUXSchemaHandler2.addStringElement(this.convCase(oracleColumnName2.getLabel()), oracleColumnName2.scale, false, oracleColumnName2.isAttribute);
                        continue;
                    }
                    if (oracleColumnName2.isAttribute) {
                        xSUXSchemaHandler2.startAttribute(this.convCase(oracleColumnName2.getLabel()), this.genSchDT(xSUXSchemaHandler2, oracleColumnName2));
                        xSUXSchemaHandler2.endAttribute();
                        continue;
                    }
                    xSUXSchemaHandler2.startElement(this.convCase(oracleColumnName2.getLabel()), this.genSchDT(xSUXSchemaHandler2, oracleColumnName2));
                    xSUXSchemaHandler2.addAttribute(NULLABLE, XSTRUE);
                    xSUXSchemaHandler2.addAttribute("minOccurs", "0");
                    if (oracleColumnName2.getColumnType() == 2006) {
                        xSUXSchemaHandler2.startAttribute(this.refAttrName, xSUXSchemaHandler2.getQTypeName(12));
                        xSUXSchemaHandler2.addAttribute("fixed", (String)oracleColumnName2.getBaseTypeObj());
                        xSUXSchemaHandler2.endAttribute();
                    }
                    xSUXSchemaHandler2.endElement();
                }
            } else if (oracleColumnName2.getColumnType() == 2003) {
                oracleColumnName = (OracleCollectionName)oracleColumnName2;
                oracleColumnName2 = ((OracleCollectionName)oracleColumnName).getBaseColumnName();
                if (OracleXMLDataSet.isString(oracleColumnName2.getColumnType())) {
                    xSUXSchemaHandler2.addStringElement(this.convCase(oracleColumnName2.getLabel()), oracleColumnName2.scale, true, false);
                } else {
                    xSUXSchemaHandler2.startElement(this.convCase(oracleColumnName2.getLabel()), this.genSchDT(xSUXSchemaHandler2, oracleColumnName2));
                    xSUXSchemaHandler2.addAttribute("minOccurs", "0");
                    xSUXSchemaHandler2.addAttribute("maxOccurs", "unbounded");
                    xSUXSchemaHandler2.addAttribute(NULLABLE, XSTRUE);
                    if (this.collIdAttrName != null) {
                        xSUXSchemaHandler2.startAttribute(this.collIdAttrName, "xsd:integer");
                        xSUXSchemaHandler2.endAttribute();
                    }
                    xSUXSchemaHandler2.endElement();
                }
            }
            xSUXSchemaHandler2.endCType();
        }
    }

    private void genColumnSchema(XSUXSchemaHandler xSUXSchemaHandler, OracleColumnName oracleColumnName, String string, String string2) {
        if (oracleColumnName.getColumnType() == -10) {
            OracleCursorName oracleCursorName = (OracleCursorName)oracleColumnName;
            xSUXSchemaHandler.startCTypeElement(this.convCase(oracleColumnName.getLabel()));
            if (oracleCursorName.isIncomplete) {
                xSUXSchemaHandler.addTheAnyElement();
                xSUXSchemaHandler.addTheAnyAttribute();
            } else {
                xSUXSchemaHandler.startCTypeElement(this.convCase(oracleColumnName.getLabel()) + "_" + this.convCase(ROW_TAG));
                xSUXSchemaHandler.addAttribute("minOccurs", "0");
                xSUXSchemaHandler.addAttribute("maxOccurs", "unbounded");
                xSUXSchemaHandler.startAttribute(this.convCase(ROWCOUNT), xSUXSchemaHandler.getQTypeName(2));
                xSUXSchemaHandler.endAttribute();
                for (int i = 0; i < oracleCursorName.colCount; ++i) {
                    this.genColumnSchema(xSUXSchemaHandler, oracleCursorName.curColNames[i], this.useNullAttrId ? null : "0", null);
                }
                xSUXSchemaHandler.endCTypeElement();
            }
            xSUXSchemaHandler.endCTypeElement();
        } else if (OracleXMLDataSet.isString(oracleColumnName.getColumnType())) {
            xSUXSchemaHandler.addStringElement(this.convCase(oracleColumnName.getLabel()), oracleColumnName.scale, false, oracleColumnName.isAttribute);
        } else if (oracleColumnName.isAttribute) {
            xSUXSchemaHandler.startAttribute(this.convCase(oracleColumnName.getLabel()), this.genSchDT(xSUXSchemaHandler, oracleColumnName));
            xSUXSchemaHandler.endAttribute();
        } else {
            xSUXSchemaHandler.startElement(this.convCase(oracleColumnName.getLabel()), this.genSchDT(xSUXSchemaHandler, oracleColumnName));
            if (oracleColumnName.getColumnType() == 2006) {
                xSUXSchemaHandler.startAttribute(this.refAttrName, xSUXSchemaHandler.getQTypeName(12));
                xSUXSchemaHandler.addAttribute("fixed", (String)oracleColumnName.getBaseTypeObj());
                xSUXSchemaHandler.endAttribute();
            }
            if (oracleColumnName.isNullable) {
                xSUXSchemaHandler.addAttribute(NULLABLE, XSTRUE);
            }
            if (string != null) {
                xSUXSchemaHandler.addAttribute("minOccurs", string);
            }
            if (string2 != null) {
                xSUXSchemaHandler.addAttribute("maxOccurs", string2);
            }
            xSUXSchemaHandler.endElement();
        }
    }

    private String genSchDT(XSUXSchemaHandler xSUXSchemaHandler, OracleColumnName oracleColumnName) {
        int n = oracleColumnName.getColumnType();
        if (n == 2002 || n == 2003) {
            String string = (String)oracleColumnName.getBaseTypeObj();
            String string2 = this.dset.getTypesSchema(string);
            xSUXSchemaHandler.addNamespace(string2, ORANS + string2);
            return string2 + ":" + OracleXMLDataSet.getTypesName(string);
        }
        return xSUXSchemaHandler.getQTypeName(n);
    }

    public void setMetaHeader(Reader reader) {
        this.metaHeader = reader;
        this.DTDString = null;
        if (this.metaHeader == null) {
            return;
        }
        try {
            this.metaHeader.mark(Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            this.setException(iOException);
        }
    }

    public void setDataHeader(Reader reader, String string) {
        this.dataHeader = reader;
        String string2 = this.docTag = string == null ? DOC_T : string;
        if (this.dataHeader == null) {
            return;
        }
        try {
            this.dataHeader.mark(Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            this.setException(iOException);
        }
    }

    public void setDocType(int n) {
        this.docType = n;
    }

    public void setMiscFlags(int n) {
        this.miscFlags |= n;
    }

    public void clearMiscFlags(int n) {
        this.miscFlags &= ~n;
    }

    public static StringBuffer ReaderToStrBuf(Reader reader, StringBuffer stringBuffer) throws IOException {
        int n;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(100);
        }
        char[] cArray = new char[100];
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer;
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) throws SQLException {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < 1 || stringArray2 == null || stringArray2.length < 1) {
            throw new OracleXMLSQLException("parse: " + msg.getMessage1("XSUE-0001", msg.getMessage0("XSUE-0007")));
        }
        int n = string.length();
        int n2 = string.indexOf("\"");
        int n3 = string.indexOf("\"", n2 + 1);
        int n4 = -1;
        if (n2 < 0) {
            n4 = string.indexOf(".");
            if (n4 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n4);
            stringArray2[0] = string.substring(n4 + 1);
            return true;
        }
        if (n2 == 0) {
            if (n3 == n - 1) {
                stringArray2[0] = string.substring(n2 + 1, n3);
                return false;
            }
            n4 = string.indexOf(".", n3);
            stringArray[0] = string.substring(n2 + 1, n3);
            n2 = string.indexOf("\"", n4);
            n3 = string.indexOf("\"", n2 + 1);
            if (n2 < 0) {
                stringArray2[0] = string.substring(n4 + 1);
                return true;
            }
            stringArray2[0] = string.substring(n2 + 1, n3);
            return true;
        }
        n4 = string.indexOf(".");
        stringArray[0] = string.substring(0, n4);
        stringArray2[0] = string.substring(n2 + 1, n3);
        return true;
    }

    private void validateNames() {
        if (!this.namesValid) {
            this.rowCountStr = OracleXMLConvert.validateName(this.rowCountStr, this.miscFlags);
            this.rowsetTag = OracleXMLConvert.validateName(this.rowsetTag, this.miscFlags);
            this.rowTag = OracleXMLConvert.validateName(this.rowTag, this.miscFlags);
            this.namesValid = true;
        }
        if (!this.rootNodeSupplied || this.dataHeader != null) {
            if (this.rowsetTag == null && this.rowTag == null) {
                if (this.colCount != 1 || this.xElemCnt != 1) {
                    throw new OracleXMLSQLException(msg.getMessage0("XSUE-0005"), this.errTag);
                }
                this.useColumnLabelAsRoot = true;
            } else if (this.rowsetTag == null) {
                this.rowsetTag = this.rowTag;
                this.rowTag = null;
                this.rowCountStr = null;
            }
        }
    }

    private static String sqlToXmlName(String string) {
        try {
            if (xmlValidate == null) {
                xmlValidate = new XmlValidate();
            }
            return xmlValidate.SqlToXmlName(string, (short)1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0021"));
        }
    }

    public static String xmlToSqlName(String string) {
        try {
            if (xmlValidate == null) {
                xmlValidate = new XmlValidate();
            }
            return xmlValidate.XmlToSqlName(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0021"));
        }
    }

    public static String validateName(String string, int n) {
        if (string == null) {
            return null;
        }
        if ((n & 4) != 0) {
            return OracleXMLConvert.sqlToXmlName(string);
        }
        if ((n & 1) != 0) {
            return string;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.' || c == ':') continue;
            throw new OracleXMLSQLException(msg.getMessage1("XSUE-0008", string.substring(i, i + 1)));
        }
        return string;
    }
}

