/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Random;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import sun.security.action.GetPropertyAction;

public abstract class Util {
    private static EnvironOptions envopts = (EnvironOptions)Ide.getSettings().getData("environment-options");
    private static final Object tmpFileLock;
    private static int counter;
    private static URL tmpdir;

    public static String getIdeNewLineChar() {
        int n = envopts.getLineTerminator();
        if (n == 1) {
            return "\r\n";
        }
        if (n == 3) {
            return "\r";
        }
        if (n == 2) {
            return "\n";
        }
        return System.getProperty("line.separator");
    }

    private static URL generateURL(String string, String string2, URL uRL) throws IOException {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return URLFactory.newURL((URL)uRL, (String)(string + Integer.toString(++counter) + string2));
    }

    private static URL getTempDir() {
        if (tmpdir == null) {
            GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
            String string = AccessController.doPrivileged(getPropertyAction);
            tmpdir = URLFactory.newDirURL((String)string);
        }
        return tmpdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getTempFile(String string, String string2, URL uRL) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        String string3 = string2 == null ? ".tmp" : string2;
        Object object = tmpFileLock;
        synchronized (object) {
            URL uRL2;
            if (uRL == null) {
                uRL = Util.getTempDir();
            }
            while (URLFileSystem.exists((URL)(uRL2 = Util.generateURL(string, string3, uRL)))) {
            }
            return uRL2;
        }
    }

    static {
        envopts.addChangeListener((ChangeListener)new EOLSettingChangeListener());
        tmpFileLock = new Object();
        counter = -1;
    }

    static class EOLSettingChangeListener
    implements ChangeListener {
        EOLSettingChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            envopts = (EnvironOptions)Ide.getSettings().getData("environment-options");
        }
    }
}

