/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.classloader.CodeSourceVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Resource {
    private static Logger logger = Logger.getLogger(Resource.class.getName());
    public static boolean DEV_MODE = false;
    public static String devDir = null;
    public static String home = System.getenv("HOME");
    public static File raptorDir;
    public static File raptorUser;
    public static File raptorUserTmp;

    public static boolean saveUserDocument(String string, OutputStream outputStream) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getUserDoucment(String string) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        InputStream inputStream = null;
        try {
            String string2 = raptorDir.getAbsolutePath() + File.separator + string;
            try {
                File file = new File(string2);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not load requested file:" + string);
            }
            dOMParser.parse(inputStream);
        }
        catch (SAXException sAXException) {
            ExceptionHandler.handleException(sAXException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return dOMParser.getDocument();
    }

    public static Document getDoucment(Class clazz, String string) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(Resource.getResourceAsStream(clazz, string));
        }
        catch (SAXException sAXException) {
            ExceptionHandler.handleException(sAXException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        return dOMParser.getDocument();
    }

    public static synchronized File getResource(Class clazz, String string) {
        String string2 = System.getProperty("raptor.devdir");
        File file = null;
        if (string2 == null) {
            string2 = System.getenv("raptor.devdir");
        }
        if (devDir == null && string2 != null) {
            DEV_MODE = true;
            devDir = string2 + File.separator;
        }
        if (DEV_MODE) {
            file = new File(devDir + string);
        }
        if (file == null || !file.exists()) {
            file = new File(clazz.getResource(string).getFile());
        }
        return file;
    }

    public static synchronized URL[] getPath(String string) {
        URL[] uRLArray = new URL[]{};
        String string2 = System.getProperty("raptor.devdir");
        if (string2 == null) {
            string2 = System.getenv("raptor.devdir");
        }
        if (devDir == null && string2 != null) {
            DEV_MODE = true;
            devDir = string2 + File.separator;
            uRLArray = new URL[]{URLFactory.newFileURL((String)string2)};
        } else {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader instanceof PolicyClassLoader) {
                V v = new V(string);
                ((PolicyClassLoader)classLoader).visitCodeSources((CodeSourceVisitor)v, false);
                uRLArray = v.getURLs();
            } else if (classLoader instanceof URLClassLoader) {
                URLPath uRLPath = new URLPath();
                for (URL uRL : ((URLClassLoader)classLoader).getURLs()) {
                    if (URLFileSystem.isDirectoryPath((URL)uRL)) {
                        uRLPath.add(uRL);
                        continue;
                    }
                    uRLPath.add(URLFactory.newJarURL((URL)uRL, null));
                }
            } else {
                uRLArray = new URL[]{classLoader.getResource(string)};
            }
        }
        return uRLArray;
    }

    public static synchronized InputStream getResourceAsStream(Class clazz, String string) {
        String string2 = System.getProperty("raptor.devdir");
        if (string2 == null) {
            string2 = System.getenv("raptor.devdir");
        }
        if (devDir == null && string2 != null) {
            DEV_MODE = true;
            devDir = string2 + File.separator;
        }
        if (DEV_MODE) {
            logger.info("Reading  XML:" + devDir + File.separator + string + "\n");
        }
        InputStream inputStream = null;
        try {
            File file = Resource.getResource(clazz, string);
            inputStream = file.exists() && file.canRead() ? new FileInputStream(file) : clazz.getResourceAsStream(string);
        }
        catch (IOException iOException) {
            System.err.println("Could not load requested file:" + string);
            Logger.getLogger(Resource.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return inputStream;
    }

    static {
        if (home == null) {
            home = System.getenv("HOMEPATH");
        }
        File file = new File(Ide.getUserSettingsDirectory());
        File file2 = new File(home + File.separator + ".sqldeveloper");
        if (file2.exists()) {
            File file3 = null;
            for (String string : file2.list()) {
                file3 = new File(file.getAbsoluteFile() + File.separator + string);
                if (!string.endsWith(".xml") || file3.exists()) continue;
                try {
                    int n;
                    FileReader fileReader = new FileReader(file2.getAbsoluteFile() + File.separator + string);
                    FileWriter fileWriter = new FileWriter(file.getAbsoluteFile() + File.separator + string);
                    char[] cArray = new char[8192];
                    while ((n = fileReader.read(cArray)) != -1) {
                        fileWriter.write(cArray, 0, n);
                    }
                    fileWriter.close();
                    fileReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(Resource.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        raptorUser = file;
        raptorUserTmp = new File(file + File.separator + "tmp");
        if (!raptorUserTmp.exists()) {
            raptorUserTmp.mkdir();
        }
    }

    private static class V
    implements CodeSourceVisitor {
        private String m_pkg;
        private List<URL> m_urls = new ArrayList<URL>();

        private V(String string) {
            this.m_pkg = string;
        }

        public boolean visit(SharedCodeSource sharedCodeSource, PolicyClassLoader policyClassLoader) {
            try {
                for (String string : sharedCodeSource.listPackagePaths()) {
                    File file;
                    if (!this.m_pkg.equals(string) || (file = sharedCodeSource.getFile()) == null) continue;
                    URL uRL = URLFactory.newFileURL((File)file);
                    if (!file.isDirectory()) {
                        uRL = URLFactory.newJarURL((URL)uRL, null);
                    }
                    this.m_urls.add(URLFactory.newDirURL((URL)uRL, (String)string));
                }
            }
            catch (IOException iOException) {
                logger.severe(iOException.getLocalizedMessage());
            }
            return true;
        }

        public URL[] getURLs() {
            return this.m_urls.toArray(new URL[0]);
        }
    }
}

