/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public abstract class RaptorHashStructureAdapter
extends HashStructureAdapter {
    private static Logger LOGGER = Logger.getLogger(RaptorHashStructureAdapter.class.getName());

    protected abstract String getRootKey();

    protected static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            return string;
        }
    }

    protected static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            return string;
        }
    }

    protected RaptorHashStructureAdapter(HashStructure hashStructure) {
        super(hashStructure);
    }

    protected HashStructure getRootHash() {
        String string = this.getRootKey();
        return this._hash.getOrCreateHashStructure(string);
    }
}

