/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ide.extension.ElementName;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DatabaseFeature;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DatabaseFeatureRegistry {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-feature";
    private static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-feature", "sqldev-feature-hook");
    private static Map<Connection, Map<String, Boolean>> s_features = new WeakHashMap<Connection, Map<String, Boolean>>();
    private static Map<String, DatabaseFeature> s_knownFeatures;

    public static boolean isFeatureEnabled(Connection connection, String string) {
        Map<String, Boolean> map = s_features.get(connection);
        return map != null && map.get(string) != false;
    }

    private static Map<String, DatabaseFeature> getFeatures() {
        if (s_knownFeatures == null) {
            s_knownFeatures = DatabaseFeatureRegistry.loadFeatures();
        }
        return Collections.unmodifiableMap(s_knownFeatures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, DatabaseFeature> loadFeatures() {
        HashMap<String, DatabaseFeature> hashMap = new HashMap<String, DatabaseFeature>();
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
        if (hashStructureHook != null) {
            HashMap<String, DatabaseFeature> hashMap2 = new HashMap<String, DatabaseFeature>();
            QueryFeatures queryFeatures = null;
            List list = hashStructureHook.getHashStructure().getAsList("feature-descriptor");
            if (list != null) {
                for (Object e : list) {
                    HashStructure hashStructure = (HashStructure)e;
                    String string = HashStructureHook.getText((HashStructure)hashStructure);
                    URL uRL = DatabaseFeatureRegistry.class.getResource(string);
                    if (uRL == null) continue;
                    InputStream inputStream = null;
                    try {
                        XMLNode[] xMLNodeArray;
                        DOMParser dOMParser = new DOMParser();
                        dOMParser.setPreserveWhitespace(false);
                        inputStream = uRL.openStream();
                        dOMParser.parse(inputStream);
                        XMLDocument xMLDocument = dOMParser.getDocument();
                        Node node = xMLDocument.getFirstChild();
                        for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"feature")) {
                            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"id");
                            Node node2 = XMLHelper.getChildNode((Node)xMLNode, (String)"queries");
                            if (node2 != null) {
                                if (!(node2 instanceof XMLNode)) continue;
                                if (queryFeatures == null) {
                                    queryFeatures = new QueryFeatures();
                                }
                                queryFeatures.registerFeature(string2, (XMLNode)node2);
                                hashMap.put(string2, queryFeatures);
                                continue;
                            }
                            node2 = XMLHelper.getChildNode((Node)xMLNode, (String)"classname");
                            if (node2 == null) continue;
                            String string3 = null;
                            Node node3 = node2.getFirstChild();
                            if (node3 instanceof Text) {
                                string3 = node3.getTextContent();
                            }
                            if (!ModelUtil.hasLength(string3)) continue;
                            DatabaseFeature databaseFeature = (DatabaseFeature)hashMap2.get(string3);
                            if (databaseFeature == null) {
                                Class<DatabaseFeature> clazz = Class.forName(string3).asSubclass(DatabaseFeature.class);
                                databaseFeature = clazz.newInstance();
                                hashMap2.put(string3, databaseFeature);
                            }
                            hashMap.put(string2, databaseFeature);
                        }
                    }
                    catch (Exception exception) {
                        Logger.severe(DatabaseFeatureRegistry.class, (String)("Error parsing file " + uRL.toString()), (Throwable)exception);
                        exception.printStackTrace();
                    }
                    finally {
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return hashMap;
    }

    public static void initializeFeatures(Connection connection) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, DatabaseFeature> entry : DatabaseFeatureRegistry.getFeatures().entrySet()) {
            String string = entry.getKey();
            DatabaseFeature databaseFeature = entry.getValue();
            hashMap.put(string, databaseFeature.isFeatureEnabled(connection, string));
        }
        s_features.put(connection, hashMap);
    }

    public static void cleanupFeatures(Connection connection) {
        s_features.remove(connection);
    }

    private static class QueryFeatures
    implements DatabaseFeature {
        private Map<String, ObjectQueries> m_queries = new HashMap<String, ObjectQueries>();

        private QueryFeatures() {
        }

        void registerFeature(String string, XMLNode xMLNode) {
            ObjectQueries objectQueries = new ObjectQueries(xMLNode);
            this.m_queries.put(string, objectQueries);
        }

        @Override
        public boolean isFeatureEnabled(Connection connection, String string) {
            Query query;
            ObjectQueries objectQueries = this.m_queries.get(string);
            if (objectQueries != null && (query = objectQueries.getQuery(connection)) != null) {
                String string2 = query.getSql();
                DBUtil dBUtil = DBUtil.getInstance(connection);
                return dBUtil.executeReturnOneCol(string2) != null;
            }
            return false;
        }
    }
}

