/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import com.sleepycat.je.Transaction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.query.db.QueryDB;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.sql.Datum;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryUtils {
    private static Logger LOGGER = Logger.getLogger(QueryUtils.class.getName());
    private static MessageDigest _digest;
    private static final String DBA_PREFIX = "dba_";

    public static List<Bind> getNodeBinds(Node node) {
        return QueryUtils.getNodeBinds(node, "binds", null);
    }

    public static List<Bind> getNodeBinds(Node node, XLIFFHelper xLIFFHelper) {
        return QueryUtils.getNodeBinds(node, "binds", xLIFFHelper);
    }

    public static List<Bind> getNodeBinds(Node node, String string, XLIFFHelper xLIFFHelper) {
        XMLNode[] xMLNodeArray;
        ArrayList<Bind> arrayList = new ArrayList<Bind>();
        Node node2 = XMLHelper.getChildNode((Node)node, (String)string);
        if (node2 == null) {
            return arrayList;
        }
        for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes((Node)node2, (String)"bind")) {
            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"id");
            String string3 = XMLHelper.getNodeValue((Node)xMLNode, (String)"type");
            String string4 = XMLHelper.getNodeValue((Node)xMLNode, (String)"prompt");
            String string5 = XMLHelper.getNodeValue((Node)xMLNode, (String)"value");
            String string6 = XMLHelper.getNodeValue((Node)xMLNode, (String)"tooltip");
            if (xLIFFHelper != null) {
                string4 = xLIFFHelper.getTranslation(string4);
                string6 = xLIFFHelper.getTranslation(string6);
            }
            Bind bind = new Bind(string2, string3, string4, string5, string6);
            bind.setSortable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"sortable")));
            bind.setFilterable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"filterable")));
            arrayList.add(bind);
        }
        return arrayList;
    }

    public static Query getQuery(Node node) {
        return QueryUtils.getQuery(node, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Query getQuery(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        Object object;
        String string = null;
        try {
            object = LOGGER;
            synchronized (object) {
                if (_digest == null) {
                    _digest = MessageDigest.getInstance("SHA");
                }
            }
            string = new String(_digest.digest(node.getTextContent().getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        object = null;
        if (!QueryDB.getDatabase().containsChecksum(string)) {
            String string2;
            String string3 = XMLHelper.getAttributeNode((Node)node, (String)"sharedId");
            if (string3 != null && !string3.equals("")) {
                object = QueryCache.getQuery(string3);
            }
            if ((string2 = XMLHelper.getAttributeNode((Node)node, (String)"id")) != null && !string2.equals("") && (object = QueryCache.getQuery(string2)) != null) {
                ((Query)object).buildQuery(node, xLIFFHelper, null);
            }
            if (object == null) {
                object = new Query(node, xLIFFHelper, transaction);
            }
        } else {
            object = new Query(node, xLIFFHelper, transaction);
        }
        return object;
    }

    public static List<Column> getNodeCols(Node node) {
        XMLNode[] xMLNodeArray;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"columns");
        if (node2 == null) {
            return arrayList;
        }
        for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes((Node)node2, (String)"column")) {
            String string = XMLHelper.getNodeValue((Node)xMLNode, (String)"colName");
            if (string != null) {
                string = string.trim();
            }
            if (!ModelUtil.hasLength((String)string)) continue;
            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"align");
            String string3 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"valign");
            String string4 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"colFormat");
            Column column = new Column(string, string2, string3, string4);
            column.setType(XMLHelper.getNodeValue((Node)xMLNode, (String)"type"));
            column.setID(XMLHelper.getAttributeNode((Node)xMLNode, (String)"id"));
            column.setSortable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"sortable")));
            column.setFilterable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"filterable")));
            column.setDefaultFilter(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"defaultFilter")));
            column.setEditable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"isEditable")));
            column.setHidden(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, (String)"hidden")));
            column.setCellEditor(XMLHelper.getAttributeNode((Node)xMLNode, (String)"cellEditor"));
            column.setCellRenderer(XMLHelper.getAttributeNode((Node)xMLNode, (String)"cellRenderer"));
            column.setCellPopup(XMLHelper.getAttributeNode((Node)xMLNode, (String)"cellPopup"));
            arrayList.add(column);
        }
        return arrayList;
    }

    public static List<Query> getQueries(Node node) {
        return QueryUtils.getQueries(node, null);
    }

    public static List<Query> getQueries(Node node, Transaction transaction) {
        List<Object> list = null;
        if (node != null) {
            String string = XMLHelper.getAttributeNode((Node)node, (String)"sharedId");
            if (string != null && !string.equals("")) {
                list = QueryCache.getQueries(string);
            }
            if (list == null) {
                list = new ArrayList();
                XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"query");
                for (XMLNode object2 : xMLNodeArray) {
                    Query query = Query.getQuery((Node)object2, null, transaction);
                    list.add(query);
                }
                List<Bind> list2 = QueryUtils.getNodeBinds(node);
                List<Column> list3 = QueryUtils.getNodeCols(node);
                List<Bind> list4 = QueryUtils.getNodeBinds(node, "optionalBinds", null);
                for (Query query : list) {
                    Iterator<Object> iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        Bind bind = (Bind)iterator.next();
                        query.addBind(bind);
                    }
                    for (Column column : list3) {
                        query.addColumn(column);
                    }
                    for (Bind bind : list4) {
                        query.addOptionalBind(bind);
                    }
                }
                String string2 = XMLHelper.getAttributeNode((Node)node, (String)"id");
                if (string2 != null && !string2.equals("")) {
                    QueryCache.putQuery(string2, list);
                }
            }
        }
        return list;
    }

    public static Query getQuery(List<Query> list, String string) {
        return QueryUtils.getQuery(list, string, false);
    }

    public static Query getQuery(List<Query> list, String string, boolean bl) {
        Query query = null;
        try {
            query = QueryUtils.getQuery(list, DBUtil.getConnectionResolver().getConnection(string), bl, false);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
        }
        return query;
    }

    public static Query getQuery(List<Query> list, Connection connection) {
        return QueryUtils.getQuery(list, connection, false, false);
    }

    public static Query getQuery(List<Query> list, Connection connection, boolean bl, boolean bl2) {
        Object object;
        ArrayList<Query> arrayList = new ArrayList<Query>();
        for (Query object22 : list) {
            if (!QueryUtils.hasRequiredFeatures(connection, object22.getRequiredFeatures()) || !DBUtil.checkVersion(connection, object22.getMaxversion(), object22.getMinversion())) continue;
            object = (List)arrayList.clone();
            VersionComp versionComp = new VersionComp();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Query query = (Query)iterator.next();
                if (versionComp.compare(object22.getMinversion(), query.getMinversion()) == 1) {
                    arrayList.remove(query);
                    if (arrayList.contains(object22)) continue;
                    arrayList.add(object22);
                    continue;
                }
                if (versionComp.compare(object22.getMinversion(), query.getMinversion()) != 0) continue;
                if (object22.getRequiredObjects() != null) {
                    arrayList.add(0, object22);
                    continue;
                }
                arrayList.add(object22);
            }
            if (arrayList.size() != 0) continue;
            arrayList.add(object22);
        }
        boolean bl3 = false;
        if (!DBUtil.getConnectionResolver().isOracle(connection)) {
            try {
                DatabaseMetaData exception = connection.getMetaData();
                object = exception.getDatabaseProductName();
                if (((String)object).indexOf("TimesTen") != -1) {
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((bl || QueryUtils.calledfromObjectViewer()) && !bl3) {
            QueryUtils.prependDbaVersion(arrayList);
        }
        if (arrayList.size() == 1 && (arrayList.get(0).getRequiredObjects() == null || arrayList.get(0).getRequiredObjects().size() == 0)) {
            return arrayList.get(0);
        }
        Object var6_11 = null;
        Query query = QueryUtils.checkNonOracleAccess(connection, arrayList, bl2);
        return query;
    }

    public static boolean hasRequiredFeatures(Connection connection, String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (QueryUtils.hasRequiredFeature(connection, string)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasRequiredFeature(Connection connection, String string) {
        boolean bl = (string = string.trim()).startsWith("!");
        if (bl) {
            string = string.substring(1);
        }
        return string.length() == 0 || bl ^ DatabaseFeatureRegistry.isFeatureEnabled(connection, string);
    }

    private static boolean hasDBAQuery(Query query) {
        Set<String> set = query.getRequiredObjects();
        if (set != null) {
            for (String string : set) {
                int n = string.indexOf(46);
                if (n > 0) {
                    string = string.substring(n + 1);
                }
                if (string.length() <= DBA_PREFIX.length() || !string.substring(0, DBA_PREFIX.length()).equalsIgnoreCase(DBA_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    private static void prependDbaVersion(List<Query> list) {
        boolean bl = false;
        for (Query object : list) {
            if (!QueryUtils.hasDBAQuery(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            LinkedList linkedList = new LinkedList();
            for (Query query : list) {
                Query query2;
                String string = query.getSql();
                if (string == null) continue;
                boolean bl2 = QueryUtils.matchesAnyPrefix(string, new String[]{"all_", "user_"});
                boolean bl3 = QueryUtils.matchesAnyPostfix(string, new String[]{"col_privs"});
                if (!bl2 || bl3 || (query2 = query.dbaVersion()) == null) continue;
                linkedList.add(query2);
            }
            list.addAll(0, linkedList);
        }
    }

    private static boolean matchesAnyPrefix(String string, String[] stringArray) {
        List list = LexerToken.parse((String)string);
        for (LexerToken lexerToken : list) {
            String string2 = lexerToken.content.toUpperCase();
            for (String string3 : stringArray) {
                if (!string2.startsWith(string3.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchesAnyPostfix(String string, String[] stringArray) {
        List list = LexerToken.parse((String)string);
        for (LexerToken lexerToken : list) {
            String string2 = lexerToken.content.toUpperCase();
            for (String string3 : stringArray) {
                if (!string2.endsWith(string3.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean calledfromObjectViewer() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        boolean bl = false;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.toString();
            if (string.contains("oviewer")) {
                bl = true;
            }
            if (!string.contains("ViewerEditorAddin.getEditorWeight")) continue;
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query checkNonOracleAccess(Connection connection, ArrayList<Query> arrayList, boolean bl) {
        if (arrayList.size() == 0) {
            return null;
        }
        Query query = null;
        if (connection == null) {
            return arrayList.get(0);
        }
        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
        boolean bl2 = false;
        if (!bl) {
            bl2 = connectionResolver.lock(connection);
        }
        if (bl || bl2) {
            try {
                DBUtil dBUtil = DBUtil.getInstance(connection);
                for (Query query2 : arrayList) {
                    Set<String> set = query2.getRequiredObjects();
                    if (set != null) {
                        boolean bl3 = true;
                        for (String string : set) {
                            if (bl) {
                                TriStateBoolean triStateBoolean = dBUtil.hasAccessCached(string);
                                if (!triStateBoolean.isTrue()) {
                                    if (triStateBoolean.isFalse()) {
                                        bl3 = false;
                                        break;
                                    }
                                    Query query3 = null;
                                    return query3;
                                }
                                bl3 = true;
                                continue;
                            }
                            if (dBUtil.hasAccess(string)) continue;
                            bl3 = false;
                            break;
                        }
                        if (!bl3) continue;
                        query = query2;
                        break;
                    }
                    if (query != null) continue;
                    query = query2;
                }
            }
            finally {
                if (bl2) {
                    connectionResolver.unlock(connection);
                }
            }
        }
        return query;
    }

    public static void loadFile(String string, BufferedOutputStream bufferedOutputStream) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            File file;
            InputStream inputStream = QueryUtils.class.getResourceAsStream(string.trim());
            if (inputStream == null && (file = new File(string.trim())).exists()) {
                inputStream = new FileInputStream(file);
            }
            dOMParser.parse(inputStream);
            file = dOMParser.getDocument();
            NodeList nodeList = file.selectNodes("//query");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XMLElement xMLElement = (XMLElement)nodeList.item(i);
                if (xMLElement.getAttribute("id") == null || xMLElement.getAttribute("id").equals("")) continue;
                LOGGER.info(Messages.getString("QueryUtils.36") + xMLElement.getNodeName() + ":" + xMLElement.getAttribute("id") + "\n");
                try {
                    bufferedOutputStream.write((Messages.getString("QueryUtils.40") + xMLElement.getAttribute("id") + "\n").getBytes());
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.43"), iOException);
                }
                QueryUtils.getQuery((Node)xMLElement);
            }
        }
        catch (XMLParseException xMLParseException) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.44"), xMLParseException);
        }
        catch (SAXException sAXException) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.45"), sAXException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.46"), iOException);
        }
        catch (XSLException xSLException) {
            LOGGER.log(Level.WARNING, Messages.getString("QueryUtils.47"), xSLException);
        }
    }

    public static String expandQuery(String string, Map<String, Object> map) {
        String string2 = string;
        if (map != null) {
            for (String string3 : map.keySet()) {
                if (string2.toUpperCase().indexOf("#" + string3.toUpperCase() + "#") <= 0) continue;
                string2 = QueryUtils.subHashMark(string2, string3, map.get(string3));
            }
        }
        return string2;
    }

    private static String subHashMark(String string, String string2, Object object) {
        if (object == null) {
            object = "";
        }
        if (object instanceof Datum) {
            try {
                object = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        String string3 = string;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = null;
        String string5 = object.toString();
        if (string5.indexOf(36) > 0) {
            for (int i = 0; i < string5.length(); ++i) {
                if (string5.charAt(i) == '$') {
                    stringBuilder.append("\\" + string5.charAt(i));
                    continue;
                }
                stringBuilder.append(string5.charAt(i));
            }
            string4 = stringBuilder.toString();
        } else {
            string4 = string5;
        }
        try {
            string3 = string3.replaceAll("((?i)#" + string2 + "#)", string4);
            string3 = string3.replaceAll("((?i)#\"" + string2 + "\"#)", "\"" + string4 + "\"");
            string3 = string3.replaceAll("((?i)#," + string2 + "#)", string4 == "" ? "" : "," + string4);
            string3 = string3.replaceAll("((?i)#,\"" + string2 + "\"#)", string4 == "" ? "" : ",\"" + string4 + "\"");
            string3 = string3.replaceAll("((?i)#esc(" + string2 + ")#)", string4 == "" ? "" : string4.replaceAll("'", "''"));
        }
        catch (Exception exception) {
            Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string3;
    }

    private static class VersionComp
    implements Comparator<Version> {
        private VersionComp() {
        }

        @Override
        public int compare(Version version, Version version2) {
            if (version == null) {
                return version2 == null ? 0 : -1;
            }
            return version2 == null ? 1 : version.compareTo((Object)version2);
        }
    }
}

