/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.log.LogManager;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleConnection;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleNLSProvider
extends DefaultNLSProvider {
    private static final String NLS_COMP = "NLS_COMP";
    private static final String NLS_SORT = "NLS_SORT";
    private static final String NLS_LENGTH_SEMANTICS = "NLS_LENGTH_SEMANTICS";
    private static final String NLS_ISO_CURRENCY = "NLS_ISO_CURRENCY";
    private static final String NLS_CURRENCY = "NLS_CURRENCY";
    private static final String NLS_DATE_LANGUAGE = "NLS_DATE_LANGUAGE";
    private static final String SESSION_TIMEZONE_OFFSET = "SESSION_TIMEZONE_OFFSET";
    private static final String SESSION_TIMEZONE = "SESSION_TIMEZONE";
    private static final String NLS_DATE_FORMAT = "NLS_DATE_FORMAT";
    private static final String NLS_NUMERIC_CHARACTERS = "NLS_NUMERIC_CHARACTERS";
    private static final String NLS_CHARACTERSET = "NLS_CHARACTERSET";
    private static final String NLS_TIMESTAMP_TZ_FORMAT = "NLS_TIMESTAMP_TZ_FORMAT";
    private static final String DB_TIMEZONE = "DB_TIMEZONE";
    private static final String NLS_TERRITORY = "NLS_TERRITORY";
    private static final String NLS_LANGUAGE = "NLS_LANGUAGE";
    private static final String NLS_TIMESTAMP_FORMAT = "NLS_TIMESTAMP_FORMAT";
    private static final String ALTER_SESSION = "alter session set {0}=''{1}''";
    private static final Logger LOGGER = Logger.getLogger(OracleNLSProvider.class.getName());
    private Map<String, String> nlsMappings = null;
    private Map<String, String> s_defaults = new HashMap<String, String>();

    public OracleNLSProvider(Connection connection) {
        super(connection);
    }

    private boolean apply(String string, String string2) {
        boolean bl = false;
        String string3 = this.getValue(string);
        if (this.requiresSetting(string, string2)) {
            String string4 = this.getAlterSession(string2, string3);
            DBUtil dBUtil = DBUtil.getInstance(this.getConnection());
            dBUtil.setRaiseError(false);
            dBUtil.execute(string4, new HashMap());
            bl = true;
        }
        return bl;
    }

    private boolean apply(TimeZone timeZone) {
        try {
            String string = timeZone.getID();
            if (string != null) {
                if (string.length() > 3 && (string.startsWith("GMT+") || string.startsWith("GMT-"))) {
                    string = string.substring(3);
                }
                ((OracleConnection)this.getConnection()).setSessionTimeZone(string);
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }

    @Override
    public String format(Object object) {
        if (object instanceof BigDecimal) {
            return this.formatBigDecimal((BigDecimal)object);
        }
        if (object instanceof DATE) {
            return this.formatDate((DATE)object);
        }
        if (object instanceof java.util.Date) {
            try {
                object = new DATE(object);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return this.formatDate((DATE)object);
        }
        if (object instanceof NUMBER) {
            return this.formatNUMBER((NUMBER)object);
        }
        if (object instanceof BINARY_DOUBLE) {
            return this.formatBINARY_DOUBLE((BINARY_DOUBLE)object);
        }
        if (object instanceof BINARY_FLOAT) {
            return this.formatBINARY_FLOAT((BINARY_FLOAT)object);
        }
        if (object instanceof TIMESTAMP) {
            return this.formatTIMESTAMP((TIMESTAMP)object);
        }
        if (object instanceof TIMESTAMPLTZ) {
            return this.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object);
        }
        if (object instanceof TIMESTAMPTZ) {
            return this.formatTIMESTAMPTZ((TIMESTAMPTZ)object);
        }
        return object.toString();
    }

    private String formatBigDecimal(BigDecimal bigDecimal) {
        String string = null;
        string = bigDecimal.toPlainString();
        if (string.indexOf(46) != -1) {
            char c = this.getDecimalSeparator();
            string = bigDecimal.toPlainString();
            if (c != '.') {
                string = string.replace('.', c);
            }
        }
        return string;
    }

    public String formatDate(DATE dATE) {
        String string = null;
        OraDATEFormat oraDATEFormat = this.getOraDATEFormat();
        string = oraDATEFormat == null ? dATE.stringValue() : oraDATEFormat.format(dATE);
        return string;
    }

    private String formatNUMBER(NUMBER nUMBER) {
        String string = null;
        string = nUMBER.stringValue();
        if (string.indexOf(46) != -1) {
            try {
                string = this.formatBigDecimal(nUMBER.bigDecimalValue());
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return string;
    }

    private String formatBINARY_DOUBLE(BINARY_DOUBLE bINARY_DOUBLE) {
        String string = null;
        string = bINARY_DOUBLE.stringValue();
        if (string.indexOf(46) != -1) {
            try {
                string = this.formatBigDecimal(this.getBigDecimal(bINARY_DOUBLE));
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return string;
    }

    private String formatBINARY_FLOAT(BINARY_FLOAT bINARY_FLOAT) {
        String string = null;
        string = bINARY_FLOAT.stringValue();
        if (string.indexOf(46) != -1) {
            try {
                string = this.formatBigDecimal(this.getBigDecimal(bINARY_FLOAT));
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return string;
    }

    private BigDecimal getBigDecimal(BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        return bINARY_FLOAT != null ? new BigDecimal(bINARY_FLOAT.stringValue()) : null;
    }

    private BigDecimal getBigDecimal(BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        return bINARY_DOUBLE != null ? new BigDecimal(bINARY_DOUBLE.stringValue()) : null;
    }

    private String formatTIMESTAMP(TIMESTAMP tIMESTAMP) {
        String string = null;
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(map.get(NLS_TIMESTAMP_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
            map.put(NLS_TIMESTAMP_FORMAT, oraTIMESTAMPFormat.toPattern());
            string = oraTIMESTAMPFormat.format(tIMESTAMP);
        }
        catch (ParseException parseException) {
            LOGGER.severe(Messages.getString("OracleNLSProvider.18") + map.get(NLS_TIMESTAMP_FORMAT));
        }
        return string;
    }

    private String formatTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
        String string = null;
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(map.get(NLS_TIMESTAMP_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)), map.get(DB_TIMEZONE));
            string = oraTIMESTAMPFormat.format(tIMESTAMPLTZ, this.getSessionTimeZone());
        }
        catch (ParseException parseException) {
            LOGGER.severe(Messages.getString("OracleNLSProvider.19") + map.get(NLS_TIMESTAMP_FORMAT));
        }
        return string;
    }

    private String formatTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
        String string = null;
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat(map.get(NLS_TIMESTAMP_TZ_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
            map.put(NLS_TIMESTAMP_TZ_FORMAT, oraTIMESTAMPTZFormat.toPattern());
            string = oraTIMESTAMPTZFormat.format(tIMESTAMPTZ);
        }
        catch (ParseException parseException) {
            LOGGER.severe(Messages.getString("OracleNLSProvider.20") + map.get(NLS_TIMESTAMP_TZ_FORMAT));
        }
        return string;
    }

    public Number parseNumber(String string) {
        Number number = null;
        if (string != null) {
            char c = this.getDecimalSeparator();
            number = string.indexOf(c) != -1 ? new BigDecimal(string.replace(c, '.')) : new BigInteger(string);
        }
        return number;
    }

    @Override
    public String getDBCharset() {
        return this.getNLSMap().get(NLS_CHARACTERSET);
    }

    public String getDBLanguage() {
        return this.getNLSMap().get(NLS_LANGUAGE);
    }

    public String getDBTerritory() {
        return this.getNLSMap().get(NLS_TERRITORY);
    }

    public String getDBTimeZone() {
        return this.getNLSMap().get(DB_TIMEZONE);
    }

    @Override
    public char getDecimalSeparator() {
        String string = this.getNLSMap().get(NLS_NUMERIC_CHARACTERS);
        return string.substring(0, 1).charAt(0);
    }

    @Override
    public char getGroupSeparator() {
        String string = this.getNLSMap().get(NLS_NUMERIC_CHARACTERS);
        return string.substring(1, 2).charAt(0);
    }

    @Override
    public String getDateFormat() {
        return this.getNLSMap().get(NLS_DATE_FORMAT);
    }

    @Override
    public String getTimeStampWithTimeZoneFormat() {
        return this.getNLSMap().get(NLS_TIMESTAMP_TZ_FORMAT);
    }

    @Override
    public String getTimeStampFormat() {
        return this.getNLSMap().get(NLS_TIMESTAMP_FORMAT);
    }

    public String getDBDateLanguage() {
        return this.getNLSMap().get(NLS_DATE_LANGUAGE);
    }

    private Map<String, String> getNLSMap() {
        if (this.nlsMappings == null) {
            this.populateNLS();
        }
        return this.nlsMappings;
    }

    public OraDATEFormat getOraDATEFormat() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraDATEFormat oraDATEFormat = new OraDATEFormat(map.get(NLS_DATE_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
            return oraDATEFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraDATEFormat getOraDATEFormatDefault() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraDATEFormat oraDATEFormat = new OraDATEFormat(map.get(NLS_DATE_FORMAT), OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraDATEFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(map.get(NLS_TIMESTAMP_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
            return oraTIMESTAMPFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormatDefault() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(map.get(NLS_TIMESTAMP_FORMAT), OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraTIMESTAMPFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPLTZFormat() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(map.get(NLS_TIMESTAMP_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)), map.get(DB_TIMEZONE));
            return oraTIMESTAMPFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPLTZFormatDefault() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(map.get(NLS_TIMESTAMP_FORMAT), OraLocaleInfo.getInstance((Locale)Locale.US), map.get(DB_TIMEZONE));
            return oraTIMESTAMPFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat(map.get(NLS_TIMESTAMP_TZ_FORMAT), OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
            return oraTIMESTAMPTZFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormatDefault() {
        Map<String, String> map = this.getNLSMap();
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat(map.get(NLS_TIMESTAMP_TZ_FORMAT), OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraTIMESTAMPTZFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TimeZone getSessionTimeZone() {
        TimeZone timeZone = null;
        Map<String, String> map = this.getNLSMap();
        String string = map.get(SESSION_TIMEZONE);
        if (string.charAt(0) == '+' || string.charAt(0) == '-') {
            string = "GMT" + string;
        }
        if ((timeZone = TimeZone.getTimeZone(string)).getID().equals("GMT") && !string.equals("GMT")) {
            String string2 = "GMT" + map.get(SESSION_TIMEZONE_OFFSET);
            byte[] byArray = string2.getBytes();
            if (byArray[byArray.length - 1] == 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            timeZone = TimeZone.getTimeZone(string2);
        }
        return timeZone;
    }

    @Override
    public String getSQL(Object object) {
        return object.toString();
    }

    @Override
    public Object getValue(Object object) {
        if (object == null) {
            return object;
        }
        String string = "";
        try {
            string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof Timestamp ? this.formatTIMESTAMP(new TIMESTAMP((Timestamp)object)) : (object instanceof TIMESTAMP ? this.formatTIMESTAMP((TIMESTAMP)object) : (object instanceof TIMESTAMPTZ ? this.formatTIMESTAMPTZ((TIMESTAMPTZ)object) : (object instanceof TIMESTAMPLTZ ? this.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object) : (object instanceof DATE ? this.formatDate((DATE)object) : (object instanceof Date ? this.formatDate(new DATE((Date)object)) : (object instanceof NUMBER ? this.formatNUMBER((NUMBER)object) : (object instanceof BINARY_DOUBLE ? this.formatBINARY_DOUBLE((BINARY_DOUBLE)object) : (object instanceof BINARY_FLOAT ? this.formatBINARY_FLOAT((BINARY_FLOAT)object) : (object instanceof BigDecimal ? this.formatBigDecimal((BigDecimal)object) : (object instanceof INTERVALDS ? ((INTERVALDS)object).toString() : (object instanceof INTERVALYM ? ((INTERVALDS)object).toString() : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))))))))))))));
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    private String getValue(String string) {
        return this.s_defaults.get(string);
    }

    @Override
    public void initConnection() {
        this.setNlsFromPrefs();
        this.populateNLS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateNLS() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/utils/loadNLS.xml");
            Query query = queryXMLSupport.getQuery("loadnls", this.getConnection());
            if (this.nlsMappings == null) {
                this.nlsMappings = new HashMap<String, String>();
            }
            statement = this.getConnection().prepareStatement(query.getSql());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                this.nlsMappings.put(resultSet.getString(1), resultSet.getString(2));
                LOGGER.fine(Messages.getString("OracleNLSProvider.28") + resultSet.getString(1) + "=" + resultSet.getString(2));
            }
        }
        catch (Exception exception) {
            LOGGER.severe(Messages.getString("OracleNLSProvider.30") + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean requiresSetting(String string, String string2) {
        String string3 = this.getValue(string);
        String string4 = this.getNLSMap().get(string2);
        if (string2 != null && string3 != null && string4 != null) {
            LOGGER.fine(Messages.getString("OracleNLSProvider.31") + string2 + ":" + string3 + ":" + string4);
        }
        return string3 != null && !string3.equals("") && !string3.equals(string4);
    }

    @Override
    public void setNlsFromPrefs() {
        String string;
        String string2 = "";
        String string3 = this.getValue("NLS_SKIP");
        if (Boolean.parseBoolean(string3)) {
            return;
        }
        DBUtil dBUtil = DBUtil.getInstance(this.getConnection());
        dBUtil.setRaiseError(false);
        Version version = DBUtil.getDbVersion(this.getConnection());
        Map<String, String> map = this.getNLSMap();
        boolean bl = this.apply("NLS_LANG", NLS_LANGUAGE);
        bl |= this.apply("NLS_TERR", NLS_TERRITORY);
        bl |= this.apply(NLS_SORT, NLS_SORT);
        if (this.requiresSetting(NLS_COMP, NLS_COMP)) {
            if (version.compareTo((Object)new Version("9")) < 0) {
                LogManager.getIdeLogWindow().log((Object)(NLS_COMP + Messages.getString("OracleNLSProvider.38")));
            } else if (version.compareTo((Object)new Version("10.2")) < 0) {
                string2 = this.getAlterSession(NLS_COMP, "ANSI");
                LogManager.getIdeLogWindow().log((Object)(NLS_COMP + Messages.getString("OracleNLSProvider.41")));
            } else {
                string = this.getValue(NLS_COMP);
                string2 = this.getAlterSession(NLS_COMP, string);
            }
            dBUtil.execute(string2, new HashMap());
            bl = true;
        }
        bl |= this.apply("NLS_DATE_LANG", NLS_DATE_LANGUAGE);
        bl |= this.apply("NLS_DATE_FORM", NLS_DATE_FORMAT);
        bl |= this.apply("NLS_TS_FORM", NLS_TIMESTAMP_FORMAT);
        if (this.requiresSetting("NLS_TS_TZ_FORM", NLS_TIMESTAMP_TZ_FORMAT)) {
            string2 = this.getAlterSession(NLS_TIMESTAMP_TZ_FORMAT, this.getValue("NLS_TS_TZ_FORM"));
            if (version.compareTo((Object)new Version("9")) < 0) {
                LogManager.getIdeLogWindow().log((Object)(NLS_TIMESTAMP_TZ_FORMAT + Messages.getString("OracleNLSProvider.43")));
            } else {
                dBUtil.execute(string2, new HashMap());
                bl = true;
            }
        }
        string = map.get(NLS_NUMERIC_CHARACTERS);
        String string4 = this.getValue("NLS_DEC_SEP");
        String string5 = this.getValue("NLS_GRP_SEP");
        if (!(string == null || string4 == null || string5 == null || string4.equals("") || string5.equals("") || string.equals(string4 + string5) || string4.equals(string5))) {
            string2 = this.getAlterSession(NLS_NUMERIC_CHARACTERS, string4 + string5);
            dBUtil.execute(string2, new HashMap());
            bl = true;
        }
        bl |= this.apply("NLS_CURR", NLS_CURRENCY);
        bl |= this.apply("NLS_ISO_CURR", NLS_ISO_CURRENCY);
        if (this.requiresSetting("NLS_LENGTH", NLS_LENGTH_SEMANTICS)) {
            string2 = this.getAlterSession(NLS_LENGTH_SEMANTICS, this.getValue("NLS_LENGTH"));
            if (version.compareTo((Object)new Version("9")) < 0) {
                LogManager.getIdeLogWindow().log((Object)(NLS_COMP + Messages.getString("OracleNLSProvider.47")));
            } else {
                dBUtil.execute(string2, new HashMap());
                bl = true;
            }
        }
        if (bl |= this.apply(this.getSessionTimeZone())) {
            this.populateNLS();
        }
    }

    @Override
    public void updateDefaults(Map<String, String> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                this.s_defaults.put(string, map.get(string));
            }
        }
    }

    private String getAlterSession(String string, String string2) {
        if (string2 != null) {
            string2 = string2.replaceAll("'", "''");
        }
        return MessageFormat.format(ALTER_SESSION, string, string2);
    }
}

