/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

public class OraTIMESTAMPFormat
extends OraSimpleDateFormat
implements OraConstants {
    private TimeZone UTC = TimeZone.getTimeZone("UTC");
    private OraLocaleInfo localeInfo = null;
    private TimeZone dbTimeZone;

    public OraTIMESTAMPFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        this(string, oraLocaleInfo, null);
    }

    public OraTIMESTAMPFormat(String string, OraLocaleInfo oraLocaleInfo, String string2) throws ParseException {
        super(string, oraLocaleInfo);
        this.localeInfo = oraLocaleInfo;
        this.applyPattern(string);
        if (string2 != null) {
            if (string2.charAt(0) == '+' || string2.charAt(0) == '-') {
                this.dbTimeZone = TimeZone.getTimeZone("GMT" + string2);
                if (this.dbTimeZone == null) {
                    throw new ParseException(Messages.getString("OraTIMESTAMPFormat.2") + string2 + "", 0);
                }
            } else {
                this.dbTimeZone = TimeZone.getTimeZone(string2);
                if (this.dbTimeZone == null) {
                    throw new ParseException(Messages.getString("OraTIMESTAMPFormat.4") + string2 + "", 0);
                }
            }
        } else {
            this.dbTimeZone = null;
        }
    }

    public void applyPattern(String string) throws ParseException {
        if (this.localeInfo != null) {
            int n;
            int n2;
            boolean bl = false;
            String string2 = string.toUpperCase(Locale.US);
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = -1;
            while ((n3 = string2.indexOf("X", n3 + 1)) >= 0) {
                if (n3 > 0 && string2.charAt(n3 - 1) == 'F') continue;
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                stringBuffer.setCharAt(n3, this.localeInfo.getOraTerritory().getDecimalCharacter().charAt(0));
            }
            n3 = -1;
            while ((n3 = string2.indexOf("SP", n3 + 1)) >= 0) {
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                stringBuffer.setCharAt(n3, '\uffff');
                stringBuffer.setCharAt(n3 + 1, '\uffff');
                bl = true;
            }
            n3 = -1;
            while ((n3 = string2.indexOf("TH", n3 + 1)) >= 0) {
                if (n3 > 2 && string2.substring(n3 - 3, n3 + 2).equals("MONTH")) continue;
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                stringBuffer.setCharAt(n3, '\uffff');
                stringBuffer.setCharAt(n3 + 1, '\uffff');
                bl = true;
            }
            n3 = -1;
            while ((n3 = string2.indexOf("TZ", n3 + 1)) >= 0 && n3 <= string2.length() - 3) {
                char c = string2.charAt(n3 + 2);
                if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
                n2 = -1;
                n = 0;
                while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                    ++n;
                }
                if (n % 2 != 0) continue;
                throw new ParseException(Messages.getString("OraTIMESTAMPFormat.11"), n3);
            }
            super.applyPattern(bl ? stringBuffer.toString().replace("\uffff", "") : stringBuffer.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPFormat && super.equals(object);
    }

    public String format(TIMESTAMP tIMESTAMP) {
        return this.format(tIMESTAMP, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMP tIMESTAMP, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        byte[] byArray = tIMESTAMP.shareBytes();
        if (byArray.length != 7 && byArray.length != 11) {
            throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPFormat.14"));
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.clear();
        calendar.setTimeZone(this.UTC);
        int n = OraConversions.convertYear(byArray);
        calendar.set(1, n);
        calendar.set(2, byArray[2] - 1);
        calendar.set(5, byArray[3]);
        calendar.set(11, byArray[4] - 1);
        calendar.set(12, byArray[5] - 1);
        calendar.set(13, byArray[6] - 1);
        calendar.set(14, 0);
        int n2 = 0;
        if (byArray.length == 11) {
            n2 = OraConversions.convertNanos(byArray);
        }
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n2);
        this.calendar.setTimeZone(this.UTC);
        return super.format((Date)timestamp, stringBuffer, fieldPosition);
    }

    public String format(TIMESTAMPLTZ tIMESTAMPLTZ, TimeZone timeZone) {
        return this.format(tIMESTAMPLTZ, new StringBuffer(), new FieldPosition(1000), timeZone).toString();
    }

    public StringBuffer format(TIMESTAMPLTZ tIMESTAMPLTZ, StringBuffer stringBuffer, FieldPosition fieldPosition, TimeZone timeZone) {
        byte[] byArray = tIMESTAMPLTZ.shareBytes();
        if (byArray.length != 7 && byArray.length != 11) {
            throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPFormat.15"));
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.clear();
        if (this.dbTimeZone == null) {
            throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPFormat.16"));
        }
        calendar.setTimeZone(this.dbTimeZone);
        int n = OraConversions.convertYear(byArray);
        calendar.set(1, n);
        calendar.set(2, byArray[2] - 1);
        calendar.set(5, byArray[3]);
        calendar.set(11, byArray[4] - 1);
        calendar.set(12, byArray[5] - 1);
        calendar.set(13, byArray[6] - 1);
        calendar.set(14, 0);
        int n2 = 0;
        if (byArray.length == 11) {
            n2 = OraConversions.convertNanos(byArray);
        }
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n2);
        this.calendar.setTimeZone(timeZone);
        return super.format((Date)timestamp, stringBuffer, fieldPosition);
    }

    public TIMESTAMP parseTIMESTAMP(String string, ParsePosition parsePosition) {
        this.calendar.setTimeZone(this.UTC);
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(string, parsePosition);
        long l = date.getTime();
        int n = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
        byte[] byArray = n > 0 ? new byte[11] : new byte[7];
        Calendar calendar = Calendar.getInstance(this.UTC, Locale.US);
        calendar.setTimeInMillis(l);
        int n2 = calendar.get(1);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        if (n > 0) {
            byArray[7] = (byte)(n >> 24 & 0xFF);
            byArray[8] = (byte)(n >> 16 & 0xFF);
            byArray[9] = (byte)(n >> 8 & 0xFF);
            byArray[10] = (byte)(n & 0xFF);
        }
        return new TIMESTAMP(byArray);
    }

    public TIMESTAMPLTZ parseTIMESTAMPLTZ(String string, ParsePosition parsePosition) {
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(string, parsePosition);
        long l = date.getTime();
        int n = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
        byte[] byArray = n > 0 ? new byte[11] : new byte[7];
        Calendar calendar = Calendar.getInstance(this.dbTimeZone, Locale.US);
        calendar.setTimeInMillis(l);
        int n2 = calendar.get(1);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        if (n > 0) {
            byArray[7] = (byte)(n >> 24 & 0xFF);
            byArray[8] = (byte)(n >> 16 & 0xFF);
            byArray[9] = (byte)(n >> 8 & 0xFF);
            byArray[10] = (byte)(n & 0xFF);
        }
        return new TIMESTAMPLTZ(byArray);
    }
}

