/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;

public class OraDATEFormat
extends OraSimpleDateFormat
implements OraConstants {
    private TimeZone UTC = TimeZone.getTimeZone("UTC");

    public OraDATEFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        super(string, oraLocaleInfo);
    }

    public void applyPattern(String string) throws ParseException {
        int n;
        int n2;
        boolean bl = false;
        String string2 = string.toUpperCase(Locale.US);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = -1;
        while ((n3 = string2.indexOf("SP", n3 + 1)) >= 0) {
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            stringBuffer.setCharAt(n3, '\uffff');
            stringBuffer.setCharAt(n3 + 1, '\uffff');
            bl = true;
        }
        n3 = -1;
        while ((n3 = string2.indexOf("TH", n3 + 1)) >= 0) {
            if (n3 > 2 && string2.substring(n3 - 3, n3 + 2).equals("MONTH")) continue;
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            stringBuffer.setCharAt(n3, '\uffff');
            stringBuffer.setCharAt(n3 + 1, '\uffff');
            bl = true;
        }
        n3 = -1;
        while ((n3 = string2.indexOf("X", n3 + 1)) >= 0) {
            if (n3 > 0 && string2.charAt(n3 - 1) == 'F') continue;
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraDATEFormat.5"), n3);
        }
        n3 = -1;
        while ((n3 = string2.indexOf("FF", n3 + 1)) >= 0) {
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraDATEFormat.7"), n3);
        }
        n3 = -1;
        while ((n3 = string2.indexOf("TZ", n3 + 1)) >= 0 && n3 <= string2.length() - 3) {
            char c = string2.charAt(n3 + 2);
            if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraDATEFormat.9"), n3);
        }
        super.applyPattern(bl ? stringBuffer.toString().replace("\uffff", "") : stringBuffer.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraDATEFormat && super.equals(object);
    }

    public String format(DATE dATE) {
        return this.format(dATE, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(DATE dATE, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        byte[] byArray = dATE.shareBytes();
        if (byArray.length != 7) {
            throw new IllegalArgumentException(Messages.getString("OraDATEFormat.12"));
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.clear();
        calendar.setTimeZone(this.UTC);
        int n = OraConversions.convertYear(byArray);
        if (n < 0) {
            calendar.set(0, 0);
        }
        if (n > 0) {
            calendar.set(0, 1);
        }
        calendar.set(1, Math.abs(n));
        calendar.set(2, byArray[2] - 1);
        calendar.set(5, byArray[3]);
        calendar.set(11, byArray[4] - 1);
        calendar.set(12, byArray[5] - 1);
        calendar.set(13, byArray[6] - 1);
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(0);
        this.calendar.setTimeZone(this.UTC);
        return super.format((Date)timestamp, stringBuffer, fieldPosition);
    }

    public DATE parseDATE(String string, ParsePosition parsePosition) {
        this.calendar.setTimeZone(this.UTC);
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(string, parsePosition);
        long l = date.getTime();
        byte[] byArray = new byte[7];
        Calendar calendar = Calendar.getInstance(this.UTC, Locale.US);
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        byArray[0] = (byte)(n / 100 + 100);
        byArray[1] = (byte)(n % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return new DATE(byArray);
    }
}

