/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.jdbc.OracleConnection;

public class NLSProvider {
    private static final Map<Object, DefaultNLSProvider> providers = new HashMap<Object, DefaultNLSProvider>();
    private static INLSSupplier _supplier;

    public static void setNLSSupplier(INLSSupplier iNLSSupplier) {
        _supplier = iNLSSupplier;
    }

    public static DefaultNLSProvider getProvider(String string) {
        if (_supplier != null && _supplier.getNLSProvider(string) != null) {
            return NLSProvider.getProvider(_supplier.getNLSProvider(string).getConnection());
        }
        return null;
    }

    public static DefaultNLSProvider getProvider(Connection connection) {
        if (providers.get(connection) == null) {
            DefaultNLSProvider defaultNLSProvider = null;
            defaultNLSProvider = _supplier != null ? _supplier.getNLSProvider(connection) : (connection instanceof OracleConnection ? new OracleNLSProvider(connection) : new DefaultNLSProvider(connection));
            if (defaultNLSProvider != null) {
                providers.put(connection, defaultNLSProvider);
            }
        }
        return providers.get(connection);
    }
}

