/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class TransparentGateway
extends CommandListener {
    private Connection _conn;
    private Set<String> links;

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        this._conn = connection;
        this.links = new HashSet<String>();
        if (iSQLCommand.getStmtType() != SQLCommand.StmtType.G_C_SQL) {
            return;
        }
        String string = iSQLCommand.getSql();
        if (string.indexOf(64) < 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(){}[]^-|!*+./><='\",;:%@? \n\r\t", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("@".equals(string2)) {
                bl = true;
                continue;
            }
            if (bl) {
                for (String string3 : DBUtil.getConnectionResolver().getConnNames()) {
                    Properties properties = DBUtil.getConnectionResolver().getConnectionInfo(string3);
                    if (!string2.equals(properties.get("ConnName"))) continue;
                    try {
                        Statement statement = connection.createStatement();
                        String string4 = "CREATE DATABASE LINK " + string2 + " \n" + "CONNECT TO " + properties.get("user") + " IDENTIFIED BY " + properties.get("password") + " \n" + "USING '(DESCRIPTION =(ADDRESS_LIST =(ADDRESS = (PROTOCOL = TCP)(HOST = " + properties.get("hostname") + ")(PORT = " + properties.get("port") + ")))(CONNECT_DATA = (SERVICE_NAME = " + properties.get("sid") + "))) '";
                        statement.execute(string4);
                        this.links.add(string2);
                        System.out.println(string4);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                }
            }
            bl = false;
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (this.links != null) {
            for (String string : this.links) {
                try {
                    Statement statement = connection.createStatement();
                    String string2 = "DROP DATABASE LINK " + string;
                    statement.execute(string2);
                    System.out.println(string2);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        }
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }
}

