/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;

public class SetCopyCommit
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_COPYCOMMIT;

    public SetCopyCommit() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)iSQLCommand.getProperty("prop_file_string");
        if (string != null && connection instanceof OracleConnection) {
            try {
                Integer n = Integer.parseInt(string);
                if (n > -1 && n < 5001) {
                    scriptRunnerContext.putProperty("script.runner.copycommit", n.toString());
                } else {
                    scriptRunnerContext.write(MessageFormat.format(Messages.getString("COPY_ARRAY_RANGE"), n.toString()) + "\n");
                }
            }
            catch (NumberFormatException numberFormatException) {
                scriptRunnerContext.write(Messages.getString("ARRAY_NUMBER_FORMAT_EXCEPTION") + "\n");
            }
            return true;
        }
        return false;
    }
}

