/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleConnection;

public class DescribePrep
extends CommandListener {
    private Connection _conn;

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) && iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE) && (connection == null || connection instanceof OracleConnection)) {
            this._conn = connection;
            this.parseDescribe(scriptRunnerContext, iSQLCommand, connection);
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    public void parseDescribe(ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand, Connection connection) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(iSQLCommand.getSql(), " .");
        String[] stringArray2 = new String[2];
        stringTokenizer.nextToken();
        stringArray2[0] = iSQLCommand.getSql().indexOf(".") > -1 ? this.upperCaseLocaleUS(scriptRunnerContext, stringTokenizer.nextToken().replaceAll("\"", "")) : "";
        try {
            stringArray2[1] = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            stringArray2[1] = "unknown_table";
        }
        stringArray2[1] = stringArray2[1].replaceAll("\n", "");
        stringArray2[1] = stringArray2[1].replaceAll("\r", "");
        stringArray2[1] = stringArray2[1].replaceAll(";", "");
        String string = this.getObjType(stringArray2[1], stringArray2[0]);
        if (string.indexOf("\n") > -1) {
            string = string.split("\n")[0];
        }
        if (string.equals("SYNONYM")) {
            stringArray = this.getBaseSynonymObj(stringArray2[1], stringArray2[0]);
            string = stringArray[2];
            stringArray2[0] = stringArray[0];
            stringArray2[1] = stringArray[1];
        }
        stringArray = ScriptRunnerDbArb.getString("DISPLAY_NAME");
        String string2 = ScriptRunnerDbArb.getString("DISPLAY_NULL");
        String string3 = ScriptRunnerDbArb.getString("DISPLAY_TYPE");
        String string4 = ScriptRunnerDbArb.getString("DISPLAY_ARGUMENT_NAME");
        String string5 = ScriptRunnerDbArb.getString("DISPLAY_DEFAULT");
        stringArray2[1] = stringArray2[1].indexOf("\"") > -1 ? stringArray2[1].replaceAll("\"", "") : this.upperCaseLocaleUS(scriptRunnerContext, stringArray2[1].replaceAll("\"", ""));
        String string6 = "";
        String[] stringArray3 = DBUtil.resolveDBLink(stringArray2[1]);
        if (stringArray3 != null) {
            string6 = "@" + stringArray3[1];
            if (stringArray2[0].equals("")) {
                stringArray2[0] = this.getDBLinkOwner(stringArray2[1], "");
            }
            stringArray2[1] = stringArray3[0];
        }
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/newscriptrunner/ScriptParserQueries.xml");
        Query query = null;
        String string7 = null;
        String string8 = null;
        boolean bl = true;
        Object[] objectArray = null;
        String string9 = null;
        if (string.equals("TABLE") || string.equals("VIEW") || string.endsWith("MATERIALIZED VIEW")) {
            string9 = "DESC_TABLE_VIEW";
            objectArray = new Object[]{string6, stringArray, string2, string3, string8};
        } else if (string.startsWith("PACKAGE")) {
            string9 = this.isDefaultDetailsAvailable() ? "DESC_PACKAGE_WITH_ARGS_DEFAULTS" : "DESC_PACKAGE_WITHOUT_ARGS_DEFAULTS";
            objectArray = new Object[]{string6, string4, string3, string5, string8};
        } else if (string.equals("FUNCTION") || string.equals("PROCEDURE")) {
            string9 = this.isDefaultDetailsAvailable() ? "DESC_PROC_FUNC_WITH_ARGS_DEFAULTS" : "DESC_PROC_FUNC_WITHOUT_ARGS_DEFAULTS";
            objectArray = new Object[]{string6, string4, string3, string5, string8};
        } else if (string.startsWith("TYPE")) {
            string9 = "DESC_TYPE";
            objectArray = !stringArray2[0].equals("") ? new Object[]{string6, " UPPER(owner)= UPPER(:1) and "} : new Object[]{string6, ""};
        } else {
            iSQLCommand.setSql("select '" + ScriptRunnerDbArb.format("CANNOT_DESCRIBE_ERROR", stringArray2[1]) + "' \"ERROR:\"  from dual");
            bl = false;
        }
        if (bl) {
            query = queryXMLSupport.getQuery(string9, connection);
            string7 = query.getSql().replaceAll("'", "''");
            string8 = !stringArray2[0].equals("") ? ":1" : "sys_context('USERENV', 'CURRENT_SCHEMA')";
            objectArray[objectArray.length - 1] = string8;
            string7 = MessageFormat.format(string7, objectArray);
            iSQLCommand.setSql(string7);
            if (!stringArray2[0].equals("")) {
                iSQLCommand.addBind(stringArray2[0]);
                iSQLCommand.addBind(stringArray2[1]);
            } else {
                iSQLCommand.addBind(stringArray2[1]);
            }
        }
        iSQLCommand.setStmtClass(SQLCommand.StmtType.G_C_SQL);
        iSQLCommand.setResultsType(SQLCommand.StmtResultType.G_R_QUERY);
    }

    private String getDBLinkOwner(String string, String string2) {
        String string3;
        String string4;
        String[] stringArray = DBUtil.resolveDBLink(string);
        if (string2.equals("") && (string4 = this.executeQuery(string3 = "select username from all_db_links where db_link=UPPER('" + stringArray[1] + "') AND username IS NOT null")) != null && !string4.equals("")) {
            return string4;
        }
        return string2;
    }

    private String getObjType(String string, String string2) {
        String string3 = null;
        String[] stringArray = DBUtil.resolveDBLink(string);
        if (stringArray != null) {
            if (string2.equals("")) {
                string2 = this.getDBLinkOwner(string, string2);
            }
            string = stringArray[0];
            string3 = " select object_type  from sys.all_objects@" + stringArray[1] + " where object_name =";
        } else {
            string3 = " select object_type  from sys.all_objects  where object_name =";
        }
        String string4 = string.replaceAll("\"", "");
        string3 = string.startsWith("\"") ? string3 + "'" + string4 + "'" : string3 + "UPPER('" + string4 + "')";
        String string5 = "";
        string5 = string2.equals("") ? string3 + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))" : string3 + " and owner= '" + string2 + "'";
        String string6 = this.executeQuery(string5);
        if (string6 == null) {
            string6 = "";
        }
        if (string2.equals("") && string6.trim().equals("")) {
            string5 = string3 + "and OBJECT_TYPE ='SYNONYM'";
            string6 = this.executeQuery(string5);
            if (string6 == null) {
                string6 = "";
            } else if (!string6.trim().equals("")) {
                string6 = "SYNONYM";
            }
        }
        if (string6.indexOf("TABLE PARTITION") != -1 || string6.indexOf("TABLE\nINDEX") != -1) {
            string6 = "TABLE";
        }
        return string6;
    }

    private boolean isDefaultDetailsAvailable() {
        String string = "select 'available' from sys.argument$ where rownum <=1";
        String string2 = this.executeQuery(string);
        return string2.equals("available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeQuery(String string) {
        String string2 = "";
        Statement statement = null;
        ResultSet resultSet = null;
        if (this._conn == null) {
            return null;
        }
        try {
            int n;
            statement = this._conn.createStatement();
            resultSet = statement.executeQuery(string);
            resultSet.next();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            if (n2 == 1) {
                string2 = string2 + resultSet.getString(1);
            } else {
                for (n = 1; n <= n2; ++n) {
                    string2 = string2 + resultSet.getString(n) + ":";
                }
            }
            while (resultSet.next()) {
                string2 = string2 + "\n";
                if (n2 == 1) {
                    string2 = string2 + resultSet.getString(1);
                    continue;
                }
                for (n = 1; n <= n2; ++n) {
                    string2 = string2 + resultSet.getString(n) + ":";
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    private String[] getBaseSynonymObj(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "select table_owner ,table_name from all_synonyms where  synonym_name = ";
        String string7 = string.replaceAll("\"", "");
        string6 = string.startsWith("\"") ? string6 + "'" + string7 + "'" : string6 + "UPPER('" + string7 + "')";
        if (!string2.trim().equals("")) {
            string6 = string6 + " and owner ='" + string2 + "'";
            string5 = this.executeQuery(string6);
        } else {
            string3 = string6 + " and (UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) )";
            string4 = string6 + " and ( owner = 'PUBLIC')";
            string5 = this.executeQuery(string3);
            if (string5 == null || string5.trim().equals("")) {
                string5 = this.executeQuery(string4);
            }
        }
        String string8 = "";
        String string9 = "";
        String string10 = "";
        if (string5 == null || string5.trim().equals("")) {
            string5 = "";
        } else {
            string8 = string5.substring(0, string5.indexOf(":"));
            string9 = string5.substring(string5.indexOf(":") + 1);
            string9 = string9.substring(0, string9.length() - 1);
            string10 = this.getObjType(string9, string8);
        }
        String[] stringArray = new String[]{string8, string9, string10};
        return stringArray;
    }

    public String upperCaseLocaleUS(ScriptRunnerContext scriptRunnerContext, String string) {
        String string2 = null;
        string2 = string == null || string.equals("") ? string : string.toUpperCase(Locale.US);
        return string2;
    }
}

