/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;

public class ScriptExecutorTask
extends RaptorTask<Void> {
    private Reader m_rdrForParser = null;
    private Connection m_connection = null;
    private ISQLCommand m_cmd = null;
    private ScriptRunner m_runner = null;
    private boolean m_interrupted = false;
    private int m_currentCommand = -1;
    private ScriptRunnerContext m_scriptRunnerContext = null;
    private BufferedOutputStream m_out = null;
    private URL m_baseURL = null;
    private Iterator<ISQLCommand> m_parser = null;
    public boolean m_finished = false;
    private String m_directory = null;
    IRaptorTaskRunMode m_runMode = null;
    Logger m_logger = Logger.getLogger(this.getClass().getName());

    public ScriptExecutorTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
        this(string, iRaptorTaskRunMode, bl, bl2, true);
    }

    public ScriptExecutorTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3) {
        super(string, bl3, iRaptorTaskRunMode);
        this.setMessage(string);
        this.setPausable(bl);
        this.setCancellable(bl2);
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
        if (this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getCurrentConnection() == null) {
            this.m_scriptRunnerContext.setCurrentConnection(connection);
        }
        if (this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getBaseConnection() == null) {
            this.m_scriptRunnerContext.setBaseConnection(connection);
        }
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public String getQuery() {
        return "";
    }

    public void setStmt(String string) {
        this.m_rdrForParser = new StringReader(string);
    }

    public void setStmt(InputStream inputStream) {
        this.setStmt(new InputStreamReader(inputStream));
    }

    public void setStmt(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.setStmt(new InputStreamReader(inputStream, string));
    }

    public void setStmt(Reader reader) {
        this.m_rdrForParser = reader;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    public BufferedOutputStream getOut() {
        return this.m_out;
    }

    public void setOut(BufferedOutputStream bufferedOutputStream) {
        this.m_out = bufferedOutputStream;
    }

    public void flushOut(boolean bl) {
        try {
            if (bl) {
                this.m_out.flush();
                this.m_out.close();
            } else {
                this.m_out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doWork() {
        try {
            this.startup();
            try {
                this.checkCanProceed();
                this.loopThroughAllStatements();
            }
            finally {
                this.cleanup();
                this.setMessage(Messages.getString("IRaptorTaskStatus.4"));
            }
        }
        catch (ExecutionException executionException) {
            boolean bl = false;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loopThroughAllStatements() throws ExecutionException {
        this.beforeLoopProcessing();
        this.m_currentCommand = -1;
        try {
            while (this.m_parser.hasNext()) {
                this.m_cmd = this.m_parser.next();
                ++this.m_currentCommand;
                this.incrementCMDCount();
                this.checkCanProceed();
                if (this.isInterupted()) continue;
                this.checkCanProceed();
                this.beforeRunStatementProcessing();
                this.run(this.m_cmd);
                this.afterRunStatementProcessing();
                if (!this.m_scriptRunnerContext.getExited()) continue;
                break;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            try {
                this.m_out.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        finally {
            if (this.m_rdrForParser != null) {
                try {
                    this.m_rdrForParser.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.afterLoopProcessing();
    }

    protected void beforeRunStatementProcessing() throws ExecutionException {
        this.m_scriptRunnerContext.putProperty("sqldev.error", Boolean.FALSE);
        this.m_scriptRunnerContext.putProperty("sqldev.last.err.message", null);
        this.m_scriptRunnerContext.setOutputStreamWrapper(this.m_out);
        this.m_scriptRunnerContext.putProperty("current_cmd_count", this.m_currentCommand);
    }

    protected void afterRunStatementProcessing() throws ExecutionException {
    }

    protected ISQLCommand getCurrentStatement() {
        if (this.m_cmd != null && this.m_currentCommand >= 0) {
            return this.m_cmd;
        }
        return null;
    }

    protected boolean wasErrorEncountered() {
        return this.m_scriptRunnerContext != null && (Boolean)this.m_scriptRunnerContext.getProperty("sqldev.error") != false;
    }

    protected String getStatementErrorMessage() {
        if (this.getCurrentStatement() != null && this.wasErrorEncountered()) {
            return (String)this.m_scriptRunnerContext.getProperty("sqldev.last.err.message");
        }
        return "";
    }

    protected void startup() throws ExecutionException {
        if (this.m_scriptRunnerContext == null) {
            this.m_scriptRunnerContext = new ScriptRunnerContext();
        }
        if (this.m_scriptRunnerContext.getTopLevel()) {
            this.m_scriptRunnerContext.setBaseConnection(this.m_connection);
            this.m_scriptRunnerContext.setCurrentConnection(this.m_connection);
        }
        if (this.m_baseURL != null) {
            this.m_scriptRunnerContext.setLastUrl(this.m_baseURL);
        }
        this.m_scriptRunnerContext.putProperty("script.runner.base.url", this.m_baseURL);
        if (this.m_out == null) {
            this.m_out = this.m_scriptRunnerContext.getOutputStream() != null ? this.m_scriptRunnerContext.getOutputStream().getMainStream() : new BufferedOutputStream(System.out);
            this.m_scriptRunnerContext.putProperty("script.runner.using.systemout", Boolean.TRUE);
        }
        this.m_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), this.m_rdrForParser);
    }

    protected void cleanup() throws ExecutionException {
        block11: {
            if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
                this.m_scriptRunnerContext.writeDisconnectWarning();
            }
            if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
                try {
                    this.m_connection.commit();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            try {
                this.m_out.flush();
            }
            catch (IOException iOException) {
                if (this.m_interrupted) break block11;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        if (this.m_scriptRunnerContext.getTopLevel()) {
            if (this.m_scriptRunnerContext.getExited()) {
                this.m_scriptRunnerContext.reInitOnExit();
            } else {
                this.m_scriptRunnerContext.reInitNoExit();
            }
        }
    }

    protected void run(ISQLCommand iSQLCommand) throws IOException {
        if (this.m_runner == null) {
            this.m_runner = new ScriptRunner(this.m_connection, this.m_out, this.m_scriptRunnerContext);
            this.m_runner.setDirectory(this.getDirectory());
        }
        this.m_runner.run(iSQLCommand);
    }

    public String getConnectionName() {
        return "";
    }

    public void setDirectory(String string) {
        this.m_directory = string;
    }

    public String getDirectory() {
        return this.m_directory;
    }

    boolean isInterupted() {
        return Thread.currentThread().isInterrupted();
    }

    @Override
    protected void checkCanProceed() throws ExecutionException {
        super.checkCanProceed();
    }

    private void incrementCMDCount() {
        int n = this.getNotNullCMDCount();
        this.m_scriptRunnerContext.putProperty("current_cmd_count", n + 1);
    }

    private int getNotNullCMDCount() {
        Integer n = (Integer)this.m_scriptRunnerContext.getProperty("current_cmd_count");
        if (n == null) {
            n = 0;
        }
        return n;
    }

    public void beforeLoopProcessing() throws ExecutionException {
        CommandRegistry.fireBeginScriptListeners(this.m_connection, this.getScriptRunnerContext());
    }

    public void afterLoopProcessing() throws ExecutionException {
        CommandRegistry.fireEndScriptListeners(this.m_connection, this.getScriptRunnerContext());
    }
}

