/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;

public class ScriptExecutor
extends Thread {
    private Reader m_rdrForParser = null;
    private Iterator<ISQLCommand> m_parser = null;
    private Connection m_conn = null;
    private ISQLCommand m_cmd = null;
    private ScriptRunner m_runner = null;
    private boolean m_interrupted = false;
    private ScriptRunnerContext m_scriptRunnerContext = null;
    private BufferedOutputStream m_out = null;
    private static final Logger LOGGER = Logger.getLogger(ScriptExecutor.class.getName());
    private URL m_baseURL = null;
    private SQLCommandRunner m_sqlCommandRunner = null;
    public boolean m_finished = false;
    private String m_directory = null;

    public ScriptExecutor(URL uRL, Connection connection) {
        try {
            this.setConn(connection);
            this.setStmt(uRL.openStream());
            this.m_baseURL = uRL;
        }
        catch (IOException iOException) {
            LOGGER.severe(Messages.getString("ScriptExecutor.0") + uRL.toString());
        }
    }

    public ScriptExecutor(InputStream inputStream, Connection connection) {
        this.setConn(connection);
        this.setStmt(inputStream);
    }

    public ScriptExecutor(String string, Connection connection) {
        this.setConn(connection);
        this.setStmt(string);
    }

    public ScriptExecutor(Reader reader, Connection connection) {
        this.setConn(connection);
        this.setStmt(reader);
    }

    public ScriptExecutor(Connection connection) {
        this.setConn(connection);
    }

    public void setConn(Connection connection) {
        this.m_conn = connection;
    }

    public Connection getConn() {
        return this.m_conn;
    }

    public void setStmt(String string) {
        this.m_rdrForParser = new StringReader(string);
    }

    public void setStmt(InputStream inputStream) {
        this.setStmt(new InputStreamReader(inputStream));
    }

    private void setStmt(Reader reader) {
        this.m_rdrForParser = reader;
    }

    @Override
    public void interrupt() {
        this.m_interrupted = true;
        if (this.m_runner != null) {
            this.m_runner.cancel();
        }
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    public void setOut(BufferedOutputStream bufferedOutputStream) {
        this.m_out = bufferedOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_scriptRunnerContext == null) {
            this.m_scriptRunnerContext = new ScriptRunnerContext();
        }
        if (this.m_scriptRunnerContext.getTopLevel()) {
            this.m_scriptRunnerContext.setBaseConnection(this.m_conn);
            this.m_scriptRunnerContext.setCurrentConnection(this.m_conn);
        }
        if (this.m_baseURL != null) {
            this.m_scriptRunnerContext.setLastUrl(this.m_baseURL);
        }
        this.m_scriptRunnerContext.putProperty("script.runner.base.url", this.m_baseURL);
        if (this.m_out == null) {
            this.m_out = this.m_scriptRunnerContext.getOutputStream() != null ? this.m_scriptRunnerContext.getOutputStream().getMainStream() : new BufferedOutputStream(System.out);
            this.m_scriptRunnerContext.putProperty("script.runner.using.systemout", Boolean.TRUE);
        }
        try {
            this.m_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), this.m_rdrForParser);
            CommandRegistry.fireBeginScriptListeners(this.m_conn, this.getScriptRunnerContext());
            int n = 0;
            while (this.m_parser.hasNext()) {
                block28: {
                    this.m_cmd = this.m_parser.next();
                    ++n;
                    try {
                        PrintWriter printWriter;
                        this.m_scriptRunnerContext.putProperty("sqldev.error", Boolean.FALSE);
                        this.m_scriptRunnerContext.putProperty("sqldev.last.err.message", null);
                        if (this.m_interrupted) {
                            break;
                        }
                        this.m_scriptRunnerContext.setOutputStreamWrapper(this.m_out);
                        this.m_scriptRunnerContext.putProperty("current_cmd_count", n);
                        this.run(this.m_cmd);
                        if (this.m_scriptRunnerContext != null && ((Boolean)this.m_scriptRunnerContext.getProperty("sqldev.error")).booleanValue() && (printWriter = this.m_scriptRunnerContext.getErrWriter()) != null) {
                            printWriter.println(this.m_cmd);
                            printWriter.println();
                            String string = (String)this.m_scriptRunnerContext.getProperty("sqldev.last.err.message");
                            string = string.replaceAll("\n", "\nREM ");
                            printWriter.println(string);
                            printWriter.println('\n');
                        }
                        if (!this.m_scriptRunnerContext.getExited()) break block28;
                        break;
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        try {
                            this.m_out.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
                this.m_finished = true;
            }
        }
        finally {
            if (this.m_rdrForParser != null) {
                try {
                    this.m_rdrForParser.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
            this.m_scriptRunnerContext.writeDisconnectWarning();
        }
        CommandRegistry.fireEndScriptListeners(this.m_conn, this.getScriptRunnerContext());
        if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
            this.m_scriptRunnerContext.closeCurrentConnection();
        }
        try {
            this.m_out.flush();
        }
        catch (IOException iOException) {
            if (!this.m_interrupted) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            this.m_interrupted = false;
        }
        if (this.m_scriptRunnerContext.getTopLevel()) {
            if (this.m_scriptRunnerContext.getExited()) {
                this.m_scriptRunnerContext.reInitOnExit();
            } else {
                this.m_scriptRunnerContext.reInitNoExit();
            }
        }
    }

    private void run(ISQLCommand iSQLCommand) throws IOException {
        if (this.m_runner == null) {
            this.m_runner = new ScriptRunner(this.m_conn, this.m_out, this.m_scriptRunnerContext);
            this.m_runner.setDirectory(this.getDirectory());
        }
        this.m_runner.run(iSQLCommand);
        if (this.getScriptRunnerContext().isDbmsEnabled()) {
            int n = 20000;
            Integer n2 = (Integer)this.getScriptRunnerContext().getProperty("script.runner.lastsetserveroutput");
            if (n2 != null && n2 > n) {
                n = n2;
            }
            ScriptExecutor.enableDbmsOutput(this.getScriptRunnerContext().getBaseConnection(), n);
            this.getScriptRunnerContext().clearDbmsFlags();
        }
    }

    public void setDirectory(String string) {
        this.m_directory = string;
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public static void enableDbmsOutput(Connection connection, int n) {
        String string = "BEGIN DBMS_OUTPUT.ENABLE(" + n + "); END;";
        CallableStatement callableStatement = null;
        try {
            if (connection == null) {
                return;
            }
            if (connection.isClosed()) {
                return;
            }
            callableStatement = connection.prepareCall(string);
            callableStatement.execute();
        }
        catch (Exception exception) {
            Logger.getLogger("ScriptExecutor").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

