/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public abstract class TemporalDatum
extends Datum {
    protected TemporalDatum(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        switch (stringType) {
            case NLS: {
                try {
                    return new StringValue((CharSequence)NLSUtils.getValue(dataTypeConnectionProvider.getNLSConnection(), dataValueInternal.getInternalValue()));
                }
                catch (NullPointerException nullPointerException) {
                    return this.customStringValue(dataTypeConnectionProvider, dataValueInternal, StringType.GENERIC, n);
                }
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return Timestamp.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        if (object instanceof Timestamp) {
            return object;
        }
        if (object instanceof TIMESTAMP) {
            try {
                return ((TIMESTAMP)object).timestampValue();
            }
            catch (SQLException sQLException) {
                return object;
            }
        }
        if (object instanceof DATE) {
            return ((DATE)object).timestampValue();
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            try {
                return Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                try {
                    return new Timestamp(java.sql.Date.valueOf(string).getTime());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return object;
    }
}

