/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.encoding.EncodingException;
import org.xml.sax.SAXException;

public class RAW
extends Datum {
    protected RAW(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        switch (stringType) {
            case NLS: {
                return new StringValue((CharSequence)NLSUtils.getValue(dataTypeConnectionProvider.getNLSConnection(), dataValueInternal.getInternalValue()));
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return byte[].class;
            }
            case DEFAULT: {
                return oracle.sql.RAW.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -2;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            if (object instanceof oracle.sql.RAW) {
                return object;
            }
            LongBinary longBinary = LongBinary.constructFrom(object, -1);
            return new oracle.sql.RAW((byte[])longBinary.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataTypeIllegalArgumentException(this, object, illegalArgumentException);
        }
        catch (EncodingException encodingException) {
            throw new DataTypeIllegalArgumentException(this, object, encodingException);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object, sQLException);
        }
        catch (IOException iOException) {
            throw new DataTypeIllegalArgumentException(this, object, iOException);
        }
    }

    @Override
    protected void customMarshallToXml(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        LongBinary longBinary = new LongBinary(((oracle.sql.RAW)dataValueInternal.getInternalValue()).getBytes());
        longBinary.marshallToXml(this, dataValueMarshallHandler, string);
    }

    @Override
    public Object startDataValue(String string, boolean bl) {
        if (bl) {
            return null;
        }
        return LongBinary.getBuilder(-1);
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, char[] cArray, int n, int n2) {
        LongBinary.LongBinaryBuilder longBinaryBuilder = (LongBinary.LongBinaryBuilder)namedValue.getValue();
        try {
            longBinaryBuilder.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
        catch (EncodingException encodingException) {
            throw new DataTypeEncodingException(encodingException);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue namedValue) {
        LongBinary.LongBinaryBuilder longBinaryBuilder = (LongBinary.LongBinaryBuilder)namedValue.getValue();
        try {
            return this.getDataValue(longBinaryBuilder != null ? (byte[])longBinaryBuilder.build().getValue() : null);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
    }
}

