/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.TemporalDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class DATE
extends TemporalDatum {
    protected DATE(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        switch (stringType) {
            case GENERIC: {
                return new StringValue(((oracle.sql.DATE)dataValueInternal.getInternalValue()).timestampValue().toString().substring(0, 19));
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return Timestamp.class;
            }
            case DEFAULT: {
                return oracle.sql.DATE.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 91;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        if (object instanceof oracle.sql.DATE) {
            return object;
        }
        if (object instanceof byte[]) {
            return new oracle.sql.DATE(Arrays.copyOf((byte[])object, ((byte[])object).length));
        }
        Object object2 = super.customInternalValue(dataTypeConnectionProvider, object);
        if (object2 instanceof Timestamp) {
            return new oracle.sql.DATE((Timestamp)object2);
        }
        return this.typedValueFromNLSString(dataTypeConnectionProvider, object2.toString());
    }

    protected oracle.sql.DATE typedValueFromNLSString(DataTypeConnectionProvider dataTypeConnectionProvider, String string) {
        OraDATEFormat oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider(dataTypeConnectionProvider.getNLSConnection())).getOraDATEFormat();
        return oraDATEFormat.parseDATE(string, new ParsePosition(0));
    }
}

