/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NumericDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class BINARY_DOUBLE
extends NumericDatum {
    protected BINARY_DOUBLE(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        Object object = dataValueInternal.getInternalValue();
        switch (stringType) {
            case GENERIC: {
                try {
                    return new StringValue(this.getGenericStringValue((oracle.sql.BINARY_DOUBLE)object));
                }
                catch (SQLException sQLException) {
                    throw new DataTypeIllegalArgumentException(this, object);
                }
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        switch (valueType) {
            case JAVA: {
                return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, ValueType.JDBC, object);
            }
            case JDBC: {
                return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, ValueType.DEFAULT, object);
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return Double.class;
            }
            case JDBC: {
                return this.customTypedClass(dataTypeConnectionProvider, ValueType.DEFAULT);
            }
            case DEFAULT: {
                return oracle.sql.BINARY_DOUBLE.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 101;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customUnscaledInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            if (object instanceof oracle.sql.BINARY_DOUBLE) {
                return object;
            }
            if (object instanceof Double) {
                return new oracle.sql.BINARY_DOUBLE((Double)object);
            }
            if (object instanceof byte[]) {
                return new oracle.sql.BINARY_DOUBLE(Arrays.copyOf((byte[])object, ((byte[])object).length));
            }
            String string = object.toString();
            if (this.isPosInf(string)) {
                return new oracle.sql.BINARY_DOUBLE(Double.POSITIVE_INFINITY);
            }
            if (this.isNegInf(string)) {
                return new oracle.sql.BINARY_DOUBLE(Double.NEGATIVE_INFINITY);
            }
            if (this.isNaN(string)) {
                return new oracle.sql.BINARY_DOUBLE(Double.NaN);
            }
            try {
                return new oracle.sql.BINARY_DOUBLE(Double.valueOf(string));
            }
            catch (Exception exception) {
                return this.typedValueFromNLSString(dataTypeConnectionProvider, string);
            }
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object);
        }
    }

    protected oracle.sql.BINARY_DOUBLE typedValueFromNLSString(DataTypeConnectionProvider dataTypeConnectionProvider, String string) throws SQLException {
        return new oracle.sql.BINARY_DOUBLE(((OracleNLSProvider)NLSProvider.getProvider(dataTypeConnectionProvider.getNLSConnection())).parseNumber(string).doubleValue());
    }

    private BigDecimal getBigDecimal(oracle.sql.BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        BigDecimal bigDecimal = null;
        if (bINARY_DOUBLE != null) {
            bigDecimal = new BigDecimal(bINARY_DOUBLE.stringValue());
        }
        return bigDecimal;
    }

    private String getGenericStringValue(oracle.sql.BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        String string = null;
        if (bINARY_DOUBLE != null) {
            string = this.getBigDecimal(bINARY_DOUBLE).toString();
        }
        return string;
    }
}

