/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.plsql;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQLDatum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingBOOLEAN;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.DataValueMapped;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class BOOLEAN
extends PLSQLDatum {
    private final DataType numberType;
    private DataValue trueValue;
    private DataValue falseValue;

    protected BOOLEAN(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
        TypeMetadata typeMetadata2 = dataTypeContext.getDataTypeFactory().getTypeMetadata(dataTypeContext.getDataTypeConnectionProvider(), (Integer)2);
        this.numberType = dataTypeContext.getDataTypeFactory().getDataType(dataTypeContext, typeMetadata2);
        this.trueValue = null;
        this.falseValue = null;
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        return new StringValue(this.internalStringValue(dataValueInternal.getInternalValue()));
    }

    private String internalStringValue(Object object) {
        String string = DataTypesUtil.stringValue(object, null);
        if (string != null) {
            Boolean bl = null;
            try {
                int n = Integer.parseInt(string);
                bl = n != 0;
            }
            catch (NumberFormatException numberFormatException) {
                bl = Boolean.valueOf(string);
            }
            string = DataTypesUtil.stringValue(bl, null);
        }
        return string;
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return Boolean.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 16;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        if (object instanceof Boolean) {
            return object;
        }
        return Boolean.valueOf(this.internalStringValue(object));
    }

    @Override
    protected String customPlainDataTypeString() {
        return "BOOLEAN";
    }

    @Override
    protected String customBaseDataTypeString() {
        return "PL/SQL BOOLEAN";
    }

    @Override
    protected DataValue customDataValue(Object object) {
        DataValue dataValue = super.customDataValue(object);
        Boolean bl = (Boolean)dataValue.getTypedValue(ValueType.DEFAULT);
        Integer n = bl == null ? null : Integer.valueOf(bl == true ? 1 : 0);
        DataValue dataValue2 = this.numberType.getDataValue(n);
        return new DataValueMapped(dataValue, dataValue2);
    }

    @Override
    public boolean isEnumeration() {
        return true;
    }

    @Override
    public List<DataValue> getEnumerationValues() {
        if (this.trueValue == null) {
            this.trueValue = this.getDataValue(Boolean.TRUE);
        }
        if (this.falseValue == null) {
            this.falseValue = this.getDataValue(Boolean.FALSE);
        }
        return new LinkedList<DataValue>(){
            {
                this.add(BOOLEAN.this.trueValue);
                this.add(BOOLEAN.this.falseValue);
            }
        };
    }

    @Override
    public <P extends DataBinding> CallableBinding<P> getBind(BindContext bindContext, P p) {
        return new CallableBindingBOOLEAN<P>(bindContext, p, this.numberType);
    }
}

